/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.util;

import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;

public class RefactoringUtils {
    public static ValidationErrors createValidationErrors(Database database, Change change) {
        ChangeSet changeSet = change.getChangeSet();
        String changeType = ((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData(change).getName();
        ValidationErrors validationErrors = new ValidationErrors();
        String message = "Changeset ID: " + changeSet.getId() + " Changeset Author: " + changeSet.getAuthor() + "\n";
        message = message + "Change Type 'pro:" + changeType + "' is not allowed for " + database.getDatabaseProductName() + ".\n";
        message = message + "You may either remove the changeset from the change log or use the dbms, labels, or context\n";
        message = message + "attributes on the changeset to control when this changeset should be executed.";
        validationErrors.addError(message);
        return validationErrors;
    }
}

