/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import java.util.Calendar;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.java.truelicense.core.codec.X500PrincipalXmlAdapter;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.obfuscate.ObfuscatedString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@XmlRootElement(name="license")
@XmlType(name="license")
@ParametersAreNullableByDefault
@Nullable
public class License {
    private int consumerAmount = 1;
    private String consumerType;
    private Object extra;
    private X500Principal holder;
    private String info;
    private Date issued;
    private X500Principal issuer;
    private Date notAfter;
    private Date notBefore;
    private String subject;

    @XmlElement(defaultValue="1")
    public final int getConsumerAmount() {
        return this.consumerAmount;
    }

    public final void setConsumerAmount(int n) {
        this.consumerAmount = n;
    }

    @XmlElement(required=true)
    public final String getConsumerType() {
        return this.consumerType;
    }

    public final void setConsumerType(String string) {
        this.consumerType = string;
    }

    public final Object getExtra() {
        return this.extra;
    }

    public final void setExtra(Object object) {
        this.extra = object;
    }

    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=X500PrincipalXmlAdapter.class)
    public final X500Principal getHolder() {
        return this.holder;
    }

    public final void setHolder(X500Principal x500Principal) {
        this.holder = x500Principal;
    }

    public final String getInfo() {
        return this.info;
    }

    public final void setInfo(String string) {
        this.info = string;
    }

    @XmlElement(required=true)
    public final Date getIssued() {
        return License.clone(this.issued);
    }

    public final void setIssued(Date date) {
        this.issued = License.clone(date);
    }

    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=X500PrincipalXmlAdapter.class)
    public final X500Principal getIssuer() {
        return this.issuer;
    }

    public final void setIssuer(X500Principal x500Principal) {
        this.issuer = x500Principal;
    }

    public final Date getNotAfter() {
        return License.clone(this.notAfter);
    }

    public final void setNotAfter(Date date) {
        this.notAfter = License.clone(date);
    }

    public final Date getNotBefore() {
        return License.clone(this.notBefore);
    }

    public final void setNotBefore(Date date) {
        this.notBefore = License.clone(date);
    }

    public final void setTerm(int n) {
        Date date = this.getIssued();
        if (null == date) {
            date = new Date();
            this.setIssued(date);
        }
        this.setNotBefore(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        this.setNotAfter(calendar.getTime());
    }

    @XmlElement(required=true)
    public final String getSubject() {
        return this.subject;
    }

    public final void setSubject(String string) {
        this.subject = string;
    }

    private static Date clone(Date date) {
        return null == date ? null : (Date)date.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof License)) {
            return false;
        }
        License license = (License)object;
        return this.getConsumerAmount() == license.getConsumerAmount() && Objects.equals(this.getConsumerType(), license.getConsumerType()) && Objects.equals(this.getExtra(), license.getExtra()) && Objects.equals(this.getHolder(), license.getHolder()) && Objects.equals(this.getInfo(), license.getInfo()) && Objects.equals(this.getIssued(), license.getIssued()) && Objects.equals(this.getIssuer(), license.getIssuer()) && Objects.equals(this.getNotAfter(), license.getNotAfter()) && Objects.equals(this.getNotBefore(), license.getNotBefore()) && Objects.equals(this.getSubject(), license.getSubject());
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.getConsumerAmount();
        n = 31 * n + Objects.hashCode(this.getConsumerType());
        n = 31 * n + Objects.hashCode(this.getExtra());
        n = 31 * n + Objects.hashCode(this.getHolder());
        n = 31 * n + Objects.hashCode(this.getInfo());
        n = 31 * n + Objects.hashCode(this.getIssued());
        n = 31 * n + Objects.hashCode(this.getIssuer());
        n = 31 * n + Objects.hashCode(this.getNotAfter());
        n = 31 * n + Objects.hashCode(this.getNotBefore());
        n = 31 * n + Objects.hashCode(this.getSubject());
        return n;
    }

    public String toString() {
        return String.format(License._string#0(), this.getClass().getName(), this.hashCode(), License.literal(this.getSubject()), License.literal(this.getHolder()), License.literal(this.getIssuer()), this.getIssued(), this.getNotBefore(), this.getNotAfter(), License.literal(this.getConsumerType()), this.getConsumerAmount(), License.literal(this.getInfo()));
    }

    @Nullable
    private static String literal(@CheckForNull Object object) {
        if (null == object) {
            return null;
        }
        String string = object.toString();
        return '\"' + string.replace(License._string#1(), License._string#2()).replace(License._string#3(), License._string#4()) + '\"';
    }

    private static /* synthetic */ String _string#0() {
        return new ObfuscatedString(new long[]{-2964854117190135410L, -3620455353335284000L, -3002977670728192493L, -4461658824024479120L, 7889941119438764023L, -4448413981346193250L, 6449595886516556148L, -5125721228151931514L, -984577074450116910L, -884208725041286933L, -6985230578816260789L, 3446562660525340051L, -511040264103646113L, 7245254436761169877L, -3227174435865073383L, 2736993353574609162L, 6165665005340991730L}).toString();
    }

    private static /* synthetic */ String _string#1() {
        return new ObfuscatedString(new long[]{7438050634666037304L, 1390264407413512067L}).toString();
    }

    private static /* synthetic */ String _string#2() {
        return new ObfuscatedString(new long[]{-1570340789237145115L, 3668926902652734172L}).toString();
    }

    private static /* synthetic */ String _string#3() {
        return new ObfuscatedString(new long[]{-6682117415403620968L, 1993941345498104362L}).toString();
    }

    private static /* synthetic */ String _string#4() {
        return new ObfuscatedString(new long[]{-9125425394032402975L, -865634447761455382L}).toString();
    }
}

