    function showRows(className) {
        let rows = document.getElementsByClassName(className)
        for (let row of rows) {
            if (row.style.display === 'none') {
                row.style.display = 'table-row'
            } else {
                row.style.display = 'none'
            }
        }
    }

    document.querySelectorAll('.copy-to-clipboard-missing')
        .forEach(element => element.addEventListener('click', (event) => {
            copyToClipboard('jsonMissing')
            event.stopPropagation()
        }, false))

    document.querySelectorAll('.copy-to-clipboard-unexpected')
        .forEach(element => element.addEventListener('click', (event) => {
            copyToClipboard('jsonUnexpected')
            event.stopPropagation()
        }, false))

    document.querySelectorAll('.copy-to-clipboard-changed')
        .forEach(element => element.addEventListener('click', (event) => {
            copyToClipboard('jsonChanged')
            event.stopPropagation()
        }, false))

    window.addEventListener('load', () => {
        showButton('target-url-button', 'target-url')
        showButton('reference-url-button', 'reference-url')
    })

    let targetUrlButton = document.getElementById('target-url-button');
    if (targetUrlButton) {
        targetUrlButton.addEventListener('click', () => copyToClipboard('target-url'))
    }

    let referenceUrlButton = document.getElementById('reference-url-button');
    if (referenceUrlButton) {
        referenceUrlButton.addEventListener('click', () => copyToClipboard('reference-url'))
    }

    function showButton(buttonElementId, urlElementId) {
        let button = document.getElementById(`${buttonElementId}`)
        let element = document.getElementById(`${urlElementId}`)
        if (element && button && element.innerText.length > 128 && button.style.display === 'none') {
            button.style.display = ''
        }
    }

    function copyToClipboard(dataId) {
        let copyText = document.getElementById(`${dataId}`);
        navigator.clipboard.writeText(copyText.innerHTML);
        showNotification();
    }

    function showNotification() {
        let x = document.getElementById("snackbar");
        x.className = "show";
        setTimeout(function () {
            x.className = x.className.replace("show", "");
        }, 3000);
    }

    document.addEventListener('DOMContentLoaded', function () {
        let targetElement = document.getElementById('sql-diff');
        let configuration = {
            drawFileList: false,
            fileListToggle: false,
            fileListStartVisible: false,
            fileContentToggle: false,
            matching: 'lines',
            outputFormat: 'side-by-side',
            synchronisedScroll: true,
            highlight: true,
            renderNothingWhenEmpty: false,
        };
        let diff2htmlUi = new Diff2HtmlUI(targetElement, document.getElementById("unifiedSqlDiff").innerHTML, configuration);
        diff2htmlUi.draw();
        diff2htmlUi.highlightCode();
    });