/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtils {
    private static final Set<String> SHOULD_NOT_PROXY_HOP_BY_HOP_HEADERS = ImmutableSet.of((Object)"Connection".toLowerCase(Locale.US), (Object)"Proxy-Authenticate".toLowerCase(Locale.US), (Object)"Proxy-Authorization".toLowerCase(Locale.US), (Object)"TE".toLowerCase(Locale.US), (Object)"Trailer".toLowerCase(Locale.US), (Object)"Upgrade".toLowerCase(Locale.US), (Object[])new String[]{"Keep-Alive".toLowerCase(Locale.US)});
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUtils.class);
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Splitter COMMA_SEPARATED_HEADER_VALUE_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static Pattern HTTP_PREFIX = Pattern.compile("^https?://.*", 2);

    public static String stripHost(String uri) {
        if (!HTTP_PREFIX.matcher(uri).matches()) {
            return uri;
        }
        String noHttpUri = StringUtils.substringAfter((String)uri, (String)"://");
        int slashIndex = noHttpUri.indexOf("/");
        if (slashIndex == -1) {
            return "/";
        }
        String noHostUri = noHttpUri.substring(slashIndex);
        return noHostUri;
    }

    public static String formatDate(Date date) {
        return ProxyUtils.formatDate(date, PATTERN_RFC1123);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.US);
        formatter.setTimeZone(GMT);
        return formatter.format(date);
    }

    public static boolean isLastChunk(HttpObject httpObject) {
        return httpObject instanceof LastHttpContent;
    }

    public static boolean isChunked(HttpObject httpObject) {
        return !ProxyUtils.isLastChunk(httpObject);
    }

    public static String parseHostAndPort(HttpRequest httpRequest) {
        String uriHostAndPort = ProxyUtils.parseHostAndPort(httpRequest.getUri());
        return uriHostAndPort;
    }

    public static String parseHostAndPort(String uri) {
        String tempUri = !HTTP_PREFIX.matcher(uri).matches() ? uri : StringUtils.substringAfter((String)uri, (String)"://");
        String hostAndPort = tempUri.contains("/") ? tempUri.substring(0, tempUri.indexOf("/")) : tempUri;
        return hostAndPort;
    }

    public static HttpResponse copyMutableResponseFields(HttpResponse original) {
        DefaultHttpResponse copy = null;
        if (original instanceof DefaultFullHttpResponse) {
            ByteBuf content = ((DefaultFullHttpResponse)original).content();
            copy = new DefaultFullHttpResponse(original.getProtocolVersion(), original.getStatus(), content);
        } else {
            copy = new DefaultHttpResponse(original.getProtocolVersion(), original.getStatus());
        }
        Set headerNames = original.headers().names();
        for (String name : headerNames) {
            List values = original.headers().getAll(name);
            copy.headers().set(name, (Iterable)values);
        }
        return copy;
    }

    public static void addVia(HttpMessage httpMessage, String alias) {
        List<String> vias;
        String newViaHeader = "" + httpMessage.getProtocolVersion().majorVersion() + '.' + httpMessage.getProtocolVersion().minorVersion() + ' ' + alias;
        if (httpMessage.headers().contains("Via")) {
            List existingViaHeaders = httpMessage.headers().getAll("Via");
            vias = new ArrayList<String>(existingViaHeaders);
            vias.add(newViaHeader);
        } else {
            vias = Collections.singletonList(newViaHeader);
        }
        httpMessage.headers().set("Via", vias);
    }

    public static boolean isTrue(String val) {
        return ProxyUtils.checkTrueOrFalse(val, "true", "on");
    }

    public static boolean isFalse(String val) {
        return ProxyUtils.checkTrueOrFalse(val, "false", "off");
    }

    public static boolean extractBooleanDefaultFalse(Properties props, String key) {
        String throttle = props.getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)throttle)) {
            return throttle.trim().equalsIgnoreCase("true");
        }
        return false;
    }

    public static boolean extractBooleanDefaultTrue(Properties props, String key) {
        String throttle = props.getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)throttle)) {
            return throttle.trim().equalsIgnoreCase("true");
        }
        return true;
    }

    public static int extractInt(Properties props, String key) {
        return ProxyUtils.extractInt(props, key, -1);
    }

    public static int extractInt(Properties props, String key, int defaultValue) {
        String readThrottleString = props.getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)readThrottleString) && NumberUtils.isNumber((String)readThrottleString)) {
            return Integer.parseInt(readThrottleString);
        }
        return defaultValue;
    }

    public static boolean isCONNECT(HttpObject httpObject) {
        return httpObject instanceof HttpRequest && HttpMethod.CONNECT.equals((Object)((HttpRequest)httpObject).getMethod());
    }

    public static boolean isHEAD(HttpRequest httpRequest) {
        return HttpMethod.HEAD.equals((Object)httpRequest.getMethod());
    }

    private static boolean checkTrueOrFalse(String val, String str1, String str2) {
        String str = val.trim();
        return StringUtils.isNotBlank((CharSequence)str) && (str.equalsIgnoreCase(str1) || str.equalsIgnoreCase(str2));
    }

    public static boolean isContentAlwaysEmpty(HttpMessage msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse res = (HttpResponse)msg;
            int code = res.getStatus().code();
            if (code >= 100 && code < 200) {
                return code != 101 || res.headers().contains("Sec-WebSocket-Accept");
            }
            switch (code) {
                case 204: 
                case 205: 
                case 304: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isHead(HttpRequest request) {
        return HttpMethod.HEAD.equals((Object)request.getMethod());
    }

    public static boolean isResponseSelfTerminating(HttpResponse response) {
        if (ProxyUtils.isContentAlwaysEmpty((HttpMessage)response)) {
            return true;
        }
        List<String> allTransferEncodingHeaders = ProxyUtils.getAllCommaSeparatedHeaderValues("Transfer-Encoding", (HttpMessage)response);
        if (!allTransferEncodingHeaders.isEmpty()) {
            String finalEncoding = allTransferEncodingHeaders.get(allTransferEncodingHeaders.size() - 1);
            return "chunked".equals(finalEncoding);
        }
        String contentLengthHeader = HttpHeaders.getHeader((HttpMessage)response, (String)"Content-Length");
        return contentLengthHeader != null && !contentLengthHeader.isEmpty();
    }

    public static List<String> getAllCommaSeparatedHeaderValues(String headerName, HttpMessage httpMessage) {
        List allHeaders = httpMessage.headers().getAll(headerName);
        if (allHeaders.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder headerValues = ImmutableList.builder();
        for (String header : allHeaders) {
            List<String> commaSeparatedValues = ProxyUtils.splitCommaSeparatedHeaderValues(header);
            headerValues.addAll(commaSeparatedValues);
        }
        return headerValues.build();
    }

    public static HttpResponse duplicateHttpResponse(HttpResponse originalResponse) {
        DefaultHttpResponse newResponse = new DefaultHttpResponse(originalResponse.getProtocolVersion(), originalResponse.getStatus());
        newResponse.headers().add(originalResponse.headers());
        return newResponse;
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (IOException e) {
            LOG.debug("Ignored exception", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.debug("Ignored exception", (Throwable)e);
        }
        LOG.info("Could not lookup localhost");
        return null;
    }

    public static boolean shouldRemoveHopByHopHeader(String headerName) {
        return SHOULD_NOT_PROXY_HOP_BY_HOP_HEADERS.contains(headerName.toLowerCase(Locale.US));
    }

    public static List<String> splitCommaSeparatedHeaderValues(String headerValue) {
        return ImmutableList.copyOf((Iterable)COMMA_SEPARATED_HEADER_VALUE_SPLITTER.split((CharSequence)headerValue));
    }

    public static boolean isUdtAvailable() {
        try {
            return NioUdtProvider.BYTE_PROVIDER != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }
}

