/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class AMDPerformanceMonitor {
    public static final int GL_COUNTER_TYPE_AMD = 35776;
    public static final int GL_COUNTER_RANGE_AMD = 35777;
    public static final int GL_UNSIGNED_INT64_AMD = 35778;
    public static final int GL_PERCENTAGE_AMD = 35779;
    public static final int GL_PERFMON_RESULT_AVAILABLE_AMD = 35780;
    public static final int GL_PERFMON_RESULT_SIZE_AMD = 35781;
    public static final int GL_PERFMON_RESULT_AMD = 35782;

    protected AMDPerformanceMonitor() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glGetPerfMonitorGroupsAMD, caps.glGetPerfMonitorCountersAMD, caps.glGetPerfMonitorGroupStringAMD, caps.glGetPerfMonitorCounterStringAMD, caps.glGetPerfMonitorCounterInfoAMD, caps.glGenPerfMonitorsAMD, caps.glDeletePerfMonitorsAMD, caps.glSelectPerfMonitorCountersAMD, caps.glBeginPerfMonitorAMD, caps.glEndPerfMonitorAMD, caps.glGetPerfMonitorCounterDataAMD});
    }

    public static native void nglGetPerfMonitorGroupsAMD(long var0, int var2, long var3);

    public static void glGetPerfMonitorGroupsAMD(IntBuffer numGroups, IntBuffer groups) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)numGroups, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorGroupsAMD(MemoryUtil.memAddressSafe((IntBuffer)numGroups), Checks.remainingSafe((Buffer)groups), MemoryUtil.memAddressSafe((IntBuffer)groups));
    }

    public static native void nglGetPerfMonitorCountersAMD(int var0, long var1, long var3, int var5, long var6);

    public static void glGetPerfMonitorCountersAMD(int group, IntBuffer numCounters, IntBuffer maxActiveCounters, IntBuffer counters) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)numCounters, (int)1);
            Checks.check((Buffer)maxActiveCounters, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCountersAMD(group, MemoryUtil.memAddress((IntBuffer)numCounters), MemoryUtil.memAddress((IntBuffer)maxActiveCounters), counters.remaining(), MemoryUtil.memAddress((IntBuffer)counters));
    }

    public static native void nglGetPerfMonitorGroupStringAMD(int var0, int var1, long var2, long var4);

    public static void glGetPerfMonitorGroupStringAMD(int group, IntBuffer length, ByteBuffer groupString) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)length, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorGroupStringAMD(group, groupString.remaining(), MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)groupString));
    }

    public static native void nglGetPerfMonitorCounterStringAMD(int var0, int var1, int var2, long var3, long var5);

    public static void glGetPerfMonitorCounterStringAMD(int group, int counter, IntBuffer length, ByteBuffer counterString) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterStringAMD(group, counter, Checks.remainingSafe((Buffer)counterString), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddressSafe((ByteBuffer)counterString));
    }

    public static native void nglGetPerfMonitorCounterInfoAMD(int var0, int var1, int var2, long var3);

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)4);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static native void nglGenPerfMonitorsAMD(int var0, long var1);

    public static void glGenPerfMonitorsAMD(IntBuffer monitors) {
        AMDPerformanceMonitor.nglGenPerfMonitorsAMD(monitors.remaining(), MemoryUtil.memAddress((IntBuffer)monitors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenPerfMonitorsAMD() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer monitors = stack.callocInt(1);
            AMDPerformanceMonitor.nglGenPerfMonitorsAMD(1, MemoryUtil.memAddress((IntBuffer)monitors));
            int n = monitors.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeletePerfMonitorsAMD(int var0, long var1);

    public static void glDeletePerfMonitorsAMD(IntBuffer monitors) {
        AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(monitors.remaining(), MemoryUtil.memAddress((IntBuffer)monitors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeletePerfMonitorsAMD(int monitor) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer monitors = stack.ints(monitor);
            AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(1, MemoryUtil.memAddress((IntBuffer)monitors));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglSelectPerfMonitorCountersAMD(int var0, boolean var1, int var2, int var3, long var4);

    public static void glSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, IntBuffer counterList) {
        AMDPerformanceMonitor.nglSelectPerfMonitorCountersAMD(monitor, enable, group, counterList.remaining(), MemoryUtil.memAddress((IntBuffer)counterList));
    }

    public static native void nglBeginPerfMonitorAMD(int var0);

    public static void glBeginPerfMonitorAMD(int monitor) {
        AMDPerformanceMonitor.nglBeginPerfMonitorAMD(monitor);
    }

    public static native void nglEndPerfMonitorAMD(int var0);

    public static void glEndPerfMonitorAMD(int monitor) {
        AMDPerformanceMonitor.nglEndPerfMonitorAMD(monitor);
    }

    public static native void nglGetPerfMonitorCounterDataAMD(int var0, int var1, int var2, long var3, long var5);

    public static void glGetPerfMonitorCounterDataAMD(int monitor, int pname, IntBuffer data, IntBuffer bytesWritten) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)bytesWritten, (int)1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterDataAMD(monitor, pname, data.remaining(), MemoryUtil.memAddress((IntBuffer)data), MemoryUtil.memAddressSafe((IntBuffer)bytesWritten));
    }

    public static void glGetPerfMonitorGroupsAMD(int[] numGroups, int[] groups) {
        long __functionAddress = GLES.getICD().glGetPerfMonitorGroupsAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])numGroups, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int[])numGroups, (int)Checks.lengthSafe((int[])groups), (int[])groups);
    }

    public static void glGetPerfMonitorCountersAMD(int group, int[] numCounters, int[] maxActiveCounters, int[] counters) {
        long __functionAddress = GLES.getICD().glGetPerfMonitorCountersAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])numCounters, (int)1);
            Checks.check((int[])maxActiveCounters, (int)1);
        }
        JNI.callPPPV((long)__functionAddress, (int)group, (int[])numCounters, (int[])maxActiveCounters, (int)counters.length, (int[])counters);
    }

    public static void glGetPerfMonitorGroupStringAMD(int group, int[] length, ByteBuffer groupString) {
        long __functionAddress = GLES.getICD().glGetPerfMonitorGroupStringAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)group, (int)groupString.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)groupString));
    }

    public static void glGetPerfMonitorCounterStringAMD(int group, int counter, int[] length, ByteBuffer counterString) {
        long __functionAddress = GLES.getICD().glGetPerfMonitorCounterStringAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)group, (int)counter, (int)Checks.remainingSafe((Buffer)counterString), (int[])length, (long)MemoryUtil.memAddressSafe((ByteBuffer)counterString));
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, int[] data) {
        long __functionAddress = GLES.getICD().glGetPerfMonitorCounterInfoAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)group, (int)counter, (int)pname, (int[])data);
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, float[] data) {
        long __functionAddress = GLES.getICD().glGetPerfMonitorCounterInfoAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)group, (int)counter, (int)pname, (float[])data);
    }

    public static void glGenPerfMonitorsAMD(int[] monitors) {
        long __functionAddress = GLES.getICD().glGenPerfMonitorsAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)monitors.length, (int[])monitors);
    }

    public static void glDeletePerfMonitorsAMD(int[] monitors) {
        long __functionAddress = GLES.getICD().glDeletePerfMonitorsAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)monitors.length, (int[])monitors);
    }

    public static void glSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, int[] counterList) {
        long __functionAddress = GLES.getICD().glSelectPerfMonitorCountersAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)monitor, (boolean)enable, (int)group, (int)counterList.length, (int[])counterList);
    }

    public static void glGetPerfMonitorCounterDataAMD(int monitor, int pname, int[] data, int[] bytesWritten) {
        long __functionAddress = GLES.getICD().glGetPerfMonitorCounterDataAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])bytesWritten, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)monitor, (int)pname, (int)data.length, (int[])data, (int[])bytesWritten);
    }

    static {
        GLES.initialize();
    }
}

