/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ANGLETranslatedShaderSource {
    public static final int GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE = 37792;

    protected ANGLETranslatedShaderSource() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glGetTranslatedShaderSourceANGLE});
    }

    public static native void nglGetTranslatedShaderSourceANGLE(int var0, int var1, long var2, long var4);

    public static void glGetTranslatedShaderSourceANGLE(int shader, IntBuffer length, ByteBuffer source) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        ANGLETranslatedShaderSource.nglGetTranslatedShaderSourceANGLE(shader, source.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetTranslatedShaderSourceANGLE(int shader, int bufsize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc((int)bufsize);
        try {
            IntBuffer length = stack.ints(0);
            ANGLETranslatedShaderSource.nglGetTranslatedShaderSourceANGLE(shader, bufsize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)source));
            String string = MemoryUtil.memUTF8((ByteBuffer)source, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)source);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetTranslatedShaderSourceANGLE(int shader) {
        int bufsize = GLES20.glGetShaderi(shader, 37792);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc((int)bufsize);
        try {
            IntBuffer length = stack.ints(0);
            ANGLETranslatedShaderSource.nglGetTranslatedShaderSourceANGLE(shader, bufsize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)source));
            String string = MemoryUtil.memUTF8((ByteBuffer)source, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)source);
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetTranslatedShaderSourceANGLE(int shader, int[] length, ByteBuffer source) {
        long __functionAddress = GLES.getICD().glGetTranslatedShaderSourceANGLE;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)shader, (int)source.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)source));
    }

    static {
        GLES.initialize();
    }
}

