/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTDebugLabel {
    public static final int GL_BUFFER_OBJECT_EXT = 37201;
    public static final int GL_SHADER_OBJECT_EXT = 35656;
    public static final int GL_PROGRAM_OBJECT_EXT = 35648;
    public static final int GL_VERTEX_ARRAY_OBJECT_EXT = 37204;
    public static final int GL_QUERY_OBJECT_EXT = 37203;
    public static final int GL_PROGRAM_PIPELINE_OBJECT_EXT = 35407;

    protected EXTDebugLabel() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glLabelObjectEXT, caps.glGetObjectLabelEXT});
    }

    public static native void nglLabelObjectEXT(int var0, int var1, int var2, long var3);

    public static void glLabelObjectEXT(int type, int object, ByteBuffer label) {
        EXTDebugLabel.nglLabelObjectEXT(type, object, label.remaining(), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glLabelObjectEXT(int type, int object, CharSequence label) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            EXTDebugLabel.nglLabelObjectEXT(type, object, labelEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetObjectLabelEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glGetObjectLabelEXT(int type, int object, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)length, (int)1);
        }
        EXTDebugLabel.nglGetObjectLabelEXT(type, object, label.remaining(), MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectLabelEXT(int type, int object, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            EXTDebugLabel.nglGetObjectLabelEXT(type, object, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
            String string = MemoryUtil.memUTF8((ByteBuffer)label, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetObjectLabelEXT(int type, int object, int[] length, ByteBuffer label) {
        long __functionAddress = GLES.getICD().glGetObjectLabelEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)type, (int)object, (int)label.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)label));
    }

    static {
        GLES.initialize();
    }
}

