/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDrawElementsBaseVertex {
    protected EXTDrawElementsBaseVertex() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps, Set<String> ext) {
        return Checks.checkFunctions((long[])new long[]{caps.glDrawElementsBaseVertexEXT, ext.contains("GLES30") ? caps.glDrawRangeElementsBaseVertexEXT : -1L, ext.contains("GLES30") ? caps.glDrawElementsInstancedBaseVertexEXT : -1L, ext.contains("GL_EXT_multi_draw_arrays") ? caps.glMultiDrawElementsBaseVertexEXT : -1L});
    }

    public static native void nglDrawElementsBaseVertexEXT(int var0, int var1, int var2, long var3, int var5);

    public static void glDrawElementsBaseVertexEXT(int mode, int count, int type, long indices, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, int type, ByteBuffer indices, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress((ByteBuffer)indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, ByteBuffer indices, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, ShortBuffer indices, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, IntBuffer indices, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)indices), basevertex);
    }

    public static native void nglDrawRangeElementsBaseVertexEXT(int var0, int var1, int var2, int var3, int var4, long var5, int var7);

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, int type, ByteBuffer indices, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress((ByteBuffer)indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, ByteBuffer indices, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, ShortBuffer indices, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, IntBuffer indices, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)indices), basevertex);
    }

    public static native void nglDrawElementsInstancedBaseVertexEXT(int var0, int var1, int var2, long var3, int var5, int var6);

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, int count, int type, long indices, int instancecount, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, count, type, indices, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, int type, ByteBuffer indices, int instancecount, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress((ByteBuffer)indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, ByteBuffer indices, int instancecount, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, ShortBuffer indices, int instancecount, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, IntBuffer indices, int instancecount, int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)indices), instancecount, basevertex);
    }

    public static native void nglMultiDrawElementsBaseVertexEXT(int var0, long var1, int var3, long var4, int var6, long var7);

    public static void glMultiDrawElementsBaseVertexEXT(int mode, IntBuffer count, int type, PointerBuffer indices, IntBuffer basevertex) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)indices, (int)count.remaining());
            Checks.check((Buffer)basevertex, (int)count.remaining());
        }
        EXTDrawElementsBaseVertex.nglMultiDrawElementsBaseVertexEXT(mode, MemoryUtil.memAddress((IntBuffer)count), type, MemoryUtil.memAddress((CustomBuffer)indices), count.remaining(), MemoryUtil.memAddress((IntBuffer)basevertex));
    }

    public static void glMultiDrawElementsBaseVertexEXT(int mode, int[] count, int type, PointerBuffer indices, int[] basevertex) {
        long __functionAddress = GLES.getICD().glMultiDrawElementsBaseVertexEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((CustomBuffer)indices, (int)count.length);
            Checks.check((int[])basevertex, (int)count.length);
        }
        JNI.callPPPV((long)__functionAddress, (int)mode, (int[])count, (int)type, (long)MemoryUtil.memAddress((CustomBuffer)indices), (int)count.length, (int[])basevertex);
    }

    static {
        GLES.initialize();
    }
}

