/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public class EXTMapBufferRange {
    public static final int GL_MAP_READ_BIT_EXT = 1;
    public static final int GL_MAP_WRITE_BIT_EXT = 2;
    public static final int GL_MAP_INVALIDATE_RANGE_BIT_EXT = 4;
    public static final int GL_MAP_INVALIDATE_BUFFER_BIT_EXT = 8;
    public static final int GL_MAP_FLUSH_EXPLICIT_BIT_EXT = 16;
    public static final int GL_MAP_UNSYNCHRONIZED_BIT_EXT = 32;

    protected EXTMapBufferRange() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glMapBufferRangeEXT, caps.glFlushMappedBufferRangeEXT});
    }

    public static native long nglMapBufferRangeEXT(int var0, long var1, long var3, int var5);

    public static ByteBuffer glMapBufferRangeEXT(int target, long offset, long length, int access) {
        long __result = EXTMapBufferRange.nglMapBufferRangeEXT(target, offset, length, access);
        return MemoryUtil.memByteBuffer((long)__result, (int)((int)length));
    }

    public static ByteBuffer glMapBufferRangeEXT(int target, long offset, long length, int access, ByteBuffer old_buffer) {
        long __result = EXTMapBufferRange.nglMapBufferRangeEXT(target, offset, length, access);
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)length));
    }

    public static native void nglFlushMappedBufferRangeEXT(int var0, long var1, long var3);

    public static void glFlushMappedBufferRangeEXT(int target, long offset, long length) {
        EXTMapBufferRange.nglFlushMappedBufferRangeEXT(target, offset, length);
    }

    static {
        GLES.initialize();
    }
}

