/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTMultiDrawIndirect {
    protected EXTMultiDrawIndirect() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glMultiDrawArraysIndirectEXT, caps.glMultiDrawElementsIndirectEXT});
    }

    public static native void nglMultiDrawArraysIndirectEXT(int var0, long var1, int var3, int var4);

    public static void glMultiDrawArraysIndirectEXT(int mode, ByteBuffer indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)(drawcount * (stride == 0 ? 16 : stride)));
        }
        EXTMultiDrawIndirect.nglMultiDrawArraysIndirectEXT(mode, MemoryUtil.memAddress((ByteBuffer)indirect), drawcount, stride);
    }

    public static void glMultiDrawArraysIndirectEXT(int mode, long indirect, int drawcount, int stride) {
        EXTMultiDrawIndirect.nglMultiDrawArraysIndirectEXT(mode, indirect, drawcount, stride);
    }

    public static void glMultiDrawArraysIndirectEXT(int mode, IntBuffer indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)(drawcount * (stride == 0 ? 16 : stride) >> 2));
        }
        EXTMultiDrawIndirect.nglMultiDrawArraysIndirectEXT(mode, MemoryUtil.memAddress((IntBuffer)indirect), drawcount, stride);
    }

    public static native void nglMultiDrawElementsIndirectEXT(int var0, int var1, long var2, int var4, int var5);

    public static void glMultiDrawElementsIndirectEXT(int mode, int type, ByteBuffer indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)(drawcount * (stride == 0 ? 20 : stride)));
        }
        EXTMultiDrawIndirect.nglMultiDrawElementsIndirectEXT(mode, type, MemoryUtil.memAddress((ByteBuffer)indirect), drawcount, stride);
    }

    public static void glMultiDrawElementsIndirectEXT(int mode, int type, long indirect, int drawcount, int stride) {
        EXTMultiDrawIndirect.nglMultiDrawElementsIndirectEXT(mode, type, indirect, drawcount, stride);
    }

    public static void glMultiDrawElementsIndirectEXT(int mode, int type, IntBuffer indirect, int drawcount, int stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)(drawcount * (stride == 0 ? 20 : stride) >> 2));
        }
        EXTMultiDrawIndirect.nglMultiDrawElementsIndirectEXT(mode, type, MemoryUtil.memAddress((IntBuffer)indirect), drawcount, stride);
    }

    public static void glMultiDrawArraysIndirectEXT(int mode, int[] indirect, int drawcount, int stride) {
        long __functionAddress = GLES.getICD().glMultiDrawArraysIndirectEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])indirect, (int)(drawcount * (stride == 0 ? 16 : stride) >> 2));
        }
        JNI.callPV((long)__functionAddress, (int)mode, (int[])indirect, (int)drawcount, (int)stride);
    }

    public static void glMultiDrawElementsIndirectEXT(int mode, int type, int[] indirect, int drawcount, int stride) {
        long __functionAddress = GLES.getICD().glMultiDrawElementsIndirectEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])indirect, (int)(drawcount * (stride == 0 ? 20 : stride) >> 2));
        }
        JNI.callPV((long)__functionAddress, (int)mode, (int)type, (int[])indirect, (int)drawcount, (int)stride);
    }

    static {
        GLES.initialize();
    }
}

