/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTMultiviewDrawBuffers {
    public static final int GL_COLOR_ATTACHMENT_EXT = 37104;
    public static final int GL_MULTIVIEW_EXT = 37105;
    public static final int GL_DRAW_BUFFER_EXT = 3073;
    public static final int GL_READ_BUFFER_EXT = 3074;
    public static final int GL_MAX_MULTIVIEW_BUFFERS_EXT = 37106;

    protected EXTMultiviewDrawBuffers() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glReadBufferIndexedEXT, caps.glDrawBuffersIndexedEXT, caps.glGetIntegeri_vEXT});
    }

    public static native void nglReadBufferIndexedEXT(int var0, int var1);

    public static void glReadBufferIndexedEXT(int src, int index) {
        EXTMultiviewDrawBuffers.nglReadBufferIndexedEXT(src, index);
    }

    public static native void nglDrawBuffersIndexedEXT(int var0, long var1, long var3);

    public static void glDrawBuffersIndexedEXT(IntBuffer location, IntBuffer indices) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indices, (int)location.remaining());
        }
        EXTMultiviewDrawBuffers.nglDrawBuffersIndexedEXT(location.remaining(), MemoryUtil.memAddress((IntBuffer)location), MemoryUtil.memAddress((IntBuffer)indices));
    }

    public static native void nglGetIntegeri_vEXT(int var0, int var1, long var2);

    public static void glGetIntegeri_vEXT(int target, int index, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(target, index, MemoryUtil.memAddress((IntBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetIntegeriEXT(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(target, index, MemoryUtil.memAddress((IntBuffer)data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDrawBuffersIndexedEXT(int[] location, int[] indices) {
        long __functionAddress = GLES.getICD().glDrawBuffersIndexedEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])indices, (int)location.length);
        }
        JNI.callPPV((long)__functionAddress, (int)location.length, (int[])location, (int[])indices);
    }

    public static void glGetIntegeri_vEXT(int target, int index, int[] data) {
        long __functionAddress = GLES.getICD().glGetIntegeri_vEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)index, (int[])data);
    }

    static {
        GLES.initialize();
    }
}

