/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTRobustness {
    public static final int GL_GUILTY_CONTEXT_RESET_EXT = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET_EXT = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET_EXT = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS_EXT = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY_EXT = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET_EXT = 33362;
    public static final int GL_NO_RESET_NOTIFICATION_EXT = 33377;

    protected EXTRobustness() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glGetGraphicsResetStatusEXT, caps.glReadnPixelsEXT, caps.glGetnUniformfvEXT, caps.glGetnUniformivEXT});
    }

    public static native int nglGetGraphicsResetStatusEXT();

    public static int glGetGraphicsResetStatusEXT() {
        return EXTRobustness.nglGetGraphicsResetStatusEXT();
    }

    public static native void nglReadnPixelsEXT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, int bufSize, long data) {
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, bufSize, data);
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, ByteBuffer data) {
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, ShortBuffer data) {
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, IntBuffer data) {
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, FloatBuffer data) {
        EXTRobustness.nglReadnPixelsEXT(x, y, width, height, format, type, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static native void nglGetnUniformfvEXT(int var0, int var1, int var2, long var3);

    public static void glGetnUniformfvEXT(int program, int location, FloatBuffer params) {
        EXTRobustness.nglGetnUniformfvEXT(program, location, params.remaining(), MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformfEXT(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            EXTRobustness.nglGetnUniformfvEXT(program, location, 1, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformivEXT(int var0, int var1, int var2, long var3);

    public static void glGetnUniformivEXT(int program, int location, IntBuffer params) {
        EXTRobustness.nglGetnUniformivEXT(program, location, params.remaining(), MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetnUniformiEXT(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTRobustness.nglGetnUniformivEXT(program, location, 1, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, short[] data) {
        long __functionAddress = GLES.getICD().glReadnPixelsEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(data.length << 1), (short[])data);
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, int[] data) {
        long __functionAddress = GLES.getICD().glReadnPixelsEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(data.length << 2), (int[])data);
    }

    public static void glReadnPixelsEXT(int x, int y, int width, int height, int format, int type, float[] data) {
        long __functionAddress = GLES.getICD().glReadnPixelsEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(data.length << 2), (float[])data);
    }

    public static void glGetnUniformfvEXT(int program, int location, float[] params) {
        long __functionAddress = GLES.getICD().glGetnUniformfvEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (float[])params);
    }

    public static void glGetnUniformivEXT(int program, int location, int[] params) {
        long __functionAddress = GLES.getICD().glGetnUniformivEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (int[])params);
    }

    static {
        GLES.initialize();
    }
}

