/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GLES20 {
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_STENCIL_BUFFER_BIT = 1024;
    public static final int GL_COLOR_BUFFER_BIT = 16384;
    public static final int GL_FALSE = 0;
    public static final int GL_TRUE = 1;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int GL_ZERO = 0;
    public static final int GL_ONE = 1;
    public static final int GL_SRC_COLOR = 768;
    public static final int GL_ONE_MINUS_SRC_COLOR = 769;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_DST_ALPHA = 772;
    public static final int GL_ONE_MINUS_DST_ALPHA = 773;
    public static final int GL_DST_COLOR = 774;
    public static final int GL_ONE_MINUS_DST_COLOR = 775;
    public static final int GL_SRC_ALPHA_SATURATE = 776;
    public static final int GL_FUNC_ADD = 32774;
    public static final int GL_BLEND_EQUATION = 32777;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;
    public static final int GL_FUNC_SUBTRACT = 32778;
    public static final int GL_FUNC_REVERSE_SUBTRACT = 32779;
    public static final int GL_BLEND_DST_RGB = 32968;
    public static final int GL_BLEND_SRC_RGB = 32969;
    public static final int GL_BLEND_DST_ALPHA = 32970;
    public static final int GL_BLEND_SRC_ALPHA = 32971;
    public static final int GL_CONSTANT_COLOR = 32769;
    public static final int GL_ONE_MINUS_CONSTANT_COLOR = 32770;
    public static final int GL_CONSTANT_ALPHA = 32771;
    public static final int GL_ONE_MINUS_CONSTANT_ALPHA = 32772;
    public static final int GL_BLEND_COLOR = 32773;
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_BUFFER_SIZE = 34660;
    public static final int GL_BUFFER_USAGE = 34661;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_FRONT = 1028;
    public static final int GL_BACK = 1029;
    public static final int GL_FRONT_AND_BACK = 1032;
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_CULL_FACE = 2884;
    public static final int GL_BLEND = 3042;
    public static final int GL_DITHER = 3024;
    public static final int GL_STENCIL_TEST = 2960;
    public static final int GL_DEPTH_TEST = 2929;
    public static final int GL_SCISSOR_TEST = 3089;
    public static final int GL_POLYGON_OFFSET_FILL = 32823;
    public static final int GL_SAMPLE_ALPHA_TO_COVERAGE = 32926;
    public static final int GL_SAMPLE_COVERAGE = 32928;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_INVALID_ENUM = 1280;
    public static final int GL_INVALID_VALUE = 1281;
    public static final int GL_INVALID_OPERATION = 1282;
    public static final int GL_OUT_OF_MEMORY = 1285;
    public static final int GL_CW = 2304;
    public static final int GL_CCW = 2305;
    public static final int GL_LINE_WIDTH = 2849;
    public static final int GL_ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int GL_ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int GL_CULL_FACE_MODE = 2885;
    public static final int GL_FRONT_FACE = 2886;
    public static final int GL_DEPTH_RANGE = 2928;
    public static final int GL_DEPTH_WRITEMASK = 2930;
    public static final int GL_DEPTH_CLEAR_VALUE = 2931;
    public static final int GL_DEPTH_FUNC = 2932;
    public static final int GL_STENCIL_CLEAR_VALUE = 2961;
    public static final int GL_STENCIL_FUNC = 2962;
    public static final int GL_STENCIL_FAIL = 2964;
    public static final int GL_STENCIL_PASS_DEPTH_FAIL = 2965;
    public static final int GL_STENCIL_PASS_DEPTH_PASS = 2966;
    public static final int GL_STENCIL_REF = 2967;
    public static final int GL_STENCIL_VALUE_MASK = 2963;
    public static final int GL_STENCIL_WRITEMASK = 2968;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;
    public static final int GL_VIEWPORT = 2978;
    public static final int GL_SCISSOR_BOX = 3088;
    public static final int GL_COLOR_CLEAR_VALUE = 3106;
    public static final int GL_COLOR_WRITEMASK = 3107;
    public static final int GL_UNPACK_ALIGNMENT = 3317;
    public static final int GL_PACK_ALIGNMENT = 3333;
    public static final int GL_MAX_TEXTURE_SIZE = 3379;
    public static final int GL_MAX_VIEWPORT_DIMS = 3386;
    public static final int GL_SUBPIXEL_BITS = 3408;
    public static final int GL_RED_BITS = 3410;
    public static final int GL_GREEN_BITS = 3411;
    public static final int GL_BLUE_BITS = 3412;
    public static final int GL_ALPHA_BITS = 3413;
    public static final int GL_DEPTH_BITS = 3414;
    public static final int GL_STENCIL_BITS = 3415;
    public static final int GL_POLYGON_OFFSET_UNITS = 10752;
    public static final int GL_POLYGON_OFFSET_FACTOR = 32824;
    public static final int GL_TEXTURE_BINDING_2D = 32873;
    public static final int GL_SAMPLE_BUFFERS = 32936;
    public static final int GL_SAMPLES = 32937;
    public static final int GL_SAMPLE_COVERAGE_VALUE = 32938;
    public static final int GL_SAMPLE_COVERAGE_INVERT = 32939;
    public static final int GL_NUM_COMPRESSED_TEXTURE_FORMATS = 34466;
    public static final int GL_COMPRESSED_TEXTURE_FORMATS = 34467;
    public static final int GL_DONT_CARE = 4352;
    public static final int GL_FASTEST = 4353;
    public static final int GL_NICEST = 4354;
    public static final int GL_GENERATE_MIPMAP_HINT = 33170;
    public static final int GL_BYTE = 5120;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_SHORT = 5122;
    public static final int GL_UNSIGNED_SHORT = 5123;
    public static final int GL_INT = 5124;
    public static final int GL_UNSIGNED_INT = 5125;
    public static final int GL_FLOAT = 5126;
    public static final int GL_FIXED = 5132;
    public static final int GL_DEPTH_COMPONENT = 6402;
    public static final int GL_ALPHA = 6406;
    public static final int GL_RGB = 6407;
    public static final int GL_RGBA = 6408;
    public static final int GL_LUMINANCE = 6409;
    public static final int GL_LUMINANCE_ALPHA = 6410;
    public static final int GL_UNSIGNED_SHORT_4_4_4_4 = 32819;
    public static final int GL_UNSIGNED_SHORT_5_5_5_1 = 32820;
    public static final int GL_UNSIGNED_SHORT_5_6_5 = 33635;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_NEVER = 512;
    public static final int GL_LESS = 513;
    public static final int GL_EQUAL = 514;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GREATER = 516;
    public static final int GL_NOTEQUAL = 517;
    public static final int GL_GEQUAL = 518;
    public static final int GL_ALWAYS = 519;
    public static final int GL_KEEP = 7680;
    public static final int GL_REPLACE = 7681;
    public static final int GL_INCR = 7682;
    public static final int GL_DECR = 7683;
    public static final int GL_INVERT = 5386;
    public static final int GL_INCR_WRAP = 34055;
    public static final int GL_DECR_WRAP = 34056;
    public static final int GL_VENDOR = 7936;
    public static final int GL_RENDERER = 7937;
    public static final int GL_VERSION = 7938;
    public static final int GL_EXTENSIONS = 7939;
    public static final int GL_NEAREST = 9728;
    public static final int GL_LINEAR = 9729;
    public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
    public static final int GL_LINEAR_MIPMAP_NEAREST = 9985;
    public static final int GL_NEAREST_MIPMAP_LINEAR = 9986;
    public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_TEXTURE = 5890;
    public static final int GL_TEXTURE_CUBE_MAP = 34067;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP = 34068;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
    public static final int GL_MAX_CUBE_MAP_TEXTURE_SIZE = 34076;
    public static final int GL_TEXTURE0 = 33984;
    public static final int GL_TEXTURE1 = 33985;
    public static final int GL_TEXTURE2 = 33986;
    public static final int GL_TEXTURE3 = 33987;
    public static final int GL_TEXTURE4 = 33988;
    public static final int GL_TEXTURE5 = 33989;
    public static final int GL_TEXTURE6 = 33990;
    public static final int GL_TEXTURE7 = 33991;
    public static final int GL_TEXTURE8 = 33992;
    public static final int GL_TEXTURE9 = 33993;
    public static final int GL_TEXTURE10 = 33994;
    public static final int GL_TEXTURE11 = 33995;
    public static final int GL_TEXTURE12 = 33996;
    public static final int GL_TEXTURE13 = 33997;
    public static final int GL_TEXTURE14 = 33998;
    public static final int GL_TEXTURE15 = 33999;
    public static final int GL_TEXTURE16 = 34000;
    public static final int GL_TEXTURE17 = 34001;
    public static final int GL_TEXTURE18 = 34002;
    public static final int GL_TEXTURE19 = 34003;
    public static final int GL_TEXTURE20 = 34004;
    public static final int GL_TEXTURE21 = 34005;
    public static final int GL_TEXTURE22 = 34006;
    public static final int GL_TEXTURE23 = 34007;
    public static final int GL_TEXTURE24 = 34008;
    public static final int GL_TEXTURE25 = 34009;
    public static final int GL_TEXTURE26 = 34010;
    public static final int GL_TEXTURE27 = 34011;
    public static final int GL_TEXTURE28 = 34012;
    public static final int GL_TEXTURE29 = 34013;
    public static final int GL_TEXTURE30 = 34014;
    public static final int GL_TEXTURE31 = 34015;
    public static final int GL_ACTIVE_TEXTURE = 34016;
    public static final int GL_REPEAT = 10497;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_MIRRORED_REPEAT = 33648;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_FRAMEBUFFER = 36160;
    public static final int GL_RENDERBUFFER = 36161;
    public static final int GL_RGBA4 = 32854;
    public static final int GL_RGB5_A1 = 32855;
    public static final int GL_RGB565 = 36194;
    public static final int GL_DEPTH_COMPONENT16 = 33189;
    public static final int GL_STENCIL_INDEX8 = 36168;
    public static final int GL_RENDERBUFFER_WIDTH = 36162;
    public static final int GL_RENDERBUFFER_HEIGHT = 36163;
    public static final int GL_RENDERBUFFER_INTERNAL_FORMAT = 36164;
    public static final int GL_RENDERBUFFER_RED_SIZE = 36176;
    public static final int GL_RENDERBUFFER_GREEN_SIZE = 36177;
    public static final int GL_RENDERBUFFER_BLUE_SIZE = 36178;
    public static final int GL_RENDERBUFFER_ALPHA_SIZE = 36179;
    public static final int GL_RENDERBUFFER_DEPTH_SIZE = 36180;
    public static final int GL_RENDERBUFFER_STENCIL_SIZE = 36181;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
    public static final int GL_COLOR_ATTACHMENT0 = 36064;
    public static final int GL_DEPTH_ATTACHMENT = 36096;
    public static final int GL_STENCIL_ATTACHMENT = 36128;
    public static final int GL_NONE = 0;
    public static final int GL_FRAMEBUFFER_COMPLETE = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int GL_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_RENDERBUFFER_BINDING = 36007;
    public static final int GL_MAX_RENDERBUFFER_SIZE = 34024;
    public static final int GL_INVALID_FRAMEBUFFER_OPERATION = 1286;

    protected GLES20() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glActiveTexture, caps.glAttachShader, caps.glBindAttribLocation, caps.glBindBuffer, caps.glBindFramebuffer, caps.glBindRenderbuffer, caps.glBindTexture, caps.glBlendColor, caps.glBlendEquation, caps.glBlendEquationSeparate, caps.glBlendFunc, caps.glBlendFuncSeparate, caps.glBufferData, caps.glBufferSubData, caps.glCheckFramebufferStatus, caps.glClear, caps.glClearColor, caps.glClearDepthf, caps.glClearStencil, caps.glColorMask, caps.glCompileShader, caps.glCompressedTexImage2D, caps.glCompressedTexSubImage2D, caps.glCopyTexImage2D, caps.glCopyTexSubImage2D, caps.glCreateProgram, caps.glCreateShader, caps.glCullFace, caps.glDeleteBuffers, caps.glDeleteFramebuffers, caps.glDeleteProgram, caps.glDeleteRenderbuffers, caps.glDeleteShader, caps.glDeleteTextures, caps.glDepthFunc, caps.glDepthMask, caps.glDepthRangef, caps.glDetachShader, caps.glDisable, caps.glDisableVertexAttribArray, caps.glDrawArrays, caps.glDrawElements, caps.glEnable, caps.glEnableVertexAttribArray, caps.glFinish, caps.glFlush, caps.glFramebufferRenderbuffer, caps.glFramebufferTexture2D, caps.glFrontFace, caps.glGenBuffers, caps.glGenerateMipmap, caps.glGenFramebuffers, caps.glGenRenderbuffers, caps.glGenTextures, caps.glGetActiveAttrib, caps.glGetActiveUniform, caps.glGetAttachedShaders, caps.glGetAttribLocation, caps.glGetBooleanv, caps.glGetBufferParameteriv, caps.glGetError, caps.glGetFloatv, caps.glGetFramebufferAttachmentParameteriv, caps.glGetIntegerv, caps.glGetProgramiv, caps.glGetProgramInfoLog, caps.glGetRenderbufferParameteriv, caps.glGetShaderiv, caps.glGetShaderInfoLog, caps.glGetShaderPrecisionFormat, caps.glGetShaderSource, caps.glGetString, caps.glGetTexParameterfv, caps.glGetTexParameteriv, caps.glGetUniformfv, caps.glGetUniformiv, caps.glGetUniformLocation, caps.glGetVertexAttribfv, caps.glGetVertexAttribiv, caps.glGetVertexAttribPointerv, caps.glHint, caps.glIsBuffer, caps.glIsEnabled, caps.glIsFramebuffer, caps.glIsProgram, caps.glIsRenderbuffer, caps.glIsShader, caps.glIsTexture, caps.glLineWidth, caps.glLinkProgram, caps.glPixelStorei, caps.glPolygonOffset, caps.glReadPixels, caps.glReleaseShaderCompiler, caps.glRenderbufferStorage, caps.glSampleCoverage, caps.glScissor, caps.glShaderBinary, caps.glShaderSource, caps.glStencilFunc, caps.glStencilFuncSeparate, caps.glStencilMask, caps.glStencilMaskSeparate, caps.glStencilOp, caps.glStencilOpSeparate, caps.glTexImage2D, caps.glTexParameterf, caps.glTexParameterfv, caps.glTexParameteri, caps.glTexParameteriv, caps.glTexSubImage2D, caps.glUniform1f, caps.glUniform1fv, caps.glUniform1i, caps.glUniform1iv, caps.glUniform2f, caps.glUniform2fv, caps.glUniform2i, caps.glUniform2iv, caps.glUniform3f, caps.glUniform3fv, caps.glUniform3i, caps.glUniform3iv, caps.glUniform4f, caps.glUniform4fv, caps.glUniform4i, caps.glUniform4iv, caps.glUniformMatrix2fv, caps.glUniformMatrix3fv, caps.glUniformMatrix4fv, caps.glUseProgram, caps.glValidateProgram, caps.glVertexAttrib1f, caps.glVertexAttrib1fv, caps.glVertexAttrib2f, caps.glVertexAttrib2fv, caps.glVertexAttrib3f, caps.glVertexAttrib3fv, caps.glVertexAttrib4f, caps.glVertexAttrib4fv, caps.glVertexAttribPointer, caps.glViewport});
    }

    public static native void nglActiveTexture(int var0);

    public static void glActiveTexture(int texture) {
        GLES20.nglActiveTexture(texture);
    }

    public static native void nglAttachShader(int var0, int var1);

    public static void glAttachShader(int program, int shader) {
        GLES20.nglAttachShader(program, shader);
    }

    public static native void nglBindAttribLocation(int var0, int var1, long var2);

    public static void glBindAttribLocation(int program, int index, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        GLES20.nglBindAttribLocation(program, index, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glBindAttribLocation(int program, int index, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            GLES20.nglBindAttribLocation(program, index, MemoryUtil.memAddress((ByteBuffer)nameEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglBindBuffer(int var0, int var1);

    public static void glBindBuffer(int target, int buffer) {
        GLES20.nglBindBuffer(target, buffer);
    }

    public static native void nglBindFramebuffer(int var0, int var1);

    public static void glBindFramebuffer(int target, int framebuffer) {
        GLES20.nglBindFramebuffer(target, framebuffer);
    }

    public static native void nglBindRenderbuffer(int var0, int var1);

    public static void glBindRenderbuffer(int target, int renderbuffer) {
        GLES20.nglBindRenderbuffer(target, renderbuffer);
    }

    public static native void nglBindTexture(int var0, int var1);

    public static void glBindTexture(int target, int texture) {
        GLES20.nglBindTexture(target, texture);
    }

    public static native void nglBlendColor(float var0, float var1, float var2, float var3);

    public static void glBlendColor(float red, float green, float blue, float alpha) {
        GLES20.nglBlendColor(red, green, blue, alpha);
    }

    public static native void nglBlendEquation(int var0);

    public static void glBlendEquation(int mode) {
        GLES20.nglBlendEquation(mode);
    }

    public static native void nglBlendEquationSeparate(int var0, int var1);

    public static void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        GLES20.nglBlendEquationSeparate(modeRGB, modeAlpha);
    }

    public static native void nglBlendFunc(int var0, int var1);

    public static void glBlendFunc(int sfactor, int dfactor) {
        GLES20.nglBlendFunc(sfactor, dfactor);
    }

    public static native void nglBlendFuncSeparate(int var0, int var1, int var2, int var3);

    public static void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha) {
        GLES20.nglBlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    }

    public static native void nglBufferData(int var0, long var1, long var3, int var5);

    public static void glBufferData(int target, long size, int usage) {
        GLES20.nglBufferData(target, size, 0L, usage);
    }

    public static void glBufferData(int target, ByteBuffer data, int usage) {
        GLES20.nglBufferData(target, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data), usage);
    }

    public static void glBufferData(int target, ShortBuffer data, int usage) {
        GLES20.nglBufferData(target, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data), usage);
    }

    public static void glBufferData(int target, IntBuffer data, int usage) {
        GLES20.nglBufferData(target, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data), usage);
    }

    public static void glBufferData(int target, FloatBuffer data, int usage) {
        GLES20.nglBufferData(target, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data), usage);
    }

    public static native void nglBufferSubData(int var0, long var1, long var3, long var5);

    public static void glBufferSubData(int target, long offset, ByteBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glBufferSubData(int target, long offset, ShortBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static void glBufferSubData(int target, long offset, IntBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glBufferSubData(int target, long offset, FloatBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static native int nglCheckFramebufferStatus(int var0);

    public static int glCheckFramebufferStatus(int target) {
        return GLES20.nglCheckFramebufferStatus(target);
    }

    public static native void nglClear(int var0);

    public static void glClear(int mask) {
        GLES20.nglClear(mask);
    }

    public static native void nglClearColor(float var0, float var1, float var2, float var3);

    public static void glClearColor(float red, float green, float blue, float alpha) {
        GLES20.nglClearColor(red, green, blue, alpha);
    }

    public static native void nglClearDepthf(float var0);

    public static void glClearDepthf(float d) {
        GLES20.nglClearDepthf(d);
    }

    public static native void nglClearStencil(int var0);

    public static void glClearStencil(int s) {
        GLES20.nglClearStencil(s);
    }

    public static native void nglColorMask(boolean var0, boolean var1, boolean var2, boolean var3);

    public static void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GLES20.nglColorMask(red, green, blue, alpha);
    }

    public static native void nglCompileShader(int var0);

    public static void glCompileShader(int shader) {
        GLES20.nglCompileShader(shader);
    }

    public static native void nglCompressedTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, long data) {
        GLES20.nglCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
    }

    public static void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, ByteBuffer data) {
        GLES20.nglCompressedTexImage2D(target, level, internalformat, width, height, border, Checks.remainingSafe((Buffer)data), MemoryUtil.memAddressSafe((ByteBuffer)data));
    }

    public static native void nglCompressedTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        GLES20.nglCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }

    public static void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        GLES20.nglCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static native void nglCopyTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        GLES20.nglCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
    }

    public static native void nglCopyTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GLES20.nglCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    }

    public static native int nglCreateProgram();

    public static int glCreateProgram() {
        return GLES20.nglCreateProgram();
    }

    public static native int nglCreateShader(int var0);

    public static int glCreateShader(int type) {
        return GLES20.nglCreateShader(type);
    }

    public static native void nglCullFace(int var0);

    public static void glCullFace(int mode) {
        GLES20.nglCullFace(mode);
    }

    public static native void nglDeleteBuffers(int var0, long var1);

    public static void glDeleteBuffers(IntBuffer buffers) {
        GLES20.nglDeleteBuffers(buffers.remaining(), MemoryUtil.memAddress((IntBuffer)buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteBuffers(int buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.ints(buffer);
            GLES20.nglDeleteBuffers(1, MemoryUtil.memAddress((IntBuffer)buffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteFramebuffers(int var0, long var1);

    public static void glDeleteFramebuffers(IntBuffer framebuffers) {
        GLES20.nglDeleteFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress((IntBuffer)framebuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteFramebuffers(int framebuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer framebuffers = stack.ints(framebuffer);
            GLES20.nglDeleteFramebuffers(1, MemoryUtil.memAddress((IntBuffer)framebuffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteProgram(int var0);

    public static void glDeleteProgram(int program) {
        GLES20.nglDeleteProgram(program);
    }

    public static native void nglDeleteRenderbuffers(int var0, long var1);

    public static void glDeleteRenderbuffers(IntBuffer renderbuffers) {
        GLES20.nglDeleteRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress((IntBuffer)renderbuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteRenderbuffers(int renderbuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer renderbuffers = stack.ints(renderbuffer);
            GLES20.nglDeleteRenderbuffers(1, MemoryUtil.memAddress((IntBuffer)renderbuffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteShader(int var0);

    public static void glDeleteShader(int shader) {
        GLES20.nglDeleteShader(shader);
    }

    public static native void nglDeleteTextures(int var0, long var1);

    public static void glDeleteTextures(IntBuffer textures) {
        GLES20.nglDeleteTextures(textures.remaining(), MemoryUtil.memAddress((IntBuffer)textures));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteTextures(int texture) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer textures = stack.ints(texture);
            GLES20.nglDeleteTextures(1, MemoryUtil.memAddress((IntBuffer)textures));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDepthFunc(int var0);

    public static void glDepthFunc(int func) {
        GLES20.nglDepthFunc(func);
    }

    public static native void nglDepthMask(boolean var0);

    public static void glDepthMask(boolean flag) {
        GLES20.nglDepthMask(flag);
    }

    public static native void nglDepthRangef(float var0, float var1);

    public static void glDepthRangef(float n, float f) {
        GLES20.nglDepthRangef(n, f);
    }

    public static native void nglDetachShader(int var0, int var1);

    public static void glDetachShader(int program, int shader) {
        GLES20.nglDetachShader(program, shader);
    }

    public static native void nglDisable(int var0);

    public static void glDisable(int cap) {
        GLES20.nglDisable(cap);
    }

    public static native void nglDisableVertexAttribArray(int var0);

    public static void glDisableVertexAttribArray(int index) {
        GLES20.nglDisableVertexAttribArray(index);
    }

    public static native void nglDrawArrays(int var0, int var1, int var2);

    public static void glDrawArrays(int mode, int first, int count) {
        GLES20.nglDrawArrays(mode, first, count);
    }

    public static native void nglDrawElements(int var0, int var1, int var2, long var3);

    public static void glDrawElements(int mode, int count, int type, long indices) {
        GLES20.nglDrawElements(mode, count, type, indices);
    }

    public static void glDrawElements(int mode, int type, ByteBuffer indices) {
        GLES20.nglDrawElements(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress((ByteBuffer)indices));
    }

    public static void glDrawElements(int mode, ByteBuffer indices) {
        GLES20.nglDrawElements(mode, indices.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)indices));
    }

    public static void glDrawElements(int mode, ShortBuffer indices) {
        GLES20.nglDrawElements(mode, indices.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)indices));
    }

    public static void glDrawElements(int mode, IntBuffer indices) {
        GLES20.nglDrawElements(mode, indices.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)indices));
    }

    public static native void nglEnable(int var0);

    public static void glEnable(int cap) {
        GLES20.nglEnable(cap);
    }

    public static native void nglEnableVertexAttribArray(int var0);

    public static void glEnableVertexAttribArray(int index) {
        GLES20.nglEnableVertexAttribArray(index);
    }

    public static native void nglFinish();

    public static void glFinish() {
        GLES20.nglFinish();
    }

    public static native void nglFlush();

    public static void glFlush() {
        GLES20.nglFlush();
    }

    public static native void nglFramebufferRenderbuffer(int var0, int var1, int var2, int var3);

    public static void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        GLES20.nglFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
    }

    public static native void nglFramebufferTexture2D(int var0, int var1, int var2, int var3, int var4);

    public static void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        GLES20.nglFramebufferTexture2D(target, attachment, textarget, texture, level);
    }

    public static native void nglFrontFace(int var0);

    public static void glFrontFace(int mode) {
        GLES20.nglFrontFace(mode);
    }

    public static native void nglGenBuffers(int var0, long var1);

    public static void glGenBuffers(IntBuffer buffers) {
        GLES20.nglGenBuffers(buffers.remaining(), MemoryUtil.memAddress((IntBuffer)buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenBuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.callocInt(1);
            GLES20.nglGenBuffers(1, MemoryUtil.memAddress((IntBuffer)buffers));
            int n = buffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenerateMipmap(int var0);

    public static void glGenerateMipmap(int target) {
        GLES20.nglGenerateMipmap(target);
    }

    public static native void nglGenFramebuffers(int var0, long var1);

    public static void glGenFramebuffers(IntBuffer framebuffers) {
        GLES20.nglGenFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress((IntBuffer)framebuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenFramebuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer framebuffers = stack.callocInt(1);
            GLES20.nglGenFramebuffers(1, MemoryUtil.memAddress((IntBuffer)framebuffers));
            int n = framebuffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenRenderbuffers(int var0, long var1);

    public static void glGenRenderbuffers(IntBuffer renderbuffers) {
        GLES20.nglGenRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress((IntBuffer)renderbuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenRenderbuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer renderbuffers = stack.callocInt(1);
            GLES20.nglGenRenderbuffers(1, MemoryUtil.memAddress((IntBuffer)renderbuffers));
            int n = renderbuffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenTextures(int var0, long var1);

    public static void glGenTextures(IntBuffer textures) {
        GLES20.nglGenTextures(textures.remaining(), MemoryUtil.memAddress((IntBuffer)textures));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenTextures() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer textures = stack.callocInt(1);
            GLES20.nglGenTextures(1, MemoryUtil.memAddress((IntBuffer)textures));
            int n = textures.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetActiveAttrib(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void glGetActiveAttrib(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        GLES20.nglGetActiveAttrib(program, index, name.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveAttrib(int program, int index, int bufSize, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES20.nglGetActiveAttrib(program, index, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
            String string = MemoryUtil.memASCII((ByteBuffer)name, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveAttrib(int program, int index, IntBuffer size, IntBuffer type) {
        int bufSize = GLES20.glGetProgrami(program, 35722);
        if (Checks.CHECKS) {
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES20.nglGetActiveAttrib(program, index, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
            String string = MemoryUtil.memASCII((ByteBuffer)name, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetActiveUniform(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void glGetActiveUniform(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        GLES20.nglGetActiveUniform(program, index, name.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniform(int program, int index, int bufSize, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES20.nglGetActiveUniform(program, index, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
            String string = MemoryUtil.memASCII((ByteBuffer)name, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniform(int program, int index, IntBuffer size, IntBuffer type) {
        int bufSize = GLES20.glGetProgrami(program, 35719);
        if (Checks.CHECKS) {
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES20.nglGetActiveUniform(program, index, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
            String string = MemoryUtil.memASCII((ByteBuffer)name, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetAttachedShaders(int var0, int var1, long var2, long var4);

    public static void glGetAttachedShaders(int program, IntBuffer count, IntBuffer shaders) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)count, (int)1);
        }
        GLES20.nglGetAttachedShaders(program, shaders.remaining(), MemoryUtil.memAddressSafe((IntBuffer)count), MemoryUtil.memAddress((IntBuffer)shaders));
    }

    public static native int nglGetAttribLocation(int var0, long var1);

    public static int glGetAttribLocation(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return GLES20.nglGetAttribLocation(program, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetAttribLocation(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GLES20.nglGetAttribLocation(program, MemoryUtil.memAddress((ByteBuffer)nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetBooleanv(int var0, long var1);

    public static void glGetBooleanv(int pname, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        GLES20.nglGetBooleanv(pname, MemoryUtil.memAddress((ByteBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean glGetBoolean(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer data = stack.calloc(1);
            GLES20.nglGetBooleanv(pname, MemoryUtil.memAddress((ByteBuffer)data));
            boolean bl = data.get(0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetBufferParameteriv(int var0, int var1, long var2);

    public static void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetBufferParameteri(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nglGetError();

    public static int glGetError() {
        return GLES20.nglGetError();
    }

    public static native void nglGetFloatv(int var0, long var1);

    public static void glGetFloatv(int pname, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        GLES20.nglGetFloatv(pname, MemoryUtil.memAddress((FloatBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetFloat(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            GLES20.nglGetFloatv(pname, MemoryUtil.memAddress((FloatBuffer)data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetFramebufferAttachmentParameteriv(int var0, int var1, int var2, long var3);

    public static void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFramebufferAttachmentParameteri(int target, int attachment, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetIntegerv(int var0, long var1);

    public static void glGetIntegerv(int pname, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        GLES20.nglGetIntegerv(pname, MemoryUtil.memAddress((IntBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetInteger(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            GLES20.nglGetIntegerv(pname, MemoryUtil.memAddress((IntBuffer)data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetProgramiv(int var0, int var1, long var2);

    public static void glGetProgramiv(int program, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetProgramiv(program, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgrami(int program, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetProgramiv(program, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetProgramInfoLog(int var0, int var1, long var2, long var4);

    public static void glGetProgramInfoLog(int program, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        GLES20.nglGetProgramInfoLog(program, infoLog.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramInfoLog(int program, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetProgramInfoLog(program, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
            String string = MemoryUtil.memUTF8((ByteBuffer)infoLog, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)infoLog);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramInfoLog(int program) {
        int bufSize = GLES20.glGetProgrami(program, 35716);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetProgramInfoLog(program, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
            String string = MemoryUtil.memUTF8((ByteBuffer)infoLog, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)infoLog);
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetRenderbufferParameteriv(int var0, int var1, long var2);

    public static void glGetRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetRenderbufferParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetRenderbufferParameteri(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetRenderbufferParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetShaderiv(int var0, int var1, long var2);

    public static void glGetShaderiv(int shader, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetShaderi(int shader, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetShaderInfoLog(int var0, int var1, long var2, long var4);

    public static void glGetShaderInfoLog(int shader, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        GLES20.nglGetShaderInfoLog(shader, infoLog.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderInfoLog(int shader, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetShaderInfoLog(shader, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
            String string = MemoryUtil.memUTF8((ByteBuffer)infoLog, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)infoLog);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderInfoLog(int shader) {
        int bufSize = GLES20.glGetShaderi(shader, 35716);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetShaderInfoLog(shader, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
            String string = MemoryUtil.memUTF8((ByteBuffer)infoLog, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)infoLog);
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetShaderPrecisionFormat(int var0, int var1, long var2, long var4);

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)range, (int)2);
            Checks.check((Buffer)precision, (int)2);
        }
        GLES20.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress((IntBuffer)range), MemoryUtil.memAddress((IntBuffer)precision));
    }

    public static native void nglGetShaderSource(int var0, int var1, long var2, long var4);

    public static void glGetShaderSource(int shader, IntBuffer length, ByteBuffer source) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        GLES20.nglGetShaderSource(shader, source.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderSource(int shader, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetShaderSource(shader, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)source));
            String string = MemoryUtil.memUTF8((ByteBuffer)source, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)source);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderSource(int shader) {
        int bufSize = GLES20.glGetShaderi(shader, 35720);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetShaderSource(shader, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)source));
            String string = MemoryUtil.memUTF8((ByteBuffer)source, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)source);
            stack.setPointer(stackPointer);
        }
    }

    public static native long nglGetString(int var0);

    public static String glGetString(int name) {
        long __result = GLES20.nglGetString(name);
        return MemoryUtil.memUTF8((long)__result);
    }

    public static native void nglGetTexParameterfv(int var0, int var1, long var2);

    public static void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetTexParameterfv(target, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetTexParameterf(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GLES20.nglGetTexParameterfv(target, pname, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTexParameteriv(int var0, int var1, long var2);

    public static void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetTexParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTexParameteri(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetTexParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetUniformfv(int var0, int var1, long var2);

    public static void glGetUniformfv(int program, int location, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetUniformfv(program, location, MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetUniformf(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GLES20.nglGetUniformfv(program, location, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetUniformiv(int var0, int var1, long var2);

    public static void glGetUniformiv(int program, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetUniformiv(program, location, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformi(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetUniformiv(program, location, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nglGetUniformLocation(int var0, long var1);

    public static int glGetUniformLocation(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return GLES20.nglGetUniformLocation(program, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformLocation(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GLES20.nglGetUniformLocation(program, MemoryUtil.memAddress((ByteBuffer)nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetVertexAttribfv(int var0, int var1, long var2);

    public static void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)4);
        }
        GLES20.nglGetVertexAttribfv(index, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static native void nglGetVertexAttribiv(int var0, int var1, long var2);

    public static void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)4);
        }
        GLES20.nglGetVertexAttribiv(index, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    public static native void nglGetVertexAttribPointerv(int var0, int var1, long var2);

    public static void glGetVertexAttribPointerv(int index, int pname, PointerBuffer pointer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointer, (int)1);
        }
        GLES20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress((CustomBuffer)pointer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetVertexAttribPointer(int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer pointer = stack.callocPointer(1);
            GLES20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress((CustomBuffer)pointer));
            long l = pointer.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglHint(int var0, int var1);

    public static void glHint(int target, int mode) {
        GLES20.nglHint(target, mode);
    }

    public static native boolean nglIsBuffer(int var0);

    public static boolean glIsBuffer(int buffer) {
        return GLES20.nglIsBuffer(buffer);
    }

    public static native boolean nglIsEnabled(int var0);

    public static boolean glIsEnabled(int cap) {
        return GLES20.nglIsEnabled(cap);
    }

    public static native boolean nglIsFramebuffer(int var0);

    public static boolean glIsFramebuffer(int framebuffer) {
        return GLES20.nglIsFramebuffer(framebuffer);
    }

    public static native boolean nglIsProgram(int var0);

    public static boolean glIsProgram(int program) {
        return GLES20.nglIsProgram(program);
    }

    public static native boolean nglIsRenderbuffer(int var0);

    public static boolean glIsRenderbuffer(int renderbuffer) {
        return GLES20.nglIsRenderbuffer(renderbuffer);
    }

    public static native boolean nglIsShader(int var0);

    public static boolean glIsShader(int shader) {
        return GLES20.nglIsShader(shader);
    }

    public static native boolean nglIsTexture(int var0);

    public static boolean glIsTexture(int texture) {
        return GLES20.nglIsTexture(texture);
    }

    public static native void nglLineWidth(float var0);

    public static void glLineWidth(float width) {
        GLES20.nglLineWidth(width);
    }

    public static native void nglLinkProgram(int var0);

    public static void glLinkProgram(int program) {
        GLES20.nglLinkProgram(program);
    }

    public static native void nglPixelStorei(int var0, int var1);

    public static void glPixelStorei(int pname, int param) {
        GLES20.nglPixelStorei(pname, param);
    }

    public static native void nglPolygonOffset(float var0, float var1);

    public static void glPolygonOffset(float factor, float units) {
        GLES20.nglPolygonOffset(factor, units);
    }

    public static native void nglReadPixels(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, long pixels) {
        GLES20.nglReadPixels(x, y, width, height, format, type, pixels);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static native void nglReleaseShaderCompiler();

    public static void glReleaseShaderCompiler() {
        GLES20.nglReleaseShaderCompiler();
    }

    public static native void nglRenderbufferStorage(int var0, int var1, int var2, int var3);

    public static void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        GLES20.nglRenderbufferStorage(target, internalformat, width, height);
    }

    public static native void nglSampleCoverage(float var0, boolean var1);

    public static void glSampleCoverage(float value, boolean invert) {
        GLES20.nglSampleCoverage(value, invert);
    }

    public static native void nglScissor(int var0, int var1, int var2, int var3);

    public static void glScissor(int x, int y, int width, int height) {
        GLES20.nglScissor(x, y, width, height);
    }

    public static native void nglShaderBinary(int var0, long var1, int var3, long var4, int var6);

    public static void glShaderBinary(IntBuffer shaders, int binaryformat, ByteBuffer binary) {
        GLES20.nglShaderBinary(shaders.remaining(), MemoryUtil.memAddress((IntBuffer)shaders), binaryformat, MemoryUtil.memAddress((ByteBuffer)binary), binary.remaining());
    }

    public static native void nglShaderSource(int var0, int var1, long var2, long var4);

    public static void glShaderSource(int shader, PointerBuffer string, IntBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)string.remaining());
        }
        GLES20.nglShaderSource(shader, string.remaining(), MemoryUtil.memAddress((CustomBuffer)string), MemoryUtil.memAddressSafe((IntBuffer)length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int shader, CharSequence ... string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringAddress = APIUtil.apiArrayi((MemoryStack)stack, MemoryUtil::memUTF8, (CharSequence[])string);
            GLES20.nglShaderSource(shader, string.length, stringAddress, stringAddress - (long)(string.length << 2));
            APIUtil.apiArrayFree((long)stringAddress, (int)string.length);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int shader, CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringAddress = APIUtil.apiArrayi((MemoryStack)stack, MemoryUtil::memUTF8, (CharSequence[])new CharSequence[]{string});
            GLES20.nglShaderSource(shader, 1, stringAddress, stringAddress - 4L);
            APIUtil.apiArrayFree((long)stringAddress, (int)1);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglStencilFunc(int var0, int var1, int var2);

    public static void glStencilFunc(int func, int ref, int mask) {
        GLES20.nglStencilFunc(func, ref, mask);
    }

    public static native void nglStencilFuncSeparate(int var0, int var1, int var2, int var3);

    public static void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        GLES20.nglStencilFuncSeparate(face, func, ref, mask);
    }

    public static native void nglStencilMask(int var0);

    public static void glStencilMask(int mask) {
        GLES20.nglStencilMask(mask);
    }

    public static native void nglStencilMaskSeparate(int var0, int var1);

    public static void glStencilMaskSeparate(int face, int mask) {
        GLES20.nglStencilMaskSeparate(face, mask);
    }

    public static native void nglStencilOp(int var0, int var1, int var2);

    public static void glStencilOp(int fail, int zfail, int zpass) {
        GLES20.nglStencilOp(fail, zfail, zpass);
    }

    public static native void nglStencilOpSeparate(int var0, int var1, int var2, int var3);

    public static void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        GLES20.nglStencilOpSeparate(face, sfail, dpfail, dppass);
    }

    public static native void nglTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((ByteBuffer)pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels) {
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ShortBuffer pixels) {
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((ShortBuffer)pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((IntBuffer)pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, FloatBuffer pixels) {
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((FloatBuffer)pixels));
    }

    public static native void nglTexParameterf(int var0, int var1, float var2);

    public static void glTexParameterf(int target, int pname, float param) {
        GLES20.nglTexParameterf(target, pname, param);
    }

    public static native void nglTexParameterfv(int var0, int var1, long var2);

    public static void glTexParameterfv(int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglTexParameterfv(target, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static native void nglTexParameteri(int var0, int var1, int var2);

    public static void glTexParameteri(int target, int pname, int param) {
        GLES20.nglTexParameteri(target, pname, param);
    }

    public static native void nglTexParameteriv(int var0, int var1, long var2);

    public static void glTexParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglTexParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    public static native void nglTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static native void nglUniform1f(int var0, float var1);

    public static void glUniform1f(int location, float v0) {
        GLES20.nglUniform1f(location, v0);
    }

    public static native void nglUniform1fv(int var0, int var1, long var2);

    public static void glUniform1fv(int location, FloatBuffer value) {
        GLES20.nglUniform1fv(location, value.remaining(), MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniform1i(int var0, int var1);

    public static void glUniform1i(int location, int v0) {
        GLES20.nglUniform1i(location, v0);
    }

    public static native void nglUniform1iv(int var0, int var1, long var2);

    public static void glUniform1iv(int location, IntBuffer value) {
        GLES20.nglUniform1iv(location, value.remaining(), MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglUniform2f(int var0, float var1, float var2);

    public static void glUniform2f(int location, float v0, float v1) {
        GLES20.nglUniform2f(location, v0, v1);
    }

    public static native void nglUniform2fv(int var0, int var1, long var2);

    public static void glUniform2fv(int location, FloatBuffer value) {
        GLES20.nglUniform2fv(location, value.remaining() >> 1, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniform2i(int var0, int var1, int var2);

    public static void glUniform2i(int location, int v0, int v1) {
        GLES20.nglUniform2i(location, v0, v1);
    }

    public static native void nglUniform2iv(int var0, int var1, long var2);

    public static void glUniform2iv(int location, IntBuffer value) {
        GLES20.nglUniform2iv(location, value.remaining() >> 1, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglUniform3f(int var0, float var1, float var2, float var3);

    public static void glUniform3f(int location, float v0, float v1, float v2) {
        GLES20.nglUniform3f(location, v0, v1, v2);
    }

    public static native void nglUniform3fv(int var0, int var1, long var2);

    public static void glUniform3fv(int location, FloatBuffer value) {
        GLES20.nglUniform3fv(location, value.remaining() / 3, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniform3i(int var0, int var1, int var2, int var3);

    public static void glUniform3i(int location, int v0, int v1, int v2) {
        GLES20.nglUniform3i(location, v0, v1, v2);
    }

    public static native void nglUniform3iv(int var0, int var1, long var2);

    public static void glUniform3iv(int location, IntBuffer value) {
        GLES20.nglUniform3iv(location, value.remaining() / 3, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglUniform4f(int var0, float var1, float var2, float var3, float var4);

    public static void glUniform4f(int location, float v0, float v1, float v2, float v3) {
        GLES20.nglUniform4f(location, v0, v1, v2, v3);
    }

    public static native void nglUniform4fv(int var0, int var1, long var2);

    public static void glUniform4fv(int location, FloatBuffer value) {
        GLES20.nglUniform4fv(location, value.remaining() >> 2, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniform4i(int var0, int var1, int var2, int var3, int var4);

    public static void glUniform4i(int location, int v0, int v1, int v2, int v3) {
        GLES20.nglUniform4i(location, v0, v1, v2, v3);
    }

    public static native void nglUniform4iv(int var0, int var1, long var2);

    public static void glUniform4iv(int location, IntBuffer value) {
        GLES20.nglUniform4iv(location, value.remaining() >> 2, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglUniformMatrix2fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix2fv(int location, boolean transpose, FloatBuffer value) {
        GLES20.nglUniformMatrix2fv(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniformMatrix3fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3fv(int location, boolean transpose, FloatBuffer value) {
        GLES20.nglUniformMatrix3fv(location, value.remaining() / 9, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniformMatrix4fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4fv(int location, boolean transpose, FloatBuffer value) {
        GLES20.nglUniformMatrix4fv(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUseProgram(int var0);

    public static void glUseProgram(int program) {
        GLES20.nglUseProgram(program);
    }

    public static native void nglValidateProgram(int var0);

    public static void glValidateProgram(int program) {
        GLES20.nglValidateProgram(program);
    }

    public static native void nglVertexAttrib1f(int var0, float var1);

    public static void glVertexAttrib1f(int index, float x) {
        GLES20.nglVertexAttrib1f(index, x);
    }

    public static native void nglVertexAttrib1fv(int var0, long var1);

    public static void glVertexAttrib1fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, (int)1);
        }
        GLES20.nglVertexAttrib1fv(index, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static native void nglVertexAttrib2f(int var0, float var1, float var2);

    public static void glVertexAttrib2f(int index, float x, float y) {
        GLES20.nglVertexAttrib2f(index, x, y);
    }

    public static native void nglVertexAttrib2fv(int var0, long var1);

    public static void glVertexAttrib2fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, (int)2);
        }
        GLES20.nglVertexAttrib2fv(index, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static native void nglVertexAttrib3f(int var0, float var1, float var2, float var3);

    public static void glVertexAttrib3f(int index, float x, float y, float z) {
        GLES20.nglVertexAttrib3f(index, x, y, z);
    }

    public static native void nglVertexAttrib3fv(int var0, long var1);

    public static void glVertexAttrib3fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, (int)3);
        }
        GLES20.nglVertexAttrib3fv(index, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static native void nglVertexAttrib4f(int var0, float var1, float var2, float var3, float var4);

    public static void glVertexAttrib4f(int index, float x, float y, float z, float w) {
        GLES20.nglVertexAttrib4f(index, x, y, z, w);
    }

    public static native void nglVertexAttrib4fv(int var0, long var1);

    public static void glVertexAttrib4fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, (int)4);
        }
        GLES20.nglVertexAttrib4fv(index, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static native void nglVertexAttribPointer(int var0, int var1, int var2, boolean var3, int var4, long var5);

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ByteBuffer pointer) {
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress((ByteBuffer)pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ShortBuffer pointer) {
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress((ShortBuffer)pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, IntBuffer pointer) {
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress((IntBuffer)pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, FloatBuffer pointer) {
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress((FloatBuffer)pointer));
    }

    public static native void nglViewport(int var0, int var1, int var2, int var3);

    public static void glViewport(int x, int y, int width, int height) {
        GLES20.nglViewport(x, y, width, height);
    }

    public static void glBufferData(int target, short[] data, int usage) {
        long __functionAddress = GLES.getICD().glBufferData;
        JNI.callPPV((long)__functionAddress, (int)target, (long)(data.length << 1), (short[])data, (int)usage);
    }

    public static void glBufferData(int target, int[] data, int usage) {
        long __functionAddress = GLES.getICD().glBufferData;
        JNI.callPPV((long)__functionAddress, (int)target, (long)(data.length << 2), (int[])data, (int)usage);
    }

    public static void glBufferData(int target, float[] data, int usage) {
        long __functionAddress = GLES.getICD().glBufferData;
        JNI.callPPV((long)__functionAddress, (int)target, (long)(data.length << 2), (float[])data, (int)usage);
    }

    public static void glBufferSubData(int target, long offset, short[] data) {
        long __functionAddress = GLES.getICD().glBufferSubData;
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 1), (short[])data);
    }

    public static void glBufferSubData(int target, long offset, int[] data) {
        long __functionAddress = GLES.getICD().glBufferSubData;
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 2), (int[])data);
    }

    public static void glBufferSubData(int target, long offset, float[] data) {
        long __functionAddress = GLES.getICD().glBufferSubData;
        JNI.callPPPV((long)__functionAddress, (int)target, (long)offset, (long)(data.length << 2), (float[])data);
    }

    public static void glDeleteBuffers(int[] buffers) {
        long __functionAddress = GLES.getICD().glDeleteBuffers;
        JNI.callPV((long)__functionAddress, (int)buffers.length, (int[])buffers);
    }

    public static void glDeleteFramebuffers(int[] framebuffers) {
        long __functionAddress = GLES.getICD().glDeleteFramebuffers;
        JNI.callPV((long)__functionAddress, (int)framebuffers.length, (int[])framebuffers);
    }

    public static void glDeleteRenderbuffers(int[] renderbuffers) {
        long __functionAddress = GLES.getICD().glDeleteRenderbuffers;
        JNI.callPV((long)__functionAddress, (int)renderbuffers.length, (int[])renderbuffers);
    }

    public static void glDeleteTextures(int[] textures) {
        long __functionAddress = GLES.getICD().glDeleteTextures;
        JNI.callPV((long)__functionAddress, (int)textures.length, (int[])textures);
    }

    public static void glGenBuffers(int[] buffers) {
        long __functionAddress = GLES.getICD().glGenBuffers;
        JNI.callPV((long)__functionAddress, (int)buffers.length, (int[])buffers);
    }

    public static void glGenFramebuffers(int[] framebuffers) {
        long __functionAddress = GLES.getICD().glGenFramebuffers;
        JNI.callPV((long)__functionAddress, (int)framebuffers.length, (int[])framebuffers);
    }

    public static void glGenRenderbuffers(int[] renderbuffers) {
        long __functionAddress = GLES.getICD().glGenRenderbuffers;
        JNI.callPV((long)__functionAddress, (int)renderbuffers.length, (int[])renderbuffers);
    }

    public static void glGenTextures(int[] textures) {
        long __functionAddress = GLES.getICD().glGenTextures;
        JNI.callPV((long)__functionAddress, (int)textures.length, (int[])textures);
    }

    public static void glGetActiveAttrib(int program, int index, int[] length, int[] size, int[] type, ByteBuffer name) {
        long __functionAddress = GLES.getICD().glGetActiveAttrib;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])length, (int)1);
            Checks.check((int[])size, (int)1);
            Checks.check((int[])type, (int)1);
        }
        JNI.callPPPPV((long)__functionAddress, (int)program, (int)index, (int)name.remaining(), (int[])length, (int[])size, (int[])type, (long)MemoryUtil.memAddress((ByteBuffer)name));
    }

    public static void glGetActiveUniform(int program, int index, int[] length, int[] size, int[] type, ByteBuffer name) {
        long __functionAddress = GLES.getICD().glGetActiveUniform;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])length, (int)1);
            Checks.check((int[])size, (int)1);
            Checks.check((int[])type, (int)1);
        }
        JNI.callPPPPV((long)__functionAddress, (int)program, (int)index, (int)name.remaining(), (int[])length, (int[])size, (int[])type, (long)MemoryUtil.memAddress((ByteBuffer)name));
    }

    public static void glGetAttachedShaders(int program, int[] count, int[] shaders) {
        long __functionAddress = GLES.getICD().glGetAttachedShaders;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])count, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)program, (int)shaders.length, (int[])count, (int[])shaders);
    }

    public static void glGetBufferParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetBufferParameteriv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glGetFloatv(int pname, float[] data) {
        long __functionAddress = GLES.getICD().glGetFloatv;
        if (Checks.CHECKS) {
            Checks.check((float[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (float[])data);
    }

    public static void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetFramebufferAttachmentParameteriv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)attachment, (int)pname, (int[])params);
    }

    public static void glGetIntegerv(int pname, int[] data) {
        long __functionAddress = GLES.getICD().glGetIntegerv;
        if (Checks.CHECKS) {
            Checks.check((int[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (int[])data);
    }

    public static void glGetProgramiv(int program, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetProgramiv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)pname, (int[])params);
    }

    public static void glGetProgramInfoLog(int program, int[] length, ByteBuffer infoLog) {
        long __functionAddress = GLES.getICD().glGetProgramInfoLog;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)program, (int)infoLog.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)infoLog));
    }

    public static void glGetRenderbufferParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetRenderbufferParameteriv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glGetShaderiv(int shader, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetShaderiv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)shader, (int)pname, (int[])params);
    }

    public static void glGetShaderInfoLog(int shader, int[] length, ByteBuffer infoLog) {
        long __functionAddress = GLES.getICD().glGetShaderInfoLog;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)shader, (int)infoLog.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)infoLog));
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, int[] range, int[] precision) {
        long __functionAddress = GLES.getICD().glGetShaderPrecisionFormat;
        if (Checks.CHECKS) {
            Checks.check((int[])range, (int)2);
            Checks.check((int[])precision, (int)2);
        }
        JNI.callPPV((long)__functionAddress, (int)shadertype, (int)precisiontype, (int[])range, (int[])precision);
    }

    public static void glGetShaderSource(int shader, int[] length, ByteBuffer source) {
        long __functionAddress = GLES.getICD().glGetShaderSource;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)shader, (int)source.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)source));
    }

    public static void glGetTexParameterfv(int target, int pname, float[] params) {
        long __functionAddress = GLES.getICD().glGetTexParameterfv;
        if (Checks.CHECKS) {
            Checks.check((float[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (float[])params);
    }

    public static void glGetTexParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetTexParameteriv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glGetUniformfv(int program, int location, float[] params) {
        long __functionAddress = GLES.getICD().glGetUniformfv;
        if (Checks.CHECKS) {
            Checks.check((float[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (float[])params);
    }

    public static void glGetUniformiv(int program, int location, int[] params) {
        long __functionAddress = GLES.getICD().glGetUniformiv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int[])params);
    }

    public static void glGetVertexAttribfv(int index, int pname, float[] params) {
        long __functionAddress = GLES.getICD().glGetVertexAttribfv;
        if (Checks.CHECKS) {
            Checks.check((float[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)index, (int)pname, (float[])params);
    }

    public static void glGetVertexAttribiv(int index, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetVertexAttribiv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)index, (int)pname, (int[])params);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GLES.getICD().glReadPixels;
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (short[])pixels);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GLES.getICD().glReadPixels;
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int[])pixels);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GLES.getICD().glReadPixels;
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (float[])pixels);
    }

    public static void glShaderBinary(int[] shaders, int binaryformat, ByteBuffer binary) {
        long __functionAddress = GLES.getICD().glShaderBinary;
        JNI.callPPV((long)__functionAddress, (int)shaders.length, (int[])shaders, (int)binaryformat, (long)MemoryUtil.memAddress((ByteBuffer)binary), (int)binary.remaining());
    }

    public static void glShaderSource(int shader, PointerBuffer string, int[] length) {
        long __functionAddress = GLES.getICD().glShaderSource;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])length, (int)string.remaining());
        }
        JNI.callPPV((long)__functionAddress, (int)shader, (int)string.remaining(), (long)MemoryUtil.memAddress((CustomBuffer)string), (int[])length);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, short[] pixels) {
        long __functionAddress = GLES.getICD().glTexImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (short[])pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, int[] pixels) {
        long __functionAddress = GLES.getICD().glTexImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (int[])pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, float[] pixels) {
        long __functionAddress = GLES.getICD().glTexImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (float[])pixels);
    }

    public static void glTexParameterfv(int target, int pname, float[] params) {
        long __functionAddress = GLES.getICD().glTexParameterfv;
        if (Checks.CHECKS) {
            Checks.check((float[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (float[])params);
    }

    public static void glTexParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glTexParameteriv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GLES.getICD().glTexSubImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (short[])pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GLES.getICD().glTexSubImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (int[])pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GLES.getICD().glTexSubImage2D;
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (float[])pixels);
    }

    public static void glUniform1fv(int location, float[] value) {
        long __functionAddress = GLES.getICD().glUniform1fv;
        JNI.callPV((long)__functionAddress, (int)location, (int)value.length, (float[])value);
    }

    public static void glUniform1iv(int location, int[] value) {
        long __functionAddress = GLES.getICD().glUniform1iv;
        JNI.callPV((long)__functionAddress, (int)location, (int)value.length, (int[])value);
    }

    public static void glUniform2fv(int location, float[] value) {
        long __functionAddress = GLES.getICD().glUniform2fv;
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 1), (float[])value);
    }

    public static void glUniform2iv(int location, int[] value) {
        long __functionAddress = GLES.getICD().glUniform2iv;
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 1), (int[])value);
    }

    public static void glUniform3fv(int location, float[] value) {
        long __functionAddress = GLES.getICD().glUniform3fv;
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length / 3), (float[])value);
    }

    public static void glUniform3iv(int location, int[] value) {
        long __functionAddress = GLES.getICD().glUniform3iv;
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length / 3), (int[])value);
    }

    public static void glUniform4fv(int location, float[] value) {
        long __functionAddress = GLES.getICD().glUniform4fv;
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 2), (float[])value);
    }

    public static void glUniform4iv(int location, int[] value) {
        long __functionAddress = GLES.getICD().glUniform4iv;
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 2), (int[])value);
    }

    public static void glUniformMatrix2fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glUniformMatrix2fv;
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 2), (boolean)transpose, (float[])value);
    }

    public static void glUniformMatrix3fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glUniformMatrix3fv;
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length / 9), (boolean)transpose, (float[])value);
    }

    public static void glUniformMatrix4fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glUniformMatrix4fv;
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 4), (boolean)transpose, (float[])value);
    }

    public static void glVertexAttrib1fv(int index, float[] v) {
        long __functionAddress = GLES.getICD().glVertexAttrib1fv;
        if (Checks.CHECKS) {
            Checks.check((float[])v, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)index, (float[])v);
    }

    public static void glVertexAttrib2fv(int index, float[] v) {
        long __functionAddress = GLES.getICD().glVertexAttrib2fv;
        if (Checks.CHECKS) {
            Checks.check((float[])v, (int)2);
        }
        JNI.callPV((long)__functionAddress, (int)index, (float[])v);
    }

    public static void glVertexAttrib3fv(int index, float[] v) {
        long __functionAddress = GLES.getICD().glVertexAttrib3fv;
        if (Checks.CHECKS) {
            Checks.check((float[])v, (int)3);
        }
        JNI.callPV((long)__functionAddress, (int)index, (float[])v);
    }

    public static void glVertexAttrib4fv(int index, float[] v) {
        long __functionAddress = GLES.getICD().glVertexAttrib4fv;
        if (Checks.CHECKS) {
            Checks.check((float[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)index, (float[])v);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, short[] pointer) {
        long __functionAddress = GLES.getICD().glVertexAttribPointer;
        JNI.callPV((long)__functionAddress, (int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (short[])pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, int[] pointer) {
        long __functionAddress = GLES.getICD().glVertexAttribPointer;
        JNI.callPV((long)__functionAddress, (int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (int[])pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, float[] pointer) {
        long __functionAddress = GLES.getICD().glVertexAttribPointer;
        JNI.callPV((long)__functionAddress, (int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (float[])pointer);
    }

    static {
        GLES.initialize();
    }
}

