/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GLES31 {
    public static final int GL_COMPUTE_SHADER = 37305;
    public static final int GL_MAX_COMPUTE_UNIFORM_BLOCKS = 37307;
    public static final int GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 37308;
    public static final int GL_MAX_COMPUTE_IMAGE_UNIFORMS = 37309;
    public static final int GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = 33378;
    public static final int GL_MAX_COMPUTE_UNIFORM_COMPONENTS = 33379;
    public static final int GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 33380;
    public static final int GL_MAX_COMPUTE_ATOMIC_COUNTERS = 33381;
    public static final int GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 33382;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = 37099;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_COUNT = 37310;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_SIZE = 37311;
    public static final int GL_COMPUTE_WORK_GROUP_SIZE = 33383;
    public static final int GL_DISPATCH_INDIRECT_BUFFER = 37102;
    public static final int GL_DISPATCH_INDIRECT_BUFFER_BINDING = 37103;
    public static final int GL_COMPUTE_SHADER_BIT = 32;
    public static final int GL_DRAW_INDIRECT_BUFFER = 36671;
    public static final int GL_DRAW_INDIRECT_BUFFER_BINDING = 36675;
    public static final int GL_MAX_UNIFORM_LOCATIONS = 33390;
    public static final int GL_FRAMEBUFFER_DEFAULT_WIDTH = 37648;
    public static final int GL_FRAMEBUFFER_DEFAULT_HEIGHT = 37649;
    public static final int GL_FRAMEBUFFER_DEFAULT_SAMPLES = 37651;
    public static final int GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 37652;
    public static final int GL_MAX_FRAMEBUFFER_WIDTH = 37653;
    public static final int GL_MAX_FRAMEBUFFER_HEIGHT = 37654;
    public static final int GL_MAX_FRAMEBUFFER_SAMPLES = 37656;
    public static final int GL_UNIFORM = 37601;
    public static final int GL_UNIFORM_BLOCK = 37602;
    public static final int GL_PROGRAM_INPUT = 37603;
    public static final int GL_PROGRAM_OUTPUT = 37604;
    public static final int GL_BUFFER_VARIABLE = 37605;
    public static final int GL_SHADER_STORAGE_BLOCK = 37606;
    public static final int GL_ATOMIC_COUNTER_BUFFER = 37568;
    public static final int GL_TRANSFORM_FEEDBACK_VARYING = 37620;
    public static final int GL_ACTIVE_RESOURCES = 37621;
    public static final int GL_MAX_NAME_LENGTH = 37622;
    public static final int GL_MAX_NUM_ACTIVE_VARIABLES = 37623;
    public static final int GL_NAME_LENGTH = 37625;
    public static final int GL_TYPE = 37626;
    public static final int GL_ARRAY_SIZE = 37627;
    public static final int GL_OFFSET = 37628;
    public static final int GL_BLOCK_INDEX = 37629;
    public static final int GL_ARRAY_STRIDE = 37630;
    public static final int GL_MATRIX_STRIDE = 37631;
    public static final int GL_IS_ROW_MAJOR = 37632;
    public static final int GL_ATOMIC_COUNTER_BUFFER_INDEX = 37633;
    public static final int GL_BUFFER_BINDING = 37634;
    public static final int GL_BUFFER_DATA_SIZE = 37635;
    public static final int GL_NUM_ACTIVE_VARIABLES = 37636;
    public static final int GL_ACTIVE_VARIABLES = 37637;
    public static final int GL_REFERENCED_BY_VERTEX_SHADER = 37638;
    public static final int GL_REFERENCED_BY_FRAGMENT_SHADER = 37642;
    public static final int GL_REFERENCED_BY_COMPUTE_SHADER = 37643;
    public static final int GL_TOP_LEVEL_ARRAY_SIZE = 37644;
    public static final int GL_TOP_LEVEL_ARRAY_STRIDE = 37645;
    public static final int GL_LOCATION = 37646;
    public static final int GL_VERTEX_SHADER_BIT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT = 2;
    public static final int GL_ALL_SHADER_BITS = -1;
    public static final int GL_PROGRAM_SEPARABLE = 33368;
    public static final int GL_ACTIVE_PROGRAM = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING = 33370;
    public static final int GL_ATOMIC_COUNTER_BUFFER_BINDING = 37569;
    public static final int GL_ATOMIC_COUNTER_BUFFER_START = 37570;
    public static final int GL_ATOMIC_COUNTER_BUFFER_SIZE = 37571;
    public static final int GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = 37580;
    public static final int GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = 37584;
    public static final int GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = 37585;
    public static final int GL_MAX_VERTEX_ATOMIC_COUNTERS = 37586;
    public static final int GL_MAX_FRAGMENT_ATOMIC_COUNTERS = 37590;
    public static final int GL_MAX_COMBINED_ATOMIC_COUNTERS = 37591;
    public static final int GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE = 37592;
    public static final int GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = 37596;
    public static final int GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = 37593;
    public static final int GL_UNSIGNED_INT_ATOMIC_COUNTER = 37595;
    public static final int GL_MAX_IMAGE_UNITS = 36664;
    public static final int GL_MAX_VERTEX_IMAGE_UNIFORMS = 37066;
    public static final int GL_MAX_FRAGMENT_IMAGE_UNIFORMS = 37070;
    public static final int GL_MAX_COMBINED_IMAGE_UNIFORMS = 37071;
    public static final int GL_IMAGE_BINDING_NAME = 36666;
    public static final int GL_IMAGE_BINDING_LEVEL = 36667;
    public static final int GL_IMAGE_BINDING_LAYERED = 36668;
    public static final int GL_IMAGE_BINDING_LAYER = 36669;
    public static final int GL_IMAGE_BINDING_ACCESS = 36670;
    public static final int GL_IMAGE_BINDING_FORMAT = 36974;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = 1;
    public static final int GL_ELEMENT_ARRAY_BARRIER_BIT = 2;
    public static final int GL_UNIFORM_BARRIER_BIT = 4;
    public static final int GL_TEXTURE_FETCH_BARRIER_BIT = 8;
    public static final int GL_SHADER_IMAGE_ACCESS_BARRIER_BIT = 32;
    public static final int GL_COMMAND_BARRIER_BIT = 64;
    public static final int GL_PIXEL_BUFFER_BARRIER_BIT = 128;
    public static final int GL_TEXTURE_UPDATE_BARRIER_BIT = 256;
    public static final int GL_BUFFER_UPDATE_BARRIER_BIT = 512;
    public static final int GL_FRAMEBUFFER_BARRIER_BIT = 1024;
    public static final int GL_TRANSFORM_FEEDBACK_BARRIER_BIT = 2048;
    public static final int GL_ATOMIC_COUNTER_BARRIER_BIT = 4096;
    public static final int GL_ALL_BARRIER_BITS = -1;
    public static final int GL_IMAGE_2D = 36941;
    public static final int GL_IMAGE_3D = 36942;
    public static final int GL_IMAGE_CUBE = 36944;
    public static final int GL_IMAGE_2D_ARRAY = 36947;
    public static final int GL_INT_IMAGE_2D = 36952;
    public static final int GL_INT_IMAGE_3D = 36953;
    public static final int GL_INT_IMAGE_CUBE = 36955;
    public static final int GL_INT_IMAGE_2D_ARRAY = 36958;
    public static final int GL_UNSIGNED_INT_IMAGE_2D = 36963;
    public static final int GL_UNSIGNED_INT_IMAGE_3D = 36964;
    public static final int GL_UNSIGNED_INT_IMAGE_CUBE = 36966;
    public static final int GL_UNSIGNED_INT_IMAGE_2D_ARRAY = 36969;
    public static final int GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = 37063;
    public static final int GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = 37064;
    public static final int GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = 37065;
    public static final int GL_READ_ONLY = 35000;
    public static final int GL_WRITE_ONLY = 35001;
    public static final int GL_READ_WRITE = 35002;
    public static final int GL_SHADER_STORAGE_BUFFER = 37074;
    public static final int GL_SHADER_STORAGE_BUFFER_BINDING = 37075;
    public static final int GL_SHADER_STORAGE_BUFFER_START = 37076;
    public static final int GL_SHADER_STORAGE_BUFFER_SIZE = 37077;
    public static final int GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = 37078;
    public static final int GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = 37082;
    public static final int GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = 37083;
    public static final int GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = 37084;
    public static final int GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = 37085;
    public static final int GL_MAX_SHADER_STORAGE_BLOCK_SIZE = 37086;
    public static final int GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = 37087;
    public static final int GL_SHADER_STORAGE_BARRIER_BIT = 8192;
    public static final int GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = 36665;
    public static final int GL_DEPTH_STENCIL_TEXTURE_MODE = 37098;
    public static final int GL_STENCIL_INDEX = 6401;
    public static final int GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 36446;
    public static final int GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 36447;
    public static final int GL_SAMPLE_POSITION = 36432;
    public static final int GL_SAMPLE_MASK = 36433;
    public static final int GL_SAMPLE_MASK_VALUE = 36434;
    public static final int GL_TEXTURE_2D_MULTISAMPLE = 37120;
    public static final int GL_MAX_SAMPLE_MASK_WORDS = 36441;
    public static final int GL_MAX_COLOR_TEXTURE_SAMPLES = 37134;
    public static final int GL_MAX_DEPTH_TEXTURE_SAMPLES = 37135;
    public static final int GL_MAX_INTEGER_SAMPLES = 37136;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE = 37124;
    public static final int GL_TEXTURE_SAMPLES = 37126;
    public static final int GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 37127;
    public static final int GL_TEXTURE_WIDTH = 4096;
    public static final int GL_TEXTURE_HEIGHT = 4097;
    public static final int GL_TEXTURE_DEPTH = 32881;
    public static final int GL_TEXTURE_INTERNAL_FORMAT = 4099;
    public static final int GL_TEXTURE_RED_SIZE = 32860;
    public static final int GL_TEXTURE_GREEN_SIZE = 32861;
    public static final int GL_TEXTURE_BLUE_SIZE = 32862;
    public static final int GL_TEXTURE_ALPHA_SIZE = 32863;
    public static final int GL_TEXTURE_DEPTH_SIZE = 34890;
    public static final int GL_TEXTURE_STENCIL_SIZE = 35057;
    public static final int GL_TEXTURE_SHARED_SIZE = 35903;
    public static final int GL_TEXTURE_RED_TYPE = 35856;
    public static final int GL_TEXTURE_GREEN_TYPE = 35857;
    public static final int GL_TEXTURE_BLUE_TYPE = 35858;
    public static final int GL_TEXTURE_ALPHA_TYPE = 35859;
    public static final int GL_TEXTURE_DEPTH_TYPE = 35862;
    public static final int GL_TEXTURE_COMPRESSED = 34465;
    public static final int GL_SAMPLER_2D_MULTISAMPLE = 37128;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE = 37129;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 37130;
    public static final int GL_VERTEX_ATTRIB_BINDING = 33492;
    public static final int GL_VERTEX_ATTRIB_RELATIVE_OFFSET = 33493;
    public static final int GL_VERTEX_BINDING_DIVISOR = 33494;
    public static final int GL_VERTEX_BINDING_OFFSET = 33495;
    public static final int GL_VERTEX_BINDING_STRIDE = 33496;
    public static final int GL_VERTEX_BINDING_BUFFER = 36687;
    public static final int GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = 33497;
    public static final int GL_MAX_VERTEX_ATTRIB_BINDINGS = 33498;
    public static final int GL_MAX_VERTEX_ATTRIB_STRIDE = 33509;

    protected GLES31() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glDispatchCompute, caps.glDispatchComputeIndirect, caps.glDrawArraysIndirect, caps.glDrawElementsIndirect, caps.glFramebufferParameteri, caps.glGetFramebufferParameteriv, caps.glGetProgramInterfaceiv, caps.glGetProgramResourceIndex, caps.glGetProgramResourceName, caps.glGetProgramResourceiv, caps.glGetProgramResourceLocation, caps.glUseProgramStages, caps.glActiveShaderProgram, caps.glCreateShaderProgramv, caps.glBindProgramPipeline, caps.glDeleteProgramPipelines, caps.glGenProgramPipelines, caps.glIsProgramPipeline, caps.glGetProgramPipelineiv, caps.glProgramUniform1i, caps.glProgramUniform2i, caps.glProgramUniform3i, caps.glProgramUniform4i, caps.glProgramUniform1ui, caps.glProgramUniform2ui, caps.glProgramUniform3ui, caps.glProgramUniform4ui, caps.glProgramUniform1f, caps.glProgramUniform2f, caps.glProgramUniform3f, caps.glProgramUniform4f, caps.glProgramUniform1iv, caps.glProgramUniform2iv, caps.glProgramUniform3iv, caps.glProgramUniform4iv, caps.glProgramUniform1uiv, caps.glProgramUniform2uiv, caps.glProgramUniform3uiv, caps.glProgramUniform4uiv, caps.glProgramUniform1fv, caps.glProgramUniform2fv, caps.glProgramUniform3fv, caps.glProgramUniform4fv, caps.glProgramUniformMatrix2fv, caps.glProgramUniformMatrix3fv, caps.glProgramUniformMatrix4fv, caps.glProgramUniformMatrix2x3fv, caps.glProgramUniformMatrix3x2fv, caps.glProgramUniformMatrix2x4fv, caps.glProgramUniformMatrix4x2fv, caps.glProgramUniformMatrix3x4fv, caps.glProgramUniformMatrix4x3fv, caps.glValidateProgramPipeline, caps.glGetProgramPipelineInfoLog, caps.glBindImageTexture, caps.glGetBooleani_v, caps.glMemoryBarrier, caps.glMemoryBarrierByRegion, caps.glTexStorage2DMultisample, caps.glGetMultisamplefv, caps.glSampleMaski, caps.glGetTexLevelParameteriv, caps.glGetTexLevelParameterfv, caps.glBindVertexBuffer, caps.glVertexAttribFormat, caps.glVertexAttribIFormat, caps.glVertexAttribBinding, caps.glVertexBindingDivisor});
    }

    public static native void nglDispatchCompute(int var0, int var1, int var2);

    public static void glDispatchCompute(int num_groups_x, int num_groups_y, int num_groups_z) {
        GLES31.nglDispatchCompute(num_groups_x, num_groups_y, num_groups_z);
    }

    public static native void nglDispatchComputeIndirect(long var0);

    public static void glDispatchComputeIndirect(long indirect) {
        GLES31.nglDispatchComputeIndirect(indirect);
    }

    public static native void nglDrawArraysIndirect(int var0, long var1);

    public static void glDrawArraysIndirect(int mode, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)16);
        }
        GLES31.nglDrawArraysIndirect(mode, MemoryUtil.memAddress((ByteBuffer)indirect));
    }

    public static void glDrawArraysIndirect(int mode, long indirect) {
        GLES31.nglDrawArraysIndirect(mode, indirect);
    }

    public static void glDrawArraysIndirect(int mode, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)4);
        }
        GLES31.nglDrawArraysIndirect(mode, MemoryUtil.memAddress((IntBuffer)indirect));
    }

    public static native void nglDrawElementsIndirect(int var0, int var1, long var2);

    public static void glDrawElementsIndirect(int mode, int type, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)20);
        }
        GLES31.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress((ByteBuffer)indirect));
    }

    public static void glDrawElementsIndirect(int mode, int type, long indirect) {
        GLES31.nglDrawElementsIndirect(mode, type, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)5);
        }
        GLES31.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress((IntBuffer)indirect));
    }

    public static native void nglFramebufferParameteri(int var0, int var1, int var2);

    public static void glFramebufferParameteri(int target, int pname, int param) {
        GLES31.nglFramebufferParameteri(target, pname, param);
    }

    public static native void nglGetFramebufferParameteriv(int var0, int var1, long var2);

    public static void glGetFramebufferParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES31.nglGetFramebufferParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFramebufferParameteri(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES31.nglGetFramebufferParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetProgramInterfaceiv(int var0, int var1, int var2, long var3);

    public static void glGetProgramInterfaceiv(int program, int programInterface, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES31.nglGetProgramInterfaceiv(program, programInterface, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgramInterfacei(int program, int programInterface, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES31.nglGetProgramInterfaceiv(program, programInterface, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nglGetProgramResourceIndex(int var0, int var1, long var2);

    public static int glGetProgramResourceIndex(int program, int programInterface, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return GLES31.nglGetProgramResourceIndex(program, programInterface, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgramResourceIndex(int program, int programInterface, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GLES31.nglGetProgramResourceIndex(program, programInterface, MemoryUtil.memAddress((ByteBuffer)nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetProgramResourceName(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glGetProgramResourceName(int program, int programInterface, int index, IntBuffer length, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        GLES31.nglGetProgramResourceName(program, programInterface, index, name.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramResourceName(int program, int programInterface, int index, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES31.nglGetProgramResourceName(program, programInterface, index, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)name));
            String string = MemoryUtil.memASCII((ByteBuffer)name, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramResourceName(int program, int programInterface, int index) {
        int bufSize = GLES31.glGetProgramInterfacei(program, programInterface, 37622);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES31.nglGetProgramResourceName(program, programInterface, index, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)name));
            String string = MemoryUtil.memASCII((ByteBuffer)name, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetProgramResourceiv(int var0, int var1, int var2, int var3, long var4, int var6, long var7, long var9);

    public static void glGetProgramResourceiv(int program, int programInterface, int index, IntBuffer props, IntBuffer length, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        GLES31.nglGetProgramResourceiv(program, programInterface, index, props.remaining(), MemoryUtil.memAddress((IntBuffer)props), params.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)params));
    }

    public static native int nglGetProgramResourceLocation(int var0, int var1, long var2);

    public static int glGetProgramResourceLocation(int program, int programInterface, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return GLES31.nglGetProgramResourceLocation(program, programInterface, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgramResourceLocation(int program, int programInterface, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GLES31.nglGetProgramResourceLocation(program, programInterface, MemoryUtil.memAddress((ByteBuffer)nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglUseProgramStages(int var0, int var1, int var2);

    public static void glUseProgramStages(int pipeline, int stages, int program) {
        GLES31.nglUseProgramStages(pipeline, stages, program);
    }

    public static native void nglActiveShaderProgram(int var0, int var1);

    public static void glActiveShaderProgram(int pipeline, int program) {
        GLES31.nglActiveShaderProgram(pipeline, program);
    }

    public static native int nglCreateShaderProgramv(int var0, int var1, long var2);

    public static int glCreateShaderProgramv(int type, PointerBuffer strings) {
        return GLES31.nglCreateShaderProgramv(type, strings.remaining(), MemoryUtil.memAddress((CustomBuffer)strings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramv(int type, CharSequence ... strings) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArray((MemoryStack)stack, MemoryUtil::memUTF8, (CharSequence[])strings);
            int __result = GLES31.nglCreateShaderProgramv(type, strings.length, stringsAddress);
            APIUtil.apiArrayFree((long)stringsAddress, (int)strings.length);
            int n = __result;
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramv(int type, CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArray((MemoryStack)stack, MemoryUtil::memUTF8, (CharSequence[])new CharSequence[]{string});
            int __result = GLES31.nglCreateShaderProgramv(type, 1, stringsAddress);
            APIUtil.apiArrayFree((long)stringsAddress, (int)1);
            int n = __result;
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglBindProgramPipeline(int var0);

    public static void glBindProgramPipeline(int pipeline) {
        GLES31.nglBindProgramPipeline(pipeline);
    }

    public static native void nglDeleteProgramPipelines(int var0, long var1);

    public static void glDeleteProgramPipelines(IntBuffer pipelines) {
        GLES31.nglDeleteProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress((IntBuffer)pipelines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteProgramPipelines(int pipeline) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer pipelines = stack.ints(pipeline);
            GLES31.nglDeleteProgramPipelines(1, MemoryUtil.memAddress((IntBuffer)pipelines));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenProgramPipelines(int var0, long var1);

    public static void glGenProgramPipelines(IntBuffer pipelines) {
        GLES31.nglGenProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress((IntBuffer)pipelines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenProgramPipelines() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer pipelines = stack.callocInt(1);
            GLES31.nglGenProgramPipelines(1, MemoryUtil.memAddress((IntBuffer)pipelines));
            int n = pipelines.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean nglIsProgramPipeline(int var0);

    public static boolean glIsProgramPipeline(int pipeline) {
        return GLES31.nglIsProgramPipeline(pipeline);
    }

    public static native void nglGetProgramPipelineiv(int var0, int var1, long var2);

    public static void glGetProgramPipelineiv(int pipeline, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES31.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgramPipelinei(int pipeline, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES31.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglProgramUniform1i(int var0, int var1, int var2);

    public static void glProgramUniform1i(int program, int location, int v0) {
        GLES31.nglProgramUniform1i(program, location, v0);
    }

    public static native void nglProgramUniform2i(int var0, int var1, int var2, int var3);

    public static void glProgramUniform2i(int program, int location, int v0, int v1) {
        GLES31.nglProgramUniform2i(program, location, v0, v1);
    }

    public static native void nglProgramUniform3i(int var0, int var1, int var2, int var3, int var4);

    public static void glProgramUniform3i(int program, int location, int v0, int v1, int v2) {
        GLES31.nglProgramUniform3i(program, location, v0, v1, v2);
    }

    public static native void nglProgramUniform4i(int var0, int var1, int var2, int var3, int var4, int var5);

    public static void glProgramUniform4i(int program, int location, int v0, int v1, int v2, int v3) {
        GLES31.nglProgramUniform4i(program, location, v0, v1, v2, v3);
    }

    public static native void nglProgramUniform1ui(int var0, int var1, int var2);

    public static void glProgramUniform1ui(int program, int location, int v0) {
        GLES31.nglProgramUniform1ui(program, location, v0);
    }

    public static native void nglProgramUniform2ui(int var0, int var1, int var2, int var3);

    public static void glProgramUniform2ui(int program, int location, int v0, int v1) {
        GLES31.nglProgramUniform2ui(program, location, v0, v1);
    }

    public static native void nglProgramUniform3ui(int var0, int var1, int var2, int var3, int var4);

    public static void glProgramUniform3ui(int program, int location, int v0, int v1, int v2) {
        GLES31.nglProgramUniform3ui(program, location, v0, v1, v2);
    }

    public static native void nglProgramUniform4ui(int var0, int var1, int var2, int var3, int var4, int var5);

    public static void glProgramUniform4ui(int program, int location, int v0, int v1, int v2, int v3) {
        GLES31.nglProgramUniform4ui(program, location, v0, v1, v2, v3);
    }

    public static native void nglProgramUniform1f(int var0, int var1, float var2);

    public static void glProgramUniform1f(int program, int location, float v0) {
        GLES31.nglProgramUniform1f(program, location, v0);
    }

    public static native void nglProgramUniform2f(int var0, int var1, float var2, float var3);

    public static void glProgramUniform2f(int program, int location, float v0, float v1) {
        GLES31.nglProgramUniform2f(program, location, v0, v1);
    }

    public static native void nglProgramUniform3f(int var0, int var1, float var2, float var3, float var4);

    public static void glProgramUniform3f(int program, int location, float v0, float v1, float v2) {
        GLES31.nglProgramUniform3f(program, location, v0, v1, v2);
    }

    public static native void nglProgramUniform4f(int var0, int var1, float var2, float var3, float var4, float var5);

    public static void glProgramUniform4f(int program, int location, float v0, float v1, float v2, float v3) {
        GLES31.nglProgramUniform4f(program, location, v0, v1, v2, v3);
    }

    public static native void nglProgramUniform1iv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1iv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform1iv(program, location, value.remaining(), MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglProgramUniform2iv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2iv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform2iv(program, location, value.remaining() >> 1, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglProgramUniform3iv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3iv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform3iv(program, location, value.remaining() / 3, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglProgramUniform4iv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4iv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform4iv(program, location, value.remaining() >> 2, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglProgramUniform1uiv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1uiv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform1uiv(program, location, value.remaining(), MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglProgramUniform2uiv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2uiv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform2uiv(program, location, value.remaining() >> 1, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglProgramUniform3uiv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3uiv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform3uiv(program, location, value.remaining() / 3, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglProgramUniform4uiv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4uiv(int program, int location, IntBuffer value) {
        GLES31.nglProgramUniform4uiv(program, location, value.remaining() >> 2, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglProgramUniform1fv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1fv(int program, int location, FloatBuffer value) {
        GLES31.nglProgramUniform1fv(program, location, value.remaining(), MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglProgramUniform2fv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2fv(int program, int location, FloatBuffer value) {
        GLES31.nglProgramUniform2fv(program, location, value.remaining() >> 1, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglProgramUniform3fv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3fv(int program, int location, FloatBuffer value) {
        GLES31.nglProgramUniform3fv(program, location, value.remaining() / 3, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglProgramUniform4fv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4fv(int program, int location, FloatBuffer value) {
        GLES31.nglProgramUniform4fv(program, location, value.remaining() >> 2, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglProgramUniformMatrix2fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix2fv(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglProgramUniformMatrix3fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix3fv(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglProgramUniformMatrix4fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix4fv(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglProgramUniformMatrix2x3fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2x3fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix2x3fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglProgramUniformMatrix3x2fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3x2fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix3x2fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglProgramUniformMatrix2x4fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2x4fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix2x4fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglProgramUniformMatrix4x2fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4x2fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix4x2fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglProgramUniformMatrix3x4fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3x4fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix3x4fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglProgramUniformMatrix4x3fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4x3fv(int program, int location, boolean transpose, FloatBuffer value) {
        GLES31.nglProgramUniformMatrix4x3fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglValidateProgramPipeline(int var0);

    public static void glValidateProgramPipeline(int pipeline) {
        GLES31.nglValidateProgramPipeline(pipeline);
    }

    public static native void nglGetProgramPipelineInfoLog(int var0, int var1, long var2, long var4);

    public static void glGetProgramPipelineInfoLog(int pipeline, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        GLES31.nglGetProgramPipelineInfoLog(pipeline, infoLog.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramPipelineInfoLog(int pipeline, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES31.nglGetProgramPipelineInfoLog(pipeline, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
            String string = MemoryUtil.memUTF8((ByteBuffer)infoLog, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)infoLog);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramPipelineInfoLog(int pipeline) {
        int bufSize = GLES31.glGetProgramPipelinei(pipeline, 35716);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES31.nglGetProgramPipelineInfoLog(pipeline, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
            String string = MemoryUtil.memUTF8((ByteBuffer)infoLog, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)infoLog);
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglBindImageTexture(int var0, int var1, int var2, boolean var3, int var4, int var5, int var6);

    public static void glBindImageTexture(int unit, int texture, int level, boolean layered, int layer, int access, int format) {
        GLES31.nglBindImageTexture(unit, texture, level, layered, layer, access, format);
    }

    public static native void nglGetBooleani_v(int var0, int var1, long var2);

    public static void glGetBooleani_v(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        GLES31.nglGetBooleani_v(target, index, MemoryUtil.memAddress((ByteBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean glGetBooleani(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer data = stack.calloc(1);
            GLES31.nglGetBooleani_v(target, index, MemoryUtil.memAddress((ByteBuffer)data));
            boolean bl = data.get(0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglMemoryBarrier(int var0);

    public static void glMemoryBarrier(int barriers) {
        GLES31.nglMemoryBarrier(barriers);
    }

    public static native void nglMemoryBarrierByRegion(int var0);

    public static void glMemoryBarrierByRegion(int barriers) {
        GLES31.nglMemoryBarrierByRegion(barriers);
    }

    public static native void nglTexStorage2DMultisample(int var0, int var1, int var2, int var3, int var4, boolean var5);

    public static void glTexStorage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        GLES31.nglTexStorage2DMultisample(target, samples, internalformat, width, height, fixedsamplelocations);
    }

    public static native void nglGetMultisamplefv(int var0, int var1, long var2);

    public static void glGetMultisamplefv(int pname, int index, FloatBuffer val) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)val, (int)1);
        }
        GLES31.nglGetMultisamplefv(pname, index, MemoryUtil.memAddress((FloatBuffer)val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetMultisamplef(int pname, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer val = stack.callocFloat(1);
            GLES31.nglGetMultisamplefv(pname, index, MemoryUtil.memAddress((FloatBuffer)val));
            float f = val.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglSampleMaski(int var0, int var1);

    public static void glSampleMaski(int maskNumber, int mask) {
        GLES31.nglSampleMaski(maskNumber, mask);
    }

    public static native void nglGetTexLevelParameteriv(int var0, int var1, int var2, long var3);

    public static void glGetTexLevelParameteriv(int target, int level, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES31.nglGetTexLevelParameteriv(target, level, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTexLevelParameteri(int target, int level, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES31.nglGetTexLevelParameteriv(target, level, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTexLevelParameterfv(int var0, int var1, int var2, long var3);

    public static void glGetTexLevelParameterfv(int target, int level, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES31.nglGetTexLevelParameterfv(target, level, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetTexLevelParameterf(int target, int level, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GLES31.nglGetTexLevelParameterfv(target, level, pname, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglBindVertexBuffer(int var0, int var1, long var2, int var4);

    public static void glBindVertexBuffer(int bindingindex, int buffer, long offset, int stride) {
        GLES31.nglBindVertexBuffer(bindingindex, buffer, offset, stride);
    }

    public static native void nglVertexAttribFormat(int var0, int var1, int var2, boolean var3, int var4);

    public static void glVertexAttribFormat(int attribindex, int size, int type, boolean normalized, int relativeoffset) {
        GLES31.nglVertexAttribFormat(attribindex, size, type, normalized, relativeoffset);
    }

    public static native void nglVertexAttribIFormat(int var0, int var1, int var2, int var3);

    public static void glVertexAttribIFormat(int attribindex, int size, int type, int relativeoffset) {
        GLES31.nglVertexAttribIFormat(attribindex, size, type, relativeoffset);
    }

    public static native void nglVertexAttribBinding(int var0, int var1);

    public static void glVertexAttribBinding(int attribindex, int bindingindex) {
        GLES31.nglVertexAttribBinding(attribindex, bindingindex);
    }

    public static native void nglVertexBindingDivisor(int var0, int var1);

    public static void glVertexBindingDivisor(int bindingindex, int divisor) {
        GLES31.nglVertexBindingDivisor(bindingindex, divisor);
    }

    public static void glDrawArraysIndirect(int mode, int[] indirect) {
        long __functionAddress = GLES.getICD().glDrawArraysIndirect;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])indirect, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)mode, (int[])indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, int[] indirect) {
        long __functionAddress = GLES.getICD().glDrawElementsIndirect;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])indirect, (int)5);
        }
        JNI.callPV((long)__functionAddress, (int)mode, (int)type, (int[])indirect);
    }

    public static void glGetFramebufferParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetFramebufferParameteriv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glGetProgramInterfaceiv(int program, int programInterface, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetProgramInterfaceiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)programInterface, (int)pname, (int[])params);
    }

    public static void glGetProgramResourceName(int program, int programInterface, int index, int[] length, ByteBuffer name) {
        long __functionAddress = GLES.getICD().glGetProgramResourceName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)program, (int)programInterface, (int)index, (int)name.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)name));
    }

    public static void glGetProgramResourceiv(int program, int programInterface, int index, int[] props, int[] length, int[] params) {
        long __functionAddress = GLES.getICD().glGetProgramResourceiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPPV((long)__functionAddress, (int)program, (int)programInterface, (int)index, (int)props.length, (int[])props, (int)params.length, (int[])length, (int[])params);
    }

    public static void glDeleteProgramPipelines(int[] pipelines) {
        long __functionAddress = GLES.getICD().glDeleteProgramPipelines;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)pipelines.length, (int[])pipelines);
    }

    public static void glGenProgramPipelines(int[] pipelines) {
        long __functionAddress = GLES.getICD().glGenProgramPipelines;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)pipelines.length, (int[])pipelines);
    }

    public static void glGetProgramPipelineiv(int pipeline, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetProgramPipelineiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pipeline, (int)pname, (int[])params);
    }

    public static void glProgramUniform1iv(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform1iv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)value.length, (int[])value);
    }

    public static void glProgramUniform2iv(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform2iv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 1), (int[])value);
    }

    public static void glProgramUniform3iv(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform3iv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 3), (int[])value);
    }

    public static void glProgramUniform4iv(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform4iv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 2), (int[])value);
    }

    public static void glProgramUniform1uiv(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform1uiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)value.length, (int[])value);
    }

    public static void glProgramUniform2uiv(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform2uiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 1), (int[])value);
    }

    public static void glProgramUniform3uiv(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform3uiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 3), (int[])value);
    }

    public static void glProgramUniform4uiv(int program, int location, int[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform4uiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 2), (int[])value);
    }

    public static void glProgramUniform1fv(int program, int location, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform1fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)value.length, (float[])value);
    }

    public static void glProgramUniform2fv(int program, int location, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform2fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 1), (float[])value);
    }

    public static void glProgramUniform3fv(int program, int location, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform3fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 3), (float[])value);
    }

    public static void glProgramUniform4fv(int program, int location, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniform4fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 2), (float[])value);
    }

    public static void glProgramUniformMatrix2fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix2fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 2), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix3fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix3fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 9), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix4fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix4fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 4), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix2x3fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix2x3fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 6), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix3x2fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix3x2fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 6), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix2x4fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix2x4fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 3), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix4x2fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix4x2fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length >> 3), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix3x4fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix3x4fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 12), (boolean)transpose, (float[])value);
    }

    public static void glProgramUniformMatrix4x3fv(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getICD().glProgramUniformMatrix4x3fv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)(value.length / 12), (boolean)transpose, (float[])value);
    }

    public static void glGetProgramPipelineInfoLog(int pipeline, int[] length, ByteBuffer infoLog) {
        long __functionAddress = GLES.getICD().glGetProgramPipelineInfoLog;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)pipeline, (int)infoLog.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)infoLog));
    }

    public static void glGetMultisamplefv(int pname, int index, float[] val) {
        long __functionAddress = GLES.getICD().glGetMultisamplefv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])val, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (int)index, (float[])val);
    }

    public static void glGetTexLevelParameteriv(int target, int level, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetTexLevelParameteriv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)pname, (int[])params);
    }

    public static void glGetTexLevelParameterfv(int target, int level, int pname, float[] params) {
        long __functionAddress = GLES.getICD().glGetTexLevelParameterfv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)level, (int)pname, (float[])params);
    }

    static {
        GLES.initialize();
    }
}

