/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLDebugMessageCallbackI;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GLES32 {
    public static final int GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB = 37761;
    public static final int GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB = 37762;
    public static final int GL_MULTIPLY = 37524;
    public static final int GL_SCREEN = 37525;
    public static final int GL_OVERLAY = 37526;
    public static final int GL_DARKEN = 37527;
    public static final int GL_LIGHTEN = 37528;
    public static final int GL_COLORDODGE = 37529;
    public static final int GL_COLORBURN = 37530;
    public static final int GL_HARDLIGHT = 37531;
    public static final int GL_SOFTLIGHT = 37532;
    public static final int GL_DIFFERENCE = 37534;
    public static final int GL_EXCLUSION = 37536;
    public static final int GL_HSL_HUE = 37549;
    public static final int GL_HSL_SATURATION = 37550;
    public static final int GL_HSL_COLOR = 37551;
    public static final int GL_HSL_LUMINOSITY = 37552;
    public static final int GL_DEBUG_OUTPUT = 37600;
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS = 33346;
    public static final int GL_CONTEXT_FLAG_DEBUG_BIT = 2;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 33347;
    public static final int GL_MAX_DEBUG_GROUP_STACK_DEPTH = 33388;
    public static final int GL_DEBUG_GROUP_STACK_DEPTH = 33389;
    public static final int GL_MAX_LABEL_LENGTH = 33512;
    public static final int GL_DEBUG_CALLBACK_FUNCTION = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM = 33349;
    public static final int GL_DEBUG_SOURCE_API = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER = 33355;
    public static final int GL_DEBUG_TYPE_ERROR = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE = 33360;
    public static final int GL_DEBUG_TYPE_OTHER = 33361;
    public static final int GL_DEBUG_TYPE_MARKER = 33384;
    public static final int GL_DEBUG_TYPE_PUSH_GROUP = 33385;
    public static final int GL_DEBUG_TYPE_POP_GROUP = 33386;
    public static final int GL_DEBUG_SEVERITY_HIGH = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW = 37192;
    public static final int GL_DEBUG_SEVERITY_NOTIFICATION = 33387;
    public static final int GL_STACK_UNDERFLOW = 1284;
    public static final int GL_STACK_OVERFLOW = 1283;
    public static final int GL_BUFFER = 33504;
    public static final int GL_SHADER = 33505;
    public static final int GL_PROGRAM = 33506;
    public static final int GL_QUERY = 33507;
    public static final int GL_PROGRAM_PIPELINE = 33508;
    public static final int GL_SAMPLER = 33510;
    public static final int GL_GEOMETRY_SHADER = 36313;
    public static final int GL_GEOMETRY_SHADER_BIT = 4;
    public static final int GL_GEOMETRY_LINKED_VERTICES_OUT = 35094;
    public static final int GL_GEOMETRY_LINKED_INPUT_TYPE = 35095;
    public static final int GL_GEOMETRY_LINKED_OUTPUT_TYPE = 35096;
    public static final int GL_GEOMETRY_SHADER_INVOCATIONS = 34943;
    public static final int GL_LAYER_PROVOKING_VERTEX = 33374;
    public static final int GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 36319;
    public static final int GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 35372;
    public static final int GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 35378;
    public static final int GL_MAX_GEOMETRY_INPUT_COMPONENTS = 37155;
    public static final int GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 37156;
    public static final int GL_MAX_GEOMETRY_OUTPUT_VERTICES = 36320;
    public static final int GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 36321;
    public static final int GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 36442;
    public static final int GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 35881;
    public static final int GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS = 37583;
    public static final int GL_MAX_GEOMETRY_ATOMIC_COUNTERS = 37589;
    public static final int GL_MAX_GEOMETRY_IMAGE_UNIFORMS = 37069;
    public static final int GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = 37079;
    public static final int GL_FIRST_VERTEX_CONVENTION = 36429;
    public static final int GL_LAST_VERTEX_CONVENTION = 36430;
    public static final int GL_UNDEFINED_VERTEX = 33376;
    public static final int GL_PRIMITIVES_GENERATED = 35975;
    public static final int GL_LINES_ADJACENCY = 10;
    public static final int GL_LINE_STRIP_ADJACENCY = 11;
    public static final int GL_TRIANGLES_ADJACENCY = 12;
    public static final int GL_TRIANGLE_STRIP_ADJACENCY = 13;
    public static final int GL_FRAMEBUFFER_DEFAULT_LAYERS = 37650;
    public static final int GL_MAX_FRAMEBUFFER_LAYERS = 37655;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 36264;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 36263;
    public static final int GL_REFERENCED_BY_GEOMETRY_SHADER = 37641;
    public static final int GL_PRIMITIVE_BOUNDING_BOX_ARB = 37566;
    public static final int GL_GUILTY_CONTEXT_RESET = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET = 33362;
    public static final int GL_NO_RESET_NOTIFICATION = 33377;
    public static final int GL_CONTEXT_LOST = 1287;
    public static final int GL_SAMPLE_SHADING = 35894;
    public static final int GL_MIN_SAMPLE_SHADING_VALUE = 35895;
    public static final int GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 36443;
    public static final int GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 36444;
    public static final int GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 36445;
    public static final int GL_PATCHES = 14;
    public static final int GL_PATCH_VERTICES = 36466;
    public static final int GL_TESS_CONTROL_OUTPUT_VERTICES = 36469;
    public static final int GL_TESS_GEN_MODE = 36470;
    public static final int GL_TESS_GEN_SPACING = 36471;
    public static final int GL_TESS_GEN_VERTEX_ORDER = 36472;
    public static final int GL_TESS_GEN_POINT_MODE = 36473;
    public static final int GL_ISOLINES = 36474;
    public static final int GL_QUADS = 7;
    public static final int GL_FRACTIONAL_ODD = 36475;
    public static final int GL_FRACTIONAL_EVEN = 36476;
    public static final int GL_MAX_PATCH_VERTICES = 36477;
    public static final int GL_MAX_TESS_GEN_LEVEL = 36478;
    public static final int GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 36479;
    public static final int GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 36480;
    public static final int GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 36481;
    public static final int GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 36482;
    public static final int GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 36483;
    public static final int GL_MAX_TESS_PATCH_COMPONENTS = 36484;
    public static final int GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 36485;
    public static final int GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 36486;
    public static final int GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 36489;
    public static final int GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 36490;
    public static final int GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 34924;
    public static final int GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 34925;
    public static final int GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 36382;
    public static final int GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 36383;
    public static final int GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS = 37581;
    public static final int GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS = 37582;
    public static final int GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS = 37587;
    public static final int GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = 37588;
    public static final int GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS = 37067;
    public static final int GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS = 37068;
    public static final int GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = 37080;
    public static final int GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = 37081;
    public static final int GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = 33313;
    public static final int GL_IS_PER_PATCH = 37607;
    public static final int GL_REFERENCED_BY_TESS_CONTROL_SHADER = 37639;
    public static final int GL_REFERENCED_BY_TESS_EVALUATION_SHADER = 37640;
    public static final int GL_TESS_EVALUATION_SHADER = 36487;
    public static final int GL_TESS_CONTROL_SHADER = 36488;
    public static final int GL_TESS_CONTROL_SHADER_BIT = 8;
    public static final int GL_TESS_EVALUATION_SHADER_BIT = 16;
    public static final int GL_TEXTURE_BORDER_COLOR = 4100;
    public static final int GL_CLAMP_TO_BORDER = 33069;
    public static final int GL_TEXTURE_BUFFER = 35882;
    public static final int GL_TEXTURE_BUFFER_BINDING = 35882;
    public static final int GL_SAMPLER_BUFFER = 36290;
    public static final int GL_INT_SAMPLER_BUFFER = 36304;
    public static final int GL_UNSIGNED_INT_SAMPLER_BUFFER = 36312;
    public static final int GL_IMAGE_BUFFER = 36945;
    public static final int GL_INT_IMAGE_BUFFER = 36956;
    public static final int GL_UNSIGNED_INT_IMAGE_BUFFER = 36967;
    public static final int GL_TEXTURE_BUFFER_DATA_STORE_BINDING = 35885;
    public static final int GL_TEXTURE_BUFFER_OFFSET = 37277;
    public static final int GL_TEXTURE_BUFFER_SIZE = 37278;
    public static final int GL_COMPRESSED_RGBA_ASTC_4x4 = 37808;
    public static final int GL_COMPRESSED_RGBA_ASTC_5x4 = 37809;
    public static final int GL_COMPRESSED_RGBA_ASTC_5x5 = 37810;
    public static final int GL_COMPRESSED_RGBA_ASTC_6x5 = 37811;
    public static final int GL_COMPRESSED_RGBA_ASTC_6x6 = 37812;
    public static final int GL_COMPRESSED_RGBA_ASTC_8x5 = 37813;
    public static final int GL_COMPRESSED_RGBA_ASTC_8x6 = 37814;
    public static final int GL_COMPRESSED_RGBA_ASTC_8x8 = 37815;
    public static final int GL_COMPRESSED_RGBA_ASTC_10x5 = 37816;
    public static final int GL_COMPRESSED_RGBA_ASTC_10x6 = 37817;
    public static final int GL_COMPRESSED_RGBA_ASTC_10x8 = 37818;
    public static final int GL_COMPRESSED_RGBA_ASTC_10x10 = 37819;
    public static final int GL_COMPRESSED_RGBA_ASTC_12x10 = 37820;
    public static final int GL_COMPRESSED_RGBA_ASTC_12x12 = 37821;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4 = 37840;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4 = 37841;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5 = 37842;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5 = 37843;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6 = 37844;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5 = 37845;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6 = 37846;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8 = 37847;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5 = 37848;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6 = 37849;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8 = 37850;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10 = 37851;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10 = 37852;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12 = 37853;
    public static final int GL_TEXTURE_CUBE_MAP_ARRAY = 36873;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = 36874;
    public static final int GL_SAMPLER_CUBE_MAP_ARRAY = 36876;
    public static final int GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 36877;
    public static final int GL_INT_SAMPLER_CUBE_MAP_ARRAY = 36878;
    public static final int GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 36879;
    public static final int GL_IMAGE_CUBE_MAP_ARRAY = 36948;
    public static final int GL_INT_IMAGE_CUBE_MAP_ARRAY = 36959;
    public static final int GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = 36970;
    public static final int GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 37122;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 37125;
    public static final int GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 37131;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37132;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37133;

    protected GLES32() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glBlendBarrier, caps.glCopyImageSubData, caps.glDebugMessageControl, caps.glDebugMessageInsert, caps.glDebugMessageCallback, caps.glGetDebugMessageLog, caps.glGetPointerv, caps.glPushDebugGroup, caps.glPopDebugGroup, caps.glObjectLabel, caps.glGetObjectLabel, caps.glObjectPtrLabel, caps.glGetObjectPtrLabel, caps.glEnablei, caps.glDisablei, caps.glBlendEquationi, caps.glBlendEquationSeparatei, caps.glBlendFunci, caps.glBlendFuncSeparatei, caps.glColorMaski, caps.glIsEnabledi, caps.glDrawElementsBaseVertex, caps.glDrawRangeElementsBaseVertex, caps.glDrawElementsInstancedBaseVertex, caps.glFramebufferTexture, caps.glPrimitiveBoundingBox, caps.glGetGraphicsResetStatus, caps.glReadnPixels, caps.glGetnUniformfv, caps.glGetnUniformiv, caps.glGetnUniformuiv, caps.glMinSampleShading, caps.glPatchParameteri, caps.glTexParameterIiv, caps.glTexParameterIuiv, caps.glGetTexParameterIiv, caps.glGetTexParameterIuiv, caps.glSamplerParameterIiv, caps.glSamplerParameterIuiv, caps.glGetSamplerParameterIiv, caps.glGetSamplerParameterIuiv, caps.glTexBuffer, caps.glTexBufferRange, caps.glTexStorage3DMultisample});
    }

    public static native void nglBlendBarrier();

    public static void glBlendBarrier() {
        GLES32.nglBlendBarrier();
    }

    public static native void nglCopyImageSubData(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    public static void glCopyImageSubData(int srcName, int srcTarget, int srcLevel, int srcX, int srcY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth) {
        GLES32.nglCopyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
    }

    public static native void nglDebugMessageControl(int var0, int var1, int var2, int var3, long var4, boolean var6);

    public static void glDebugMessageControl(int source, int type, int severity, IntBuffer ids, boolean enabled) {
        GLES32.nglDebugMessageControl(source, type, severity, ids.remaining(), MemoryUtil.memAddress((IntBuffer)ids), enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageControl(int source, int type, int severity, int id, boolean enabled) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            GLES32.nglDebugMessageControl(source, type, severity, 1, MemoryUtil.memAddress((IntBuffer)ids), enabled);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDebugMessageInsert(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glDebugMessageInsert(int source, int type, int id, int severity, ByteBuffer message) {
        GLES32.nglDebugMessageInsert(source, type, id, severity, message.remaining(), MemoryUtil.memAddress((ByteBuffer)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageInsert(int source, int type, int id, int severity, CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message, false);
            GLES32.nglDebugMessageInsert(source, type, id, severity, messageEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)messageEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDebugMessageCallback(long var0, long var2);

    public static void glDebugMessageCallback(GLDebugMessageCallbackI callback, long userParam) {
        GLES32.nglDebugMessageCallback(MemoryUtil.memAddressSafe((Pointer)callback), userParam);
    }

    public static native int nglGetDebugMessageLog(int var0, int var1, long var2, long var4, long var6, long var8, long var10, long var12);

    public static int glGetDebugMessageLog(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)sources, (int)count);
            Checks.checkSafe((Buffer)types, (int)count);
            Checks.checkSafe((Buffer)ids, (int)count);
            Checks.checkSafe((Buffer)severities, (int)count);
            Checks.checkSafe((Buffer)lengths, (int)count);
        }
        return GLES32.nglGetDebugMessageLog(count, Checks.remainingSafe((Buffer)messageLog), MemoryUtil.memAddressSafe((IntBuffer)sources), MemoryUtil.memAddressSafe((IntBuffer)types), MemoryUtil.memAddressSafe((IntBuffer)ids), MemoryUtil.memAddressSafe((IntBuffer)severities), MemoryUtil.memAddressSafe((IntBuffer)lengths), MemoryUtil.memAddressSafe((ByteBuffer)messageLog));
    }

    public static native void nglGetPointerv(int var0, long var1);

    public static void glGetPointerv(int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)params, (int)1);
        }
        GLES32.nglGetPointerv(pname, MemoryUtil.memAddress((CustomBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetPointer(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            GLES32.nglGetPointerv(pname, MemoryUtil.memAddress((CustomBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglPushDebugGroup(int var0, int var1, int var2, long var3);

    public static void glPushDebugGroup(int source, int id, ByteBuffer message) {
        GLES32.nglPushDebugGroup(source, id, message.remaining(), MemoryUtil.memAddress((ByteBuffer)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glPushDebugGroup(int source, int id, CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message, false);
            GLES32.nglPushDebugGroup(source, id, messageEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)messageEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglPopDebugGroup();

    public static void glPopDebugGroup() {
        GLES32.nglPopDebugGroup();
    }

    public static native void nglObjectLabel(int var0, int var1, int var2, long var3);

    public static void glObjectLabel(int identifier, int name, ByteBuffer label) {
        GLES32.nglObjectLabel(identifier, name, label.remaining(), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glObjectLabel(int identifier, int name, CharSequence label) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            GLES32.nglObjectLabel(identifier, name, labelEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetObjectLabel(int var0, int var1, int var2, long var3, long var5);

    public static void glGetObjectLabel(int identifier, int name, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        GLES32.nglGetObjectLabel(identifier, name, label.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectLabel(int identifier, int name, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            GLES32.nglGetObjectLabel(identifier, name, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
            String string = MemoryUtil.memUTF8((ByteBuffer)label, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectLabel(int identifier, int name) {
        int bufSize = GLES20.glGetInteger(33512);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            GLES32.nglGetObjectLabel(identifier, name, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
            String string = MemoryUtil.memUTF8((ByteBuffer)label, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglObjectPtrLabel(long var0, int var2, long var3);

    public static void glObjectPtrLabel(long ptr, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        GLES32.nglObjectPtrLabel(ptr, label.remaining(), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glObjectPtrLabel(long ptr, CharSequence label) {
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            GLES32.nglObjectPtrLabel(ptr, labelEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetObjectPtrLabel(long var0, int var2, long var3, long var5);

    public static void glGetObjectPtrLabel(long ptr, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
            Checks.checkSafe((Buffer)length, (int)1);
        }
        GLES32.nglGetObjectPtrLabel(ptr, label.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectPtrLabel(long ptr, int bufSize) {
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            GLES32.nglGetObjectPtrLabel(ptr, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
            String string = MemoryUtil.memUTF8((ByteBuffer)label, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectPtrLabel(long ptr) {
        int bufSize = GLES20.glGetInteger(33512);
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            GLES32.nglGetObjectPtrLabel(ptr, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
            String string = MemoryUtil.memUTF8((ByteBuffer)label, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglEnablei(int var0, int var1);

    public static void glEnablei(int target, int index) {
        GLES32.nglEnablei(target, index);
    }

    public static native void nglDisablei(int var0, int var1);

    public static void glDisablei(int target, int index) {
        GLES32.nglDisablei(target, index);
    }

    public static native void nglBlendEquationi(int var0, int var1);

    public static void glBlendEquationi(int buf, int mode) {
        GLES32.nglBlendEquationi(buf, mode);
    }

    public static native void nglBlendEquationSeparatei(int var0, int var1, int var2);

    public static void glBlendEquationSeparatei(int buf, int modeRGB, int modeAlpha) {
        GLES32.nglBlendEquationSeparatei(buf, modeRGB, modeAlpha);
    }

    public static native void nglBlendFunci(int var0, int var1, int var2);

    public static void glBlendFunci(int buf, int src, int dst) {
        GLES32.nglBlendFunci(buf, src, dst);
    }

    public static native void nglBlendFuncSeparatei(int var0, int var1, int var2, int var3, int var4);

    public static void glBlendFuncSeparatei(int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        GLES32.nglBlendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    public static native void nglColorMaski(int var0, boolean var1, boolean var2, boolean var3, boolean var4);

    public static void glColorMaski(int index, boolean r, boolean g, boolean b, boolean a) {
        GLES32.nglColorMaski(index, r, g, b, a);
    }

    public static native boolean nglIsEnabledi(int var0, int var1);

    public static boolean glIsEnabledi(int target, int index) {
        return GLES32.nglIsEnabledi(target, index);
    }

    public static native void nglDrawElementsBaseVertex(int var0, int var1, int var2, long var3, int var5);

    public static void glDrawElementsBaseVertex(int mode, int count, int type, long indices, int basevertex) {
        GLES32.nglDrawElementsBaseVertex(mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, int type, ByteBuffer indices, int basevertex) {
        GLES32.nglDrawElementsBaseVertex(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress((ByteBuffer)indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, ByteBuffer indices, int basevertex) {
        GLES32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, ShortBuffer indices, int basevertex) {
        GLES32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, IntBuffer indices, int basevertex) {
        GLES32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)indices), basevertex);
    }

    public static native void nglDrawRangeElementsBaseVertex(int var0, int var1, int var2, int var3, int var4, long var5, int var7);

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        GLES32.nglDrawRangeElementsBaseVertex(mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int type, ByteBuffer indices, int basevertex) {
        GLES32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress((ByteBuffer)indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ByteBuffer indices, int basevertex) {
        GLES32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ShortBuffer indices, int basevertex) {
        GLES32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, IntBuffer indices, int basevertex) {
        GLES32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)indices), basevertex);
    }

    public static native void nglDrawElementsInstancedBaseVertex(int var0, int var1, int var2, long var3, int var5, int var6);

    public static void glDrawElementsInstancedBaseVertex(int mode, int count, int type, long indices, int instancecount, int basevertex) {
        GLES32.nglDrawElementsInstancedBaseVertex(mode, count, type, indices, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int type, ByteBuffer indices, int instancecount, int basevertex) {
        GLES32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress((ByteBuffer)indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ByteBuffer indices, int instancecount, int basevertex) {
        GLES32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ShortBuffer indices, int instancecount, int basevertex) {
        GLES32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, IntBuffer indices, int instancecount, int basevertex) {
        GLES32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)indices), instancecount, basevertex);
    }

    public static native void nglFramebufferTexture(int var0, int var1, int var2, int var3);

    public static void glFramebufferTexture(int target, int attachment, int texture, int level) {
        GLES32.nglFramebufferTexture(target, attachment, texture, level);
    }

    public static native void nglPrimitiveBoundingBox(float var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7);

    public static void glPrimitiveBoundingBox(float minX, float minY, float minZ, float minW, float maxX, float maxY, float maxZ, float maxW) {
        GLES32.nglPrimitiveBoundingBox(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
    }

    public static native int nglGetGraphicsResetStatus();

    public static int glGetGraphicsResetStatus() {
        return GLES32.nglGetGraphicsResetStatus();
    }

    public static native void nglReadnPixels(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixels) {
        GLES32.nglReadnPixels(x, y, width, height, format, type, bufSize, pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        GLES32.nglReadnPixels(x, y, width, height, format, type, pixels.remaining(), MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        GLES32.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        GLES32.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        GLES32.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static native void nglGetnUniformfv(int var0, int var1, int var2, long var3);

    public static void glGetnUniformfv(int program, int location, FloatBuffer params) {
        GLES32.nglGetnUniformfv(program, location, params.remaining(), MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformf(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GLES32.nglGetnUniformfv(program, location, 1, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformiv(int var0, int var1, int var2, long var3);

    public static void glGetnUniformiv(int program, int location, FloatBuffer params) {
        GLES32.nglGetnUniformiv(program, location, params.remaining(), MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformi(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GLES32.nglGetnUniformiv(program, location, 1, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformuiv(int var0, int var1, int var2, long var3);

    public static void glGetnUniformuiv(int program, int location, FloatBuffer params) {
        GLES32.nglGetnUniformuiv(program, location, params.remaining(), MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformui(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GLES32.nglGetnUniformuiv(program, location, 1, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglMinSampleShading(float var0);

    public static void glMinSampleShading(float value) {
        GLES32.nglMinSampleShading(value);
    }

    public static native void nglPatchParameteri(int var0, int var1);

    public static void glPatchParameteri(int pname, int value) {
        GLES32.nglPatchParameteri(pname, value);
    }

    public static native void nglTexParameterIiv(int var0, int var1, long var2);

    public static void glTexParameterIiv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES32.nglTexParameterIiv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glTexParameterIi(int target, int pname, int param) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.ints(param);
            GLES32.nglTexParameterIiv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglTexParameterIuiv(int var0, int var1, long var2);

    public static void glTexParameterIuiv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES32.nglTexParameterIuiv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glTexParameterIui(int target, int pname, int param) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.ints(param);
            GLES32.nglTexParameterIuiv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTexParameterIiv(int var0, int var1, long var2);

    public static void glGetTexParameterIiv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES32.nglGetTexParameterIiv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTexParameterIi(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES32.nglGetTexParameterIiv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTexParameterIuiv(int var0, int var1, long var2);

    public static void glGetTexParameterIuiv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES32.nglGetTexParameterIuiv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTexParameterIui(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES32.nglGetTexParameterIuiv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglSamplerParameterIiv(int var0, int var1, long var2);

    public static void glSamplerParameterIiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES32.nglSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glSamplerParameterIi(int sampler, int pname, int param) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.ints(param);
            GLES32.nglSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress((IntBuffer)params));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglSamplerParameterIuiv(int var0, int var1, long var2);

    public static void glSamplerParameterIuiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES32.nglSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glSamplerParameterIui(int sampler, int pname, int param) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.ints(param);
            GLES32.nglSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress((IntBuffer)params));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSamplerParameterIiv(int var0, int var1, long var2);

    public static void glGetSamplerParameterIiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES32.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSamplerParameterIi(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES32.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSamplerParameterIuiv(int var0, int var1, long var2);

    public static void glGetSamplerParameterIuiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES32.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSamplerParameterIui(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES32.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglTexBuffer(int var0, int var1, int var2);

    public static void glTexBuffer(int target, int internalformat, int buffer) {
        GLES32.nglTexBuffer(target, internalformat, buffer);
    }

    public static native void nglTexBufferRange(int var0, int var1, int var2, long var3, long var5);

    public static void glTexBufferRange(int target, int internalformat, int buffer, long offset, long size) {
        GLES32.nglTexBufferRange(target, internalformat, buffer, offset, size);
    }

    public static native void nglTexStorage3DMultisample(int var0, int var1, int var2, int var3, int var4, int var5, boolean var6);

    public static void glTexStorage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations) {
        GLES32.nglTexStorage3DMultisample(target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }

    public static void glDebugMessageControl(int source, int type, int severity, int[] ids, boolean enabled) {
        long __functionAddress = GLES.getICD().glDebugMessageControl;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)source, (int)type, (int)severity, (int)ids.length, (int[])ids, (boolean)enabled);
    }

    public static int glGetDebugMessageLog(int count, int[] sources, int[] types, int[] ids, int[] severities, int[] lengths, ByteBuffer messageLog) {
        long __functionAddress = GLES.getICD().glGetDebugMessageLog;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])sources, (int)count);
            Checks.checkSafe((int[])types, (int)count);
            Checks.checkSafe((int[])ids, (int)count);
            Checks.checkSafe((int[])severities, (int)count);
            Checks.checkSafe((int[])lengths, (int)count);
        }
        return JNI.callPPPPPPI((long)__functionAddress, (int)count, (int)Checks.remainingSafe((Buffer)messageLog), (int[])sources, (int[])types, (int[])ids, (int[])severities, (int[])lengths, (long)MemoryUtil.memAddressSafe((ByteBuffer)messageLog));
    }

    public static void glGetObjectLabel(int identifier, int name, int[] length, ByteBuffer label) {
        long __functionAddress = GLES.getICD().glGetObjectLabel;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)identifier, (int)name, (int)label.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)label));
    }

    public static void glGetObjectPtrLabel(long ptr, int[] length, ByteBuffer label) {
        long __functionAddress = GLES.getICD().glGetObjectPtrLabel;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)ptr);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPPV((long)__functionAddress, (long)ptr, (int)label.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)label));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GLES.getICD().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(pixels.length << 1), (short[])pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GLES.getICD().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(pixels.length << 2), (int[])pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GLES.getICD().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(pixels.length << 2), (float[])pixels);
    }

    public static void glGetnUniformfv(int program, int location, float[] params) {
        long __functionAddress = GLES.getICD().glGetnUniformfv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (float[])params);
    }

    public static void glGetnUniformiv(int program, int location, float[] params) {
        long __functionAddress = GLES.getICD().glGetnUniformiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (float[])params);
    }

    public static void glGetnUniformuiv(int program, int location, float[] params) {
        long __functionAddress = GLES.getICD().glGetnUniformuiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (float[])params);
    }

    public static void glTexParameterIiv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glTexParameterIiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glTexParameterIuiv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glTexParameterIuiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glGetTexParameterIiv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetTexParameterIiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glGetTexParameterIuiv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetTexParameterIuiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (int[])params);
    }

    public static void glSamplerParameterIiv(int sampler, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)sampler, (int)pname, (int[])params);
    }

    public static void glSamplerParameterIuiv(int sampler, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)sampler, (int)pname, (int[])params);
    }

    public static void glGetSamplerParameterIiv(int sampler, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)sampler, (int)pname, (int[])params);
    }

    public static void glGetSamplerParameterIuiv(int sampler, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)sampler, (int)pname, (int[])params);
    }

    static {
        GLES.initialize();
    }
}

