/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class INTELPerformanceQuery {
    public static final int GL_PERFQUERY_SINGLE_CONTEXT_INTEL = 0;
    public static final int GL_PERFQUERY_GLOBAL_CONTEXT_INTEL = 1;
    public static final int GL_PERFQUERY_WAIT_INTEL = 33787;
    public static final int GL_PERFQUERY_FLUSH_INTEL = 33786;
    public static final int GL_PERFQUERY_DONOT_FLUSH_INTEL = 33785;
    public static final int GL_PERFQUERY_COUNTER_EVENT_INTEL = 38128;
    public static final int GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL = 38129;
    public static final int GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL = 38130;
    public static final int GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL = 38131;
    public static final int GL_PERFQUERY_COUNTER_RAW_INTEL = 38132;
    public static final int GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL = 38133;
    public static final int GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL = 38136;
    public static final int GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL = 38137;
    public static final int GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL = 38138;
    public static final int GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL = 38139;
    public static final int GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL = 38140;
    public static final int GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL = 38141;
    public static final int GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL = 38142;
    public static final int GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL = 38143;
    public static final int GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL = 38144;

    protected INTELPerformanceQuery() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glBeginPerfQueryINTEL, caps.glCreatePerfQueryINTEL, caps.glDeletePerfQueryINTEL, caps.glEndPerfQueryINTEL, caps.glGetFirstPerfQueryIdINTEL, caps.glGetNextPerfQueryIdINTEL, caps.glGetPerfCounterInfoINTEL, caps.glGetPerfQueryDataINTEL, caps.glGetPerfQueryIdByNameINTEL, caps.glGetPerfQueryInfoINTEL});
    }

    public static native void nglBeginPerfQueryINTEL(int var0);

    public static void glBeginPerfQueryINTEL(int queryHandle) {
        INTELPerformanceQuery.nglBeginPerfQueryINTEL(queryHandle);
    }

    public static native void nglCreatePerfQueryINTEL(int var0, long var1);

    public static void glCreatePerfQueryINTEL(int queryId, IntBuffer queryHandle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)queryHandle, (int)1);
        }
        INTELPerformanceQuery.nglCreatePerfQueryINTEL(queryId, MemoryUtil.memAddress((IntBuffer)queryHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreatePerfQueryINTEL(int queryId) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer queryHandle = stack.callocInt(1);
            INTELPerformanceQuery.nglCreatePerfQueryINTEL(queryId, MemoryUtil.memAddress((IntBuffer)queryHandle));
            int n = queryHandle.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeletePerfQueryINTEL(int var0);

    public static void glDeletePerfQueryINTEL(int queryHandle) {
        INTELPerformanceQuery.nglDeletePerfQueryINTEL(queryHandle);
    }

    public static native void nglEndPerfQueryINTEL(int var0);

    public static void glEndPerfQueryINTEL(int queryHandle) {
        INTELPerformanceQuery.nglEndPerfQueryINTEL(queryHandle);
    }

    public static native void nglGetFirstPerfQueryIdINTEL(long var0);

    public static void glGetFirstPerfQueryIdINTEL(IntBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)queryId, (int)1);
        }
        INTELPerformanceQuery.nglGetFirstPerfQueryIdINTEL(MemoryUtil.memAddress((IntBuffer)queryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFirstPerfQueryIdINTEL() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer queryId = stack.callocInt(1);
            INTELPerformanceQuery.nglGetFirstPerfQueryIdINTEL(MemoryUtil.memAddress((IntBuffer)queryId));
            int n = queryId.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetNextPerfQueryIdINTEL(int var0, long var1);

    public static void glGetNextPerfQueryIdINTEL(int queryId, IntBuffer nextQueryId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)nextQueryId, (int)1);
        }
        INTELPerformanceQuery.nglGetNextPerfQueryIdINTEL(queryId, MemoryUtil.memAddress((IntBuffer)nextQueryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetNextPerfQueryIdINTEL(int queryId) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer nextQueryId = stack.callocInt(1);
            INTELPerformanceQuery.nglGetNextPerfQueryIdINTEL(queryId, MemoryUtil.memAddress((IntBuffer)nextQueryId));
            int n = nextQueryId.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetPerfCounterInfoINTEL(int var0, int var1, int var2, long var3, int var5, long var6, long var8, long var10, long var12, long var14, long var16);

    public static void glGetPerfCounterInfoINTEL(int queryId, int counterId, ByteBuffer counterName, ByteBuffer counterDesc, IntBuffer counterOffset, IntBuffer counterDataSize, IntBuffer counterTypeEnum, IntBuffer counterDataTypeEnum, LongBuffer rawCounterMaxValue) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)counterOffset, (int)1);
            Checks.check((Buffer)counterDataSize, (int)1);
            Checks.check((Buffer)counterTypeEnum, (int)1);
            Checks.check((Buffer)counterDataTypeEnum, (int)1);
            Checks.check((Buffer)rawCounterMaxValue, (int)1);
        }
        INTELPerformanceQuery.nglGetPerfCounterInfoINTEL(queryId, counterId, counterName.remaining(), MemoryUtil.memAddress((ByteBuffer)counterName), counterDesc.remaining(), MemoryUtil.memAddress((ByteBuffer)counterDesc), MemoryUtil.memAddress((IntBuffer)counterOffset), MemoryUtil.memAddress((IntBuffer)counterDataSize), MemoryUtil.memAddress((IntBuffer)counterTypeEnum), MemoryUtil.memAddress((IntBuffer)counterDataTypeEnum), MemoryUtil.memAddress((LongBuffer)rawCounterMaxValue));
    }

    public static native void nglGetPerfQueryDataINTEL(int var0, int var1, int var2, long var3, long var5);

    public static void glGetPerfQueryDataINTEL(int queryHandle, int flags, ByteBuffer data, IntBuffer bytesWritten) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)bytesWritten, (int)1);
        }
        INTELPerformanceQuery.nglGetPerfQueryDataINTEL(queryHandle, flags, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data), MemoryUtil.memAddress((IntBuffer)bytesWritten));
    }

    public static native void nglGetPerfQueryIdByNameINTEL(long var0, long var2);

    public static void glGetPerfQueryIdByNameINTEL(ByteBuffer queryName, IntBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)queryName);
            Checks.check((Buffer)queryId, (int)1);
        }
        INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(MemoryUtil.memAddress((ByteBuffer)queryName), MemoryUtil.memAddress((IntBuffer)queryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetPerfQueryIdByNameINTEL(CharSequence queryName, IntBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)queryId, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer queryNameEncoded = stack.ASCII(queryName);
            INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(MemoryUtil.memAddress((ByteBuffer)queryNameEncoded), MemoryUtil.memAddress((IntBuffer)queryId));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetPerfQueryIdByNameINTEL(CharSequence queryName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer queryNameEncoded = stack.ASCII(queryName);
            IntBuffer queryId = stack.callocInt(1);
            INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(MemoryUtil.memAddress((ByteBuffer)queryNameEncoded), MemoryUtil.memAddress((IntBuffer)queryId));
            int n = queryId.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetPerfQueryInfoINTEL(int var0, int var1, long var2, long var4, long var6, long var8, long var10);

    public static void glGetPerfQueryInfoINTEL(int queryId, ByteBuffer queryName, IntBuffer dataSize, IntBuffer noCounters, IntBuffer noInstances, IntBuffer capsMask) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dataSize, (int)1);
            Checks.check((Buffer)noCounters, (int)1);
            Checks.check((Buffer)noInstances, (int)1);
            Checks.check((Buffer)capsMask, (int)1);
        }
        INTELPerformanceQuery.nglGetPerfQueryInfoINTEL(queryId, queryName.remaining(), MemoryUtil.memAddress((ByteBuffer)queryName), MemoryUtil.memAddress((IntBuffer)dataSize), MemoryUtil.memAddress((IntBuffer)noCounters), MemoryUtil.memAddress((IntBuffer)noInstances), MemoryUtil.memAddress((IntBuffer)capsMask));
    }

    public static void glCreatePerfQueryINTEL(int queryId, int[] queryHandle) {
        long __functionAddress = GLES.getICD().glCreatePerfQueryINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])queryHandle, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)queryId, (int[])queryHandle);
    }

    public static void glGetFirstPerfQueryIdINTEL(int[] queryId) {
        long __functionAddress = GLES.getICD().glGetFirstPerfQueryIdINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])queryId, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int[])queryId);
    }

    public static void glGetNextPerfQueryIdINTEL(int queryId, int[] nextQueryId) {
        long __functionAddress = GLES.getICD().glGetNextPerfQueryIdINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])nextQueryId, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)queryId, (int[])nextQueryId);
    }

    public static void glGetPerfCounterInfoINTEL(int queryId, int counterId, ByteBuffer counterName, ByteBuffer counterDesc, int[] counterOffset, int[] counterDataSize, int[] counterTypeEnum, int[] counterDataTypeEnum, long[] rawCounterMaxValue) {
        long __functionAddress = GLES.getICD().glGetPerfCounterInfoINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])counterOffset, (int)1);
            Checks.check((int[])counterDataSize, (int)1);
            Checks.check((int[])counterTypeEnum, (int)1);
            Checks.check((int[])counterDataTypeEnum, (int)1);
            Checks.check((long[])rawCounterMaxValue, (int)1);
        }
        JNI.callPPPPPPPV((long)__functionAddress, (int)queryId, (int)counterId, (int)counterName.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)counterName), (int)counterDesc.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)counterDesc), (int[])counterOffset, (int[])counterDataSize, (int[])counterTypeEnum, (int[])counterDataTypeEnum, (long[])rawCounterMaxValue);
    }

    public static void glGetPerfQueryDataINTEL(int queryHandle, int flags, ByteBuffer data, int[] bytesWritten) {
        long __functionAddress = GLES.getICD().glGetPerfQueryDataINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])bytesWritten, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)queryHandle, (int)flags, (int)data.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)data), (int[])bytesWritten);
    }

    public static void glGetPerfQueryIdByNameINTEL(ByteBuffer queryName, int[] queryId) {
        long __functionAddress = GLES.getICD().glGetPerfQueryIdByNameINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkNT1((ByteBuffer)queryName);
            Checks.check((int[])queryId, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (long)MemoryUtil.memAddress((ByteBuffer)queryName), (int[])queryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetPerfQueryIdByNameINTEL(CharSequence queryName, int[] queryId) {
        long __functionAddress = GLES.getICD().glGetPerfQueryIdByNameINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])queryId, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer queryNameEncoded = stack.ASCII(queryName);
            JNI.callPPV((long)__functionAddress, (long)MemoryUtil.memAddress((ByteBuffer)queryNameEncoded), (int[])queryId);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetPerfQueryInfoINTEL(int queryId, ByteBuffer queryName, int[] dataSize, int[] noCounters, int[] noInstances, int[] capsMask) {
        long __functionAddress = GLES.getICD().glGetPerfQueryInfoINTEL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])dataSize, (int)1);
            Checks.check((int[])noCounters, (int)1);
            Checks.check((int[])noInstances, (int)1);
            Checks.check((int[])capsMask, (int)1);
        }
        JNI.callPPPPPV((long)__functionAddress, (int)queryId, (int)queryName.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)queryName), (int[])dataSize, (int[])noCounters, (int[])noInstances, (int[])capsMask);
    }

    static {
        GLES.initialize();
    }
}

