/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLDebugMessageKHRCallbackI;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class KHRDebug {
    public static final int GL_DEBUG_OUTPUT_KHR = 37600;
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR = 33346;
    public static final int GL_CONTEXT_FLAG_DEBUG_BIT_KHR = 2;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_KHR = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_KHR = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_KHR = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR = 33347;
    public static final int GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR = 33388;
    public static final int GL_DEBUG_GROUP_STACK_DEPTH_KHR = 33389;
    public static final int GL_MAX_LABEL_LENGTH_KHR = 33512;
    public static final int GL_DEBUG_CALLBACK_FUNCTION_KHR = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM_KHR = 33349;
    public static final int GL_DEBUG_SOURCE_API_KHR = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER_KHR = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY_KHR = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION_KHR = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER_KHR = 33355;
    public static final int GL_DEBUG_TYPE_ERROR_KHR = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY_KHR = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE_KHR = 33360;
    public static final int GL_DEBUG_TYPE_OTHER_KHR = 33361;
    public static final int GL_DEBUG_TYPE_MARKER_KHR = 33384;
    public static final int GL_DEBUG_TYPE_PUSH_GROUP_KHR = 33385;
    public static final int GL_DEBUG_TYPE_POP_GROUP_KHR = 33386;
    public static final int GL_DEBUG_SEVERITY_HIGH_KHR = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_KHR = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_KHR = 37192;
    public static final int GL_DEBUG_SEVERITY_NOTIFICATION_KHR = 33387;
    public static final int GL_STACK_UNDERFLOW_KHR = 1284;
    public static final int GL_STACK_OVERFLOW_KHR = 1283;
    public static final int GL_BUFFER_KHR = 33504;
    public static final int GL_SHADER_KHR = 33505;
    public static final int GL_PROGRAM_KHR = 33506;
    public static final int GL_QUERY_KHR = 33507;
    public static final int GL_PROGRAM_PIPELINE_KHR = 33508;
    public static final int GL_SAMPLER_KHR = 33510;

    protected KHRDebug() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glDebugMessageControlKHR, caps.glDebugMessageInsertKHR, caps.glDebugMessageCallbackKHR, caps.glGetDebugMessageLogKHR, caps.glGetPointervKHR, caps.glPushDebugGroupKHR, caps.glPopDebugGroupKHR, caps.glObjectLabelKHR, caps.glGetObjectLabelKHR, caps.glObjectPtrLabelKHR, caps.glGetObjectPtrLabelKHR});
    }

    public static native void nglDebugMessageControlKHR(int var0, int var1, int var2, int var3, long var4, boolean var6);

    public static void glDebugMessageControlKHR(int source, int type, int severity, IntBuffer ids, boolean enabled) {
        KHRDebug.nglDebugMessageControlKHR(source, type, severity, Checks.remainingSafe((Buffer)ids), MemoryUtil.memAddressSafe((IntBuffer)ids), enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageControlKHR(int source, int type, int severity, int id, boolean enabled) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            KHRDebug.nglDebugMessageControlKHR(source, type, severity, 1, MemoryUtil.memAddress((IntBuffer)ids), enabled);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDebugMessageInsertKHR(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glDebugMessageInsertKHR(int source, int type, int id, int severity, ByteBuffer message) {
        KHRDebug.nglDebugMessageInsertKHR(source, type, id, severity, message.remaining(), MemoryUtil.memAddress((ByteBuffer)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageInsertKHR(int source, int type, int id, int severity, CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message, false);
            KHRDebug.nglDebugMessageInsertKHR(source, type, id, severity, messageEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)messageEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDebugMessageCallbackKHR(long var0, long var2);

    public static void glDebugMessageCallbackKHR(GLDebugMessageKHRCallbackI callback, long userParam) {
        KHRDebug.nglDebugMessageCallbackKHR(MemoryUtil.memAddressSafe((Pointer)callback), userParam);
    }

    public static native int nglGetDebugMessageLogKHR(int var0, int var1, long var2, long var4, long var6, long var8, long var10, long var12);

    public static int glGetDebugMessageLogKHR(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)sources, (int)count);
            Checks.checkSafe((Buffer)types, (int)count);
            Checks.checkSafe((Buffer)ids, (int)count);
            Checks.checkSafe((Buffer)severities, (int)count);
            Checks.checkSafe((Buffer)lengths, (int)count);
        }
        return KHRDebug.nglGetDebugMessageLogKHR(count, Checks.remainingSafe((Buffer)messageLog), MemoryUtil.memAddressSafe((IntBuffer)sources), MemoryUtil.memAddressSafe((IntBuffer)types), MemoryUtil.memAddressSafe((IntBuffer)ids), MemoryUtil.memAddressSafe((IntBuffer)severities), MemoryUtil.memAddressSafe((IntBuffer)lengths), MemoryUtil.memAddressSafe((ByteBuffer)messageLog));
    }

    public static native void nglGetPointervKHR(int var0, long var1);

    public static void glGetPointervKHR(int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)params, (int)1);
        }
        KHRDebug.nglGetPointervKHR(pname, MemoryUtil.memAddress((CustomBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetPointerKHR(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            KHRDebug.nglGetPointervKHR(pname, MemoryUtil.memAddress((CustomBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglPushDebugGroupKHR(int var0, int var1, int var2, long var3);

    public static void glPushDebugGroupKHR(int source, int id, ByteBuffer message) {
        KHRDebug.nglPushDebugGroupKHR(source, id, message.remaining(), MemoryUtil.memAddress((ByteBuffer)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glPushDebugGroupKHR(int source, int id, CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message, false);
            KHRDebug.nglPushDebugGroupKHR(source, id, messageEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)messageEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglPopDebugGroupKHR();

    public static void glPopDebugGroupKHR() {
        KHRDebug.nglPopDebugGroupKHR();
    }

    public static native void nglObjectLabelKHR(int var0, int var1, int var2, long var3);

    public static void glObjectLabelKHR(int identifier, int name, ByteBuffer label) {
        KHRDebug.nglObjectLabelKHR(identifier, name, label.remaining(), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glObjectLabelKHR(int identifier, int name, CharSequence label) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            KHRDebug.nglObjectLabelKHR(identifier, name, labelEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetObjectLabelKHR(int var0, int var1, int var2, long var3, long var5);

    public static void glGetObjectLabelKHR(int identifier, int name, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        KHRDebug.nglGetObjectLabelKHR(identifier, name, label.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectLabelKHR(int identifier, int name, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectLabelKHR(identifier, name, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
            String string = MemoryUtil.memUTF8((ByteBuffer)label, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectLabelKHR(int identifier, int name) {
        int bufSize = GLES20.glGetInteger(33512);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectLabelKHR(identifier, name, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
            String string = MemoryUtil.memUTF8((ByteBuffer)label, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglObjectPtrLabelKHR(long var0, int var2, long var3);

    public static void glObjectPtrLabelKHR(long ptr, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        KHRDebug.nglObjectPtrLabelKHR(ptr, label.remaining(), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glObjectPtrLabelKHR(long ptr, CharSequence label) {
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            KHRDebug.nglObjectPtrLabelKHR(ptr, labelEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetObjectPtrLabelKHR(long var0, int var2, long var3, long var5);

    public static void glGetObjectPtrLabelKHR(long ptr, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
            Checks.checkSafe((Buffer)length, (int)1);
        }
        KHRDebug.nglGetObjectPtrLabelKHR(ptr, label.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectPtrLabelKHR(long ptr, int bufSize) {
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectPtrLabelKHR(ptr, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
            String string = MemoryUtil.memUTF8((ByteBuffer)label, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectPtrLabelKHR(long ptr) {
        int bufSize = GLES20.glGetInteger(33512);
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectPtrLabelKHR(ptr, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
            String string = MemoryUtil.memUTF8((ByteBuffer)label, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDebugMessageControlKHR(int source, int type, int severity, int[] ids, boolean enabled) {
        long __functionAddress = GLES.getICD().glDebugMessageControlKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)source, (int)type, (int)severity, (int)Checks.lengthSafe((int[])ids), (int[])ids, (boolean)enabled);
    }

    public static int glGetDebugMessageLogKHR(int count, int[] sources, int[] types, int[] ids, int[] severities, int[] lengths, ByteBuffer messageLog) {
        long __functionAddress = GLES.getICD().glGetDebugMessageLogKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])sources, (int)count);
            Checks.checkSafe((int[])types, (int)count);
            Checks.checkSafe((int[])ids, (int)count);
            Checks.checkSafe((int[])severities, (int)count);
            Checks.checkSafe((int[])lengths, (int)count);
        }
        return JNI.callPPPPPPI((long)__functionAddress, (int)count, (int)Checks.remainingSafe((Buffer)messageLog), (int[])sources, (int[])types, (int[])ids, (int[])severities, (int[])lengths, (long)MemoryUtil.memAddressSafe((ByteBuffer)messageLog));
    }

    public static void glGetObjectLabelKHR(int identifier, int name, int[] length, ByteBuffer label) {
        long __functionAddress = GLES.getICD().glGetObjectLabelKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)identifier, (int)name, (int)label.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)label));
    }

    public static void glGetObjectPtrLabelKHR(long ptr, int[] length, ByteBuffer label) {
        long __functionAddress = GLES.getICD().glGetObjectPtrLabelKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)ptr);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPPV((long)__functionAddress, (long)ptr, (int)label.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)label));
    }

    static {
        GLES.initialize();
    }
}

