/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVFence {
    public static final int GL_ALL_COMPLETED_NV = 34034;
    public static final int GL_FENCE_STATUS_NV = 34035;
    public static final int GL_FENCE_CONDITION_NV = 34036;

    protected NVFence() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glDeleteFencesNV, caps.glGenFencesNV, caps.glIsFenceNV, caps.glTestFenceNV, caps.glGetFenceivNV, caps.glFinishFenceNV, caps.glSetFenceNV});
    }

    public static native void nglDeleteFencesNV(int var0, long var1);

    public static void glDeleteFencesNV(IntBuffer fences) {
        NVFence.nglDeleteFencesNV(fences.remaining(), MemoryUtil.memAddress((IntBuffer)fences));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteFencesNV(int fence) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer fences = stack.ints(fence);
            NVFence.nglDeleteFencesNV(1, MemoryUtil.memAddress((IntBuffer)fences));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenFencesNV(int var0, long var1);

    public static void glGenFencesNV(IntBuffer fences) {
        NVFence.nglGenFencesNV(fences.remaining(), MemoryUtil.memAddress((IntBuffer)fences));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenFencesNV() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer fences = stack.callocInt(1);
            NVFence.nglGenFencesNV(1, MemoryUtil.memAddress((IntBuffer)fences));
            int n = fences.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean nglIsFenceNV(int var0);

    public static boolean glIsFenceNV(int fence) {
        return NVFence.nglIsFenceNV(fence);
    }

    public static native boolean nglTestFenceNV(int var0);

    public static boolean glTestFenceNV(int fence) {
        return NVFence.nglTestFenceNV(fence);
    }

    public static native void nglGetFenceivNV(int var0, int var1, long var2);

    public static void glGetFenceivNV(int fence, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        NVFence.nglGetFenceivNV(fence, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFenceiNV(int fence, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            NVFence.nglGetFenceivNV(fence, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglFinishFenceNV(int var0);

    public static void glFinishFenceNV(int fence) {
        NVFence.nglFinishFenceNV(fence);
    }

    public static native void nglSetFenceNV(int var0, int var1);

    public static void glSetFenceNV(int fence, int condition) {
        NVFence.nglSetFenceNV(fence, condition);
    }

    public static void glDeleteFencesNV(int[] fences) {
        long __functionAddress = GLES.getICD().glDeleteFencesNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)fences.length, (int[])fences);
    }

    public static void glGenFencesNV(int[] fences) {
        long __functionAddress = GLES.getICD().glGenFencesNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)fences.length, (int[])fences);
    }

    public static void glGetFenceivNV(int fence, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glGetFenceivNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)fence, (int)pname, (int[])params);
    }

    static {
        GLES.initialize();
    }
}

