/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class OESVertexArrayObject {
    public static final int GL_VERTEX_ARRAY_BINDING_OES = 34229;

    protected OESVertexArrayObject() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glBindVertexArrayOES, caps.glDeleteVertexArraysOES, caps.glGenVertexArraysOES, caps.glIsVertexArrayOES});
    }

    public static native void nglBindVertexArrayOES(int var0);

    public static void glBindVertexArrayOES(int array) {
        OESVertexArrayObject.nglBindVertexArrayOES(array);
    }

    public static native void nglDeleteVertexArraysOES(int var0, long var1);

    public static void glDeleteVertexArraysOES(IntBuffer arrays) {
        OESVertexArrayObject.nglDeleteVertexArraysOES(arrays.remaining(), MemoryUtil.memAddress((IntBuffer)arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteVertexArraysOES(int array) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.ints(array);
            OESVertexArrayObject.nglDeleteVertexArraysOES(1, MemoryUtil.memAddress((IntBuffer)arrays));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenVertexArraysOES(int var0, long var1);

    public static void glGenVertexArraysOES(IntBuffer arrays) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)arrays, (int)1);
        }
        OESVertexArrayObject.nglGenVertexArraysOES(arrays.remaining(), MemoryUtil.memAddress((IntBuffer)arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenVertexArraysOES() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.callocInt(1);
            OESVertexArrayObject.nglGenVertexArraysOES(1, MemoryUtil.memAddress((IntBuffer)arrays));
            int n = arrays.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean nglIsVertexArrayOES(int var0);

    public static boolean glIsVertexArrayOES(int array) {
        return OESVertexArrayObject.nglIsVertexArrayOES(array);
    }

    public static void glDeleteVertexArraysOES(int[] arrays) {
        long __functionAddress = GLES.getICD().glDeleteVertexArraysOES;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)arrays.length, (int[])arrays);
    }

    public static void glGenVertexArraysOES(int[] arrays) {
        long __functionAddress = GLES.getICD().glGenVertexArraysOES;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])arrays, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)arrays.length, (int[])arrays);
    }

    static {
        GLES.initialize();
    }
}

