/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class OESViewportArray {
    public static final int GL_MAX_VIEWPORTS_OES = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS_OES = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE_OES = 33373;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX_OES = 33375;

    protected OESViewportArray() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glViewportArrayvOES, caps.glViewportIndexedfOES, caps.glViewportIndexedfvOES, caps.glScissorArrayvOES, caps.glScissorIndexedOES, caps.glScissorIndexedvOES, caps.glDepthRangeArrayfvOES, caps.glDepthRangeIndexedfOES, caps.glGetFloati_vOES});
    }

    public static native void nglViewportArrayvOES(int var0, int var1, long var2);

    public static void glViewportArrayvOES(int first, FloatBuffer v) {
        OESViewportArray.nglViewportArrayvOES(first, v.remaining() >> 2, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static native void nglViewportIndexedfOES(int var0, float var1, float var2, float var3, float var4);

    public static void glViewportIndexedfOES(int index, float x, float y, float w, float h) {
        OESViewportArray.nglViewportIndexedfOES(index, x, y, w, h);
    }

    public static native void nglViewportIndexedfvOES(int var0, long var1);

    public static void glViewportIndexedfvOES(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, (int)4);
        }
        OESViewportArray.nglViewportIndexedfvOES(index, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static native void nglScissorArrayvOES(int var0, int var1, long var2);

    public static void glScissorArrayvOES(int first, IntBuffer v) {
        OESViewportArray.nglScissorArrayvOES(first, v.remaining() >> 2, MemoryUtil.memAddress((IntBuffer)v));
    }

    public static native void nglScissorIndexedOES(int var0, int var1, int var2, int var3, int var4);

    public static void glScissorIndexedOES(int index, int left, int bottom, int width, int height) {
        OESViewportArray.nglScissorIndexedOES(index, left, bottom, width, height);
    }

    public static native void nglScissorIndexedvOES(int var0, long var1);

    public static void glScissorIndexedvOES(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, (int)4);
        }
        OESViewportArray.nglScissorIndexedvOES(index, MemoryUtil.memAddress((IntBuffer)v));
    }

    public static native void nglDepthRangeArrayfvOES(int var0, int var1, long var2);

    public static void glDepthRangeArrayfvOES(int first, FloatBuffer v) {
        OESViewportArray.nglDepthRangeArrayfvOES(first, v.remaining() >> 1, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static native void nglDepthRangeIndexedfOES(int var0, float var1, float var2);

    public static void glDepthRangeIndexedfOES(int index, float n, float f) {
        OESViewportArray.nglDepthRangeIndexedfOES(index, n, f);
    }

    public static native void nglGetFloati_vOES(int var0, int var1, long var2);

    public static void glGetFloati_vOES(int target, int index, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        OESViewportArray.nglGetFloati_vOES(target, index, MemoryUtil.memAddress((FloatBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetFloatiOES(int target, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            OESViewportArray.nglGetFloati_vOES(target, index, MemoryUtil.memAddress((FloatBuffer)data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglEnableiOES(int var0, int var1);

    public static void glEnableiOES(int target, int index) {
        OESViewportArray.nglEnableiOES(target, index);
    }

    public static native void nglDisableiOES(int var0, int var1);

    public static void glDisableiOES(int target, int index) {
        OESViewportArray.nglDisableiOES(target, index);
    }

    public static native boolean nglIsEnablediOES(int var0, int var1);

    public static boolean glIsEnablediOES(int target, int index) {
        return OESViewportArray.nglIsEnablediOES(target, index);
    }

    public static void glViewportArrayvOES(int first, float[] v) {
        long __functionAddress = GLES.getICD().glViewportArrayvOES;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)first, (int)(v.length >> 2), (float[])v);
    }

    public static void glViewportIndexedfvOES(int index, float[] v) {
        long __functionAddress = GLES.getICD().glViewportIndexedfvOES;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)index, (float[])v);
    }

    public static void glScissorArrayvOES(int first, int[] v) {
        long __functionAddress = GLES.getICD().glScissorArrayvOES;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)first, (int)(v.length >> 2), (int[])v);
    }

    public static void glScissorIndexedvOES(int index, int[] v) {
        long __functionAddress = GLES.getICD().glScissorIndexedvOES;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])v, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)index, (int[])v);
    }

    public static void glDepthRangeArrayfvOES(int first, float[] v) {
        long __functionAddress = GLES.getICD().glDepthRangeArrayfvOES;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)first, (int)(v.length >> 1), (float[])v);
    }

    public static void glGetFloati_vOES(int target, int index, float[] data) {
        long __functionAddress = GLES.getICD().glGetFloati_vOES;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])data, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)index, (float[])data);
    }

    static {
        GLES.initialize();
    }
}

