/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class QCOMDriverControl {
    protected QCOMDriverControl() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glGetDriverControlsQCOM, caps.glGetDriverControlStringQCOM, caps.glEnableDriverControlQCOM, caps.glDisableDriverControlQCOM});
    }

    public static native void nglGetDriverControlsQCOM(long var0, int var2, long var3);

    public static void glGetDriverControlsQCOM(IntBuffer num, IntBuffer driverControls) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)num, (int)1);
        }
        QCOMDriverControl.nglGetDriverControlsQCOM(MemoryUtil.memAddressSafe((IntBuffer)num), Checks.remainingSafe((Buffer)driverControls), MemoryUtil.memAddressSafe((IntBuffer)driverControls));
    }

    public static native void nglGetDriverControlStringQCOM(int var0, int var1, long var2, long var4);

    public static void glGetDriverControlStringQCOM(int driverControl, IntBuffer length, ByteBuffer driverControlString) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, Checks.remainingSafe((Buffer)driverControlString), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddressSafe((ByteBuffer)driverControlString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetDriverControlStringQCOM(int driverControl, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer driverControlString = stack.malloc(bufSize);
            QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)driverControlString));
            String string = MemoryUtil.memASCII((ByteBuffer)driverControlString, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglEnableDriverControlQCOM(int var0);

    public static void glEnableDriverControlQCOM(int driverControl) {
        QCOMDriverControl.nglEnableDriverControlQCOM(driverControl);
    }

    public static native void nglDisableDriverControlQCOM(int var0);

    public static void glDisableDriverControlQCOM(int driverControl) {
        QCOMDriverControl.nglDisableDriverControlQCOM(driverControl);
    }

    public static void glGetDriverControlsQCOM(int[] num, int[] driverControls) {
        long __functionAddress = GLES.getICD().glGetDriverControlsQCOM;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])num, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int[])num, (int)Checks.lengthSafe((int[])driverControls), (int[])driverControls);
    }

    public static void glGetDriverControlStringQCOM(int driverControl, int[] length, ByteBuffer driverControlString) {
        long __functionAddress = GLES.getICD().glGetDriverControlStringQCOM;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)driverControl, (int)Checks.remainingSafe((Buffer)driverControlString), (int[])length, (long)MemoryUtil.memAddressSafe((ByteBuffer)driverControlString));
    }

    static {
        GLES.initialize();
    }
}

