/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class QCOMExtendedGet2 {
    protected QCOMExtendedGet2() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glExtGetShadersQCOM, caps.glExtGetProgramsQCOM, caps.glExtIsProgramBinaryQCOM, caps.glExtGetProgramBinarySourceQCOM});
    }

    public static native void nglExtGetShadersQCOM(long var0, int var2, long var3);

    public static void glExtGetShadersQCOM(IntBuffer shaders, IntBuffer numShaders) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)numShaders, (int)1);
        }
        QCOMExtendedGet2.nglExtGetShadersQCOM(MemoryUtil.memAddressSafe((IntBuffer)shaders), Checks.remainingSafe((Buffer)shaders), MemoryUtil.memAddressSafe((IntBuffer)numShaders));
    }

    public static native void nglExtGetProgramsQCOM(long var0, int var2, long var3);

    public static void glExtGetProgramsQCOM(IntBuffer programs, IntBuffer numPrograms) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)numPrograms, (int)1);
        }
        QCOMExtendedGet2.nglExtGetProgramsQCOM(MemoryUtil.memAddressSafe((IntBuffer)programs), Checks.remainingSafe((Buffer)programs), MemoryUtil.memAddressSafe((IntBuffer)numPrograms));
    }

    public static native boolean nglExtIsProgramBinaryQCOM(int var0);

    public static boolean glExtIsProgramBinaryQCOM(int program) {
        return QCOMExtendedGet2.nglExtIsProgramBinaryQCOM(program);
    }

    public static native void nglExtGetProgramBinarySourceQCOM(int var0, int var1, long var2, long var4);

    public static void glExtGetProgramBinarySourceQCOM(int program, int shadertype, ByteBuffer source, IntBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        QCOMExtendedGet2.nglExtGetProgramBinarySourceQCOM(program, shadertype, MemoryUtil.memAddress((ByteBuffer)source), MemoryUtil.memAddressSafe((IntBuffer)length));
    }

    public static void glExtGetShadersQCOM(int[] shaders, int[] numShaders) {
        long __functionAddress = GLES.getICD().glExtGetShadersQCOM;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])numShaders, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int[])shaders, (int)Checks.lengthSafe((int[])shaders), (int[])numShaders);
    }

    public static void glExtGetProgramsQCOM(int[] programs, int[] numPrograms) {
        long __functionAddress = GLES.getICD().glExtGetProgramsQCOM;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])numPrograms, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int[])programs, (int)Checks.lengthSafe((int[])programs), (int[])numPrograms);
    }

    public static void glExtGetProgramBinarySourceQCOM(int program, int shadertype, ByteBuffer source, int[] length) {
        long __functionAddress = GLES.getICD().glExtGetProgramBinarySourceQCOM;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)program, (int)shadertype, (long)MemoryUtil.memAddress((ByteBuffer)source), (int[])length);
    }

    static {
        GLES.initialize();
    }
}

