/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.magicwerk.brownies.collections.helper.primitive.ShortBinarySearch;
import org.magicwerk.brownies.collections.helper.primitive.ShortMergeSort;
import org.magicwerk.brownies.collections.primitive.IShortList;
import org.magicwerk.brownies.collections.primitive.ShortGapList;

public class ShortBigList
extends IShortList {
    private static final long serialVersionUID = 3715838828540564836L;
    private static final int DEFAULT_BLOCK_SIZE = 1000;
    private static final float MERGE_THRESHOLD = 0.35f;
    private static final float FILL_THRESHOLD = 0.95f;
    private static final boolean CHECK = false;
    private static final ShortBigList EMPTY = ShortBigList.create().unmodifiableList();
    private int blockSize;
    private int size;
    private ShortBlockNode rootNode;
    private ShortBlockNode currNode;
    private int currShortBlockStart;
    private int currShortBlockEnd;
    private int currModify;

    public static IShortList of(short[] values) {
        return new ImmutableShortListArrayPrimitive(values);
    }

    public static IShortList of(Short[] values) {
        return new ImmutableShortListArrayWrapper(values);
    }

    public static IShortList of(List<Short> values) {
        return new ImmutableShortListList(values);
    }

    public static ShortBigList EMPTY() {
        return EMPTY;
    }

    protected ShortBigList(boolean copy, ShortBigList that) {
        if (copy) {
            this.blockSize = that.blockSize;
            this.currShortBlockStart = that.currShortBlockStart;
            this.currShortBlockEnd = that.currShortBlockEnd;
            this.currNode = that.currNode;
            this.rootNode = that.rootNode;
            this.size = that.size;
        }
    }

    public static ShortBigList create() {
        return new ShortBigList();
    }

    public static ShortBigList create(Collection<Short> coll) {
        return new ShortBigList(coll);
    }

    public static ShortBigList create(short ... elems) {
        ShortBigList list = new ShortBigList();
        for (short elem : elems) {
            list.add(elem);
        }
        return list;
    }

    public ShortBigList() {
        this(1000);
    }

    public ShortBigList(int blockSize) {
        if (blockSize < 2) {
            throw new IndexOutOfBoundsException("Invalid blockSize: " + blockSize);
        }
        this.doInit(blockSize, -1);
    }

    public ShortBigList(Collection<Short> coll) {
        if (coll instanceof ShortBigList) {
            this.doAssign((ShortBigList)((Object)coll));
            this.doClone((ShortBigList)((Object)coll));
        } else {
            this.blockSize = 1000;
            this.addShortBlock(0, new ShortBlock());
            for (Object obj : coll.toArray()) {
                this.add((Short)obj);
            }
            assert (this.size() == coll.size());
        }
    }

    public int blockSize() {
        return this.blockSize;
    }

    private ShortBigList(int blockSize, int firstShortBlockSize) {
        this.doInit(blockSize, firstShortBlockSize);
    }

    private void doInit(int blockSize, int firstShortBlockSize) {
        this.blockSize = blockSize;
        ShortBlock block = firstShortBlockSize <= 1 ? new ShortBlock() : new ShortBlock(firstShortBlockSize);
        this.addShortBlock(0, block);
    }

    @Override
    public ShortBigList copy() {
        return (ShortBigList)super.copy();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    protected void doAssign(IShortList that) {
        ShortBigList list = (ShortBigList)that;
        this.blockSize = list.blockSize;
        this.currShortBlockEnd = list.currShortBlockEnd;
        this.currShortBlockStart = list.currShortBlockStart;
        this.currNode = list.currNode;
        this.rootNode = list.rootNode;
        this.size = list.size;
    }

    @Override
    protected void doClone(IShortList that) {
        ShortBigList bigList = (ShortBigList)that;
        bigList.releaseShortBlock();
        this.rootNode = this.copy(bigList.rootNode);
        this.currNode = null;
        this.currModify = 0;
    }

    private ShortBlockNode copy(ShortBlockNode node) {
        ShortBlockNode newNode = node.min();
        int index = newNode.block.size();
        ShortBlockNode newRoot = new ShortBlockNode(null, index, newNode.block.ref(), null, null);
        while ((newNode = newNode.next()) != null) {
            newRoot = newRoot.insert(index += newNode.block.size(), newNode.block.ref());
            newRoot.parent = null;
        }
        return newRoot;
    }

    @Override
    public short getDefaultElem() {
        return 0;
    }

    protected void finalize() {
        ShortBlockNode node = this.rootNode.min();
        while (node != null) {
            node.block.unref();
            node = node.next();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    protected short doGet(int index) {
        int pos = this.getShortBlockIndex(index, false, 0);
        return this.currNode.block.doGet(pos);
    }

    @Override
    protected short doSet(int index, short elem) {
        int pos = this.getShortBlockIndex(index, true, 0);
        short oldElem = this.currNode.block.doGet(pos);
        this.currNode.block.doSet(pos, elem);
        return oldElem;
    }

    @Override
    protected short doReSet(int index, short elem) {
        int pos = this.getShortBlockIndex(index, true, 0);
        short oldElem = this.currNode.block.doGet(pos);
        this.currNode.block.doSet(pos, elem);
        return oldElem;
    }

    private void releaseShortBlock() {
        if (this.currModify != 0) {
            int modify = this.currModify;
            this.currModify = 0;
            this.modify(this.currNode, modify);
        }
        this.currNode = null;
    }

    private int getShortBlockIndex(int index, boolean write, int modify) {
        if (this.currNode != null) {
            if (index >= this.currShortBlockStart && (index < this.currShortBlockEnd || index == this.currShortBlockEnd && this.size == index)) {
                if (write && this.currNode.block.isShared()) {
                    this.currNode.block.unref();
                    this.currNode.setShortBlock(new ShortBlock(this.currNode.block));
                }
                this.currModify += modify;
                return index - this.currShortBlockStart;
            }
            this.releaseShortBlock();
        }
        if (index == this.size) {
            if (this.currNode == null || this.currShortBlockEnd != this.size) {
                this.currNode = this.rootNode.max();
                this.currShortBlockEnd = this.size;
                this.currShortBlockStart = this.size - this.currNode.block.size();
            }
            if (modify != 0) {
                this.currNode.relPos += modify;
                ShortBlockNode leftNode = this.currNode.getLeftSubTree();
                if (leftNode != null) {
                    leftNode.relPos -= modify;
                }
            }
        } else if (index == 0) {
            if (this.currNode == null || this.currShortBlockStart != 0) {
                this.currNode = this.rootNode.min();
                this.currShortBlockEnd = this.currNode.block.size();
                this.currShortBlockStart = 0;
            }
            if (modify != 0) {
                this.rootNode.relPos += modify;
            }
        }
        if (this.currNode == null) {
            this.doGetShortBlock(index, modify);
        }
        assert (index >= this.currShortBlockStart && index <= this.currShortBlockEnd);
        if (write && this.currNode.block.isShared()) {
            this.currNode.block.unref();
            this.currNode.setShortBlock(new ShortBlock(this.currNode.block));
        }
        return index - this.currShortBlockStart;
    }

    private boolean isOnlyRootShortBlock() {
        return this.rootNode.left == null && this.rootNode.right == null;
    }

    private void doGetShortBlock(int index, int modify) {
        this.currNode = this.rootNode;
        this.currShortBlockEnd = this.rootNode.relPos;
        if (this.currNode.relPos == 0) {
            if (modify != 0) {
                this.currNode.relPos += modify;
            }
        } else {
            boolean wasLeft = false;
            while (true) {
                ShortBlockNode nextNode;
                assert (index >= 0);
                int leftIndex = this.currShortBlockEnd - this.currNode.block.size();
                assert (leftIndex >= 0);
                if (index >= leftIndex && index < this.currShortBlockEnd) {
                    if (modify == 0) break;
                    ShortBlockNode leftNode = this.currNode.getLeftSubTree();
                    if (this.currNode.relPos > 0) {
                        this.currNode.relPos += modify;
                        if (leftNode == null) break;
                        leftNode.relPos -= modify;
                        break;
                    }
                    if (leftNode == null) break;
                    leftNode.relPos -= modify;
                    break;
                }
                if (index < this.currShortBlockEnd) {
                    nextNode = this.currNode.getLeftSubTree();
                    if (!(modify == 0 || nextNode != null && wasLeft)) {
                        this.currNode.relPos = this.currNode.relPos > 0 ? (this.currNode.relPos += modify) : (this.currNode.relPos -= modify);
                        wasLeft = true;
                    }
                    if (nextNode == null) {
                        break;
                    }
                } else {
                    nextNode = this.currNode.getRightSubTree();
                    if (modify != 0 && (nextNode == null || wasLeft)) {
                        if (this.currNode.relPos > 0) {
                            this.currNode.relPos += modify;
                            ShortBlockNode left = this.currNode.getLeftSubTree();
                            if (left != null) {
                                left.relPos -= modify;
                            }
                        } else {
                            this.currNode.relPos -= modify;
                        }
                        wasLeft = false;
                    }
                    if (nextNode == null) break;
                }
                this.currShortBlockEnd += nextNode.relPos;
                this.currNode = nextNode;
            }
        }
        this.currShortBlockStart = this.currShortBlockEnd - this.currNode.block.size();
    }

    private void addShortBlock(int index, ShortBlock obj) {
        if (this.rootNode == null) {
            this.rootNode = new ShortBlockNode(null, index, obj, null, null);
        } else {
            this.rootNode = this.rootNode.insert(index, obj);
            this.rootNode.parent = null;
        }
    }

    @Override
    protected boolean doAdd(int index, short element) {
        int maxSize;
        if (index == -1) {
            index = this.size;
        }
        int pos = this.getShortBlockIndex(index, true, 1);
        int n = maxSize = index == this.size || index == 0 ? (int)((float)this.blockSize * 0.95f) : this.blockSize;
        if (this.currNode.block.size() < maxSize || this.currNode.block.size() == 1 && this.currNode.block.size() < this.blockSize) {
            this.currNode.block.doAdd(pos, element);
            ++this.currShortBlockEnd;
        } else {
            ShortBlock newShortBlock = new ShortBlock(this.blockSize);
            if (index == this.size) {
                ShortBlockNode lastNode;
                newShortBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addShortBlock(this.size + 1, newShortBlock);
                this.currNode = lastNode = this.currNode.next();
                this.currShortBlockStart = this.currShortBlockEnd++;
            } else if (index == 0) {
                ShortBlockNode firstNode;
                newShortBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addShortBlock(1, newShortBlock);
                this.currNode = firstNode = this.currNode.previous();
                this.currShortBlockStart = 0;
                this.currShortBlockEnd = 1;
            } else {
                int nextShortBlockLen = this.blockSize / 2;
                int blockLen = this.blockSize - nextShortBlockLen;
                ShortGapList.transferRemove(this.currNode.block, blockLen, nextShortBlockLen, newShortBlock, 0, 0);
                this.modify(this.currNode, -nextShortBlockLen - 1);
                this.addShortBlock(this.currShortBlockEnd - nextShortBlockLen, newShortBlock);
                if (pos < blockLen) {
                    this.currNode.block.doAdd(pos, element);
                    this.currShortBlockEnd = this.currShortBlockStart + blockLen + 1;
                    this.modify(this.currNode, 1);
                } else {
                    this.currNode = this.currNode.next();
                    this.modify(this.currNode, 1);
                    this.currNode.block.doAdd(pos - blockLen, element);
                    this.currShortBlockStart += blockLen;
                    ++this.currShortBlockEnd;
                }
            }
        }
        ++this.size;
        return true;
    }

    private void modify(ShortBlockNode node, int modify) {
        if (node == this.currNode) {
            modify += this.currModify;
            this.currModify = 0;
        } else {
            this.releaseShortBlock();
        }
        if (modify == 0) {
            return;
        }
        if (node.relPos < 0) {
            ShortBlockNode p;
            ShortBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            ShortBlockNode pp = node.parent;
            assert (pp.getLeftSubTree() == node);
            boolean parentRight = true;
            while ((p = pp.parent) != null) {
                boolean pRight;
                boolean bl = pRight = p.getLeftSubTree() == pp;
                if (parentRight != pRight) {
                    pp.relPos = pp.relPos > 0 ? (pp.relPos += modify) : (pp.relPos -= modify);
                }
                pp = p;
                parentRight = pRight;
            }
            if (parentRight) {
                this.rootNode.relPos += modify;
            }
        } else {
            ShortBlockNode parent;
            node.relPos += modify;
            ShortBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            if ((parent = node.parent) != null) {
                ShortBlockNode p;
                assert (parent.getRightSubTree() == node);
                boolean parentLeft = true;
                while ((p = parent.parent) != null) {
                    boolean pLeft;
                    boolean bl = pLeft = p.getRightSubTree() == parent;
                    if (parentLeft != pLeft) {
                        parent.relPos = parent.relPos > 0 ? (parent.relPos += modify) : (parent.relPos -= modify);
                    }
                    parent = p;
                    parentLeft = pLeft;
                }
                if (!parentLeft) {
                    this.rootNode.relPos += modify;
                }
            }
        }
    }

    private ShortBlockNode doRemove(ShortBlockNode node) {
        ShortBlockNode newNode;
        ShortBlockNode p = node.parent;
        ShortBlockNode n = newNode = node.removeSelf();
        while (p != null) {
            assert (p.left == node || p.right == node);
            if (p.left == node) {
                p.left = newNode;
            } else {
                p.right = newNode;
            }
            node = p;
            node.recalcHeight();
            newNode = node.balance();
            p = newNode.parent;
        }
        this.rootNode = newNode;
        return n;
    }

    @Override
    protected boolean doAddAll(int index, IShortList list) {
        if (list.size() == 0) {
            return false;
        }
        if (index == -1) {
            index = this.size;
        }
        int oldSize = this.size;
        if (list.size() == 1) {
            return this.doAdd(index, list.get(0));
        }
        int addPos = this.getShortBlockIndex(index, true, 0);
        ShortBlock addShortBlock = this.currNode.block;
        int space = this.blockSize - addShortBlock.size();
        int addLen = list.size();
        if (addLen <= space) {
            this.currNode.block.addAll(addPos, list);
            this.modify(this.currNode, addLen);
            this.size += addLen;
            this.currShortBlockEnd += addLen;
        } else if (index == this.size) {
            int add;
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list.get(i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                ShortBlock nextShortBlock = new ShortBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextShortBlock.add(i, list.get(done + i));
                }
                this.addShortBlock(this.size + (done += add), nextShortBlock);
                this.currNode = this.currNode.next();
            }
            this.size += addLen;
            this.currShortBlockEnd = this.size;
            this.currShortBlockStart = this.currShortBlockEnd - this.currNode.block.size();
        } else if (index == 0) {
            int add;
            assert (addPos == 0);
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list.get(addLen - space + i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                ShortBlock nextShortBlock = new ShortBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextShortBlock.add(i, list.get(addLen - done - add + i));
                }
                done += add;
                this.addShortBlock(0, nextShortBlock);
                this.currNode = this.currNode.previous();
            }
            this.size += addLen;
            this.currShortBlockStart = 0;
            this.currShortBlockEnd = this.currNode.block.size();
        } else {
            ShortGapList sublist;
            int add;
            ShortGapList list2 = ShortGapList.create();
            list2.addAll(list);
            int remove = this.currNode.block.size() - addPos;
            if (remove > 0) {
                list2.addAll(this.currNode.block.getAll(addPos, remove));
                this.currNode.block.remove(addPos, remove);
                this.modify(this.currNode, -remove);
                this.size -= remove;
                this.currShortBlockEnd -= remove;
            }
            int numElems = this.currNode.block.size() + list2.size();
            int numShortBlocks = (numElems - 1) / this.blockSize + 1;
            assert (numShortBlocks > 1);
            int has = this.currNode.block.size();
            int should = numElems / numShortBlocks;
            int listPos = 0;
            if (has < should) {
                add = should - has;
                sublist = list2.getAll(0, add);
                listPos += add;
                this.currNode.block.addAll(addPos, sublist);
                this.modify(this.currNode, add);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                --numShortBlocks;
                this.size += add;
                this.currShortBlockEnd += add;
            } else if (has > should) {
                ShortBlock nextShortBlock = new ShortBlock(this.blockSize);
                int move = has - should;
                nextShortBlock.addAll(this.currNode.block.getAll(this.currNode.block.size() - move, move));
                this.currNode.block.remove(this.currNode.block.size() - move, move);
                this.modify(this.currNode, -move);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                this.currShortBlockEnd -= move;
                should = numElems / --numShortBlocks;
                int add2 = should - move;
                assert (add2 >= 0);
                ShortGapList sublist2 = list2.getAll(0, add2);
                nextShortBlock.addAll(move, sublist2);
                listPos += add2;
                assert (nextShortBlock.size() == should);
                numElems -= should;
                --numShortBlocks;
                this.size += add2;
                this.addShortBlock(this.currShortBlockEnd, nextShortBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextShortBlock);
                assert (this.currNode.block.size() == add2 + move);
                this.currShortBlockStart = this.currShortBlockEnd;
                this.currShortBlockEnd += add2 + move;
            } else {
                numElems -= should;
                --numShortBlocks;
            }
            while (numShortBlocks > 0) {
                add = numElems / numShortBlocks;
                assert (add > 0);
                sublist = list2.getAll(listPos, add);
                listPos += add;
                ShortBlock nextShortBlock = new ShortBlock();
                nextShortBlock.addAll(sublist);
                assert (nextShortBlock.size() == add);
                numElems -= add;
                this.addShortBlock(this.currShortBlockEnd, nextShortBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextShortBlock);
                assert (this.currNode.block.size() == add);
                this.currShortBlockStart = this.currShortBlockEnd;
                this.currShortBlockEnd += add;
                this.size += add;
                --numShortBlocks;
            }
        }
        assert (oldSize + addLen == this.size);
        return true;
    }

    @Override
    protected void doClear() {
        this.finalize();
        this.rootNode = null;
        this.currShortBlockStart = 0;
        this.currShortBlockEnd = 0;
        this.currModify = 0;
        this.currNode = null;
        this.size = 0;
        this.doInit(this.blockSize, 0);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        if (len == 0) {
            return;
        }
        if (index == 0 && len == this.size) {
            this.doClear();
            return;
        }
        if (len == 1) {
            this.doRemove(index);
            return;
        }
        int startPos = this.getShortBlockIndex(index, true, 0);
        ShortBlockNode startNode = this.currNode;
        int endPos = this.getShortBlockIndex(index + len - 1, true, 0);
        ShortBlockNode endNode = this.currNode;
        if (startNode == endNode) {
            this.getShortBlockIndex(index, true, -len);
            this.currNode.block.remove(startPos, len);
            if (this.currNode.block.isEmpty()) {
                ShortBlockNode oldCurrNode = this.currNode;
                this.releaseShortBlock();
                ShortBlockNode node = this.doRemove(oldCurrNode);
                this.merge(node);
            } else {
                this.currShortBlockEnd -= len;
                this.merge(this.currNode);
            }
            this.size -= len;
        } else {
            int startLen = startNode.block.size() - startPos;
            this.getShortBlockIndex(index, true, -startLen);
            startNode.block.remove(startPos, startLen);
            assert (startNode == this.currNode);
            if (this.currNode.block.isEmpty()) {
                this.releaseShortBlock();
                this.doRemove(startNode);
                startNode = null;
            }
            len -= startLen;
            this.size -= startLen;
            while (len > 0) {
                this.currNode = null;
                this.getShortBlockIndex(index, true, 0);
                int s = this.currNode.block.size();
                if (s <= len) {
                    this.modify(this.currNode, -s);
                    ShortBlockNode oldCurrNode = this.currNode;
                    this.releaseShortBlock();
                    this.doRemove(oldCurrNode);
                    if (oldCurrNode == endNode) {
                        endNode = null;
                    }
                    len -= s;
                    this.size -= s;
                    continue;
                }
                this.modify(this.currNode, -len);
                this.currNode.block.remove(0, len);
                this.size -= len;
                break;
            }
            this.releaseShortBlock();
            this.getShortBlockIndex(index, false, 0);
            this.merge(this.currNode);
        }
    }

    private void merge(ShortBlockNode node) {
        if (node == null) {
            return;
        }
        int minShortBlockSize = Math.max((int)((float)this.blockSize * 0.35f), 1);
        if (node.block.size() >= minShortBlockSize) {
            return;
        }
        ShortBlockNode oldCurrNode = node;
        ShortBlockNode leftNode = node.previous();
        if (leftNode != null && leftNode.block.size() < minShortBlockSize) {
            int len = node.block.size();
            int dstSize = leftNode.getShortBlock().size();
            for (int i = 0; i < len; ++i) {
                leftNode.block.add((short)0);
            }
            ShortGapList.transferCopy(node.block, 0, len, leftNode.block, dstSize, len);
            assert (leftNode.block.size() <= this.blockSize);
            this.modify(leftNode, len);
            this.modify(oldCurrNode, -len);
            this.releaseShortBlock();
            this.doRemove(oldCurrNode);
        } else {
            ShortBlockNode rightNode = node.next();
            if (rightNode != null && rightNode.block.size() < minShortBlockSize) {
                int len = node.block.size();
                for (int i = 0; i < len; ++i) {
                    rightNode.block.add(0, (short)0);
                }
                ShortGapList.transferCopy(node.block, 0, len, rightNode.block, 0, len);
                assert (rightNode.block.size() <= this.blockSize);
                this.modify(rightNode, len);
                this.modify(oldCurrNode, -len);
                this.releaseShortBlock();
                this.doRemove(oldCurrNode);
            }
        }
    }

    @Override
    protected short doRemove(int index) {
        int pos = this.getShortBlockIndex(index, true, -1);
        short oldElem = this.currNode.block.doRemove(pos);
        --this.currShortBlockEnd;
        int minShortBlockSize = Math.max(this.blockSize / 3, 1);
        if (this.currNode.block.size() < minShortBlockSize) {
            if (this.currNode.block.size() == 0) {
                if (!this.isOnlyRootShortBlock()) {
                    ShortBlockNode oldCurrNode = this.currNode;
                    this.releaseShortBlock();
                    this.doRemove(oldCurrNode);
                }
            } else if (index != 0 && index != this.size - 1) {
                this.merge(this.currNode);
            }
        }
        --this.size;
        return oldElem;
    }

    @Override
    public ShortBigList unmodifiableList() {
        return new ImmutableShortBigList(this);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        if (this.isOnlyRootShortBlock()) {
            if (minCapacity > this.blockSize) {
                minCapacity = this.blockSize;
            }
            this.rootNode.block.doEnsureCapacity(minCapacity);
        }
    }

    @Override
    public void trimToSize() {
        this.doModify();
        if (this.isOnlyRootShortBlock()) {
            this.rootNode.block.trimToSize();
        } else {
            ShortBigList newList = new ShortBigList(this.blockSize);
            ShortBlockNode node = this.rootNode.min();
            while (node != null) {
                newList.addAll(node.block);
                this.remove(0, node.block.size());
                node = node.next();
            }
            this.doAssign(newList);
        }
    }

    @Override
    protected IShortList doCreate(int capacity) {
        if (capacity <= this.blockSize) {
            return new ShortBigList(this.blockSize);
        }
        return new ShortBigList(this.blockSize, capacity);
    }

    @Override
    public void sort(int index, int len) {
        this.checkRange(index, len);
        if (this.isOnlyRootShortBlock()) {
            this.rootNode.block.sort(index, len);
        } else {
            ShortMergeSort.sort(this, index, index + len);
        }
    }

    @Override
    public int binarySearch(int index, int len, short key) {
        this.checkRange(index, len);
        if (this.isOnlyRootShortBlock()) {
            return this.rootNode.block.binarySearch(key);
        }
        return ShortBinarySearch.binarySearch(this, key, 0, this.size());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.blockSize);
        int size = this.size();
        oos.writeInt(size);
        for (int i = 0; i < size; ++i) {
            oos.writeShort(this.doGet(i));
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int blockSize = ois.readInt();
        int size = ois.readInt();
        int firstShortBlockSize = size <= blockSize ? size : -1;
        this.doInit(blockSize, firstShortBlockSize);
        for (int i = 0; i < size; ++i) {
            this.add(ois.readShort());
        }
    }

    private void checkNode(ShortBlockNode node) {
        assert ((node.block.size() > 0 || node == this.rootNode) && node.block.size() <= this.blockSize);
        ShortBlockNode child = node.getLeftSubTree();
        assert (child == null || child.parent == node);
        child = node.getRightSubTree();
        assert (child == null || child.parent == node);
    }

    private void checkHeight(ShortBlockNode node) {
        ShortBlockNode left = node.getLeftSubTree();
        ShortBlockNode right = node.getRightSubTree();
        if (left == null) {
            if (right == null) {
                assert (node.height == 0);
            } else {
                assert (right.height == node.height - 1);
                this.checkHeight(right);
            }
        } else {
            if (right == null) {
                assert (left.height == node.height - 1);
            } else {
                assert (left.height == node.height - 1 || left.height == node.height - 2);
                assert (right.height == node.height - 1 || right.height == node.height - 2);
                assert (right.height == node.height - 1 || left.height == node.height - 1);
            }
            this.checkHeight(left);
        }
    }

    private void check() {
        if (this.currNode != null) {
            assert (this.currShortBlockStart >= 0 && this.currShortBlockEnd <= this.size && this.currShortBlockStart <= this.currShortBlockEnd);
            assert (this.currShortBlockStart + this.currNode.block.size() == this.currShortBlockEnd);
        }
        if (this.rootNode == null) {
            assert (this.size == 0);
            return;
        }
        this.checkHeight(this.rootNode);
        ShortBlockNode oldCurrNode = this.currNode;
        int oldCurrModify = this.currModify;
        if (this.currModify != 0) {
            this.currNode = null;
            this.currModify = 0;
            this.modify(oldCurrNode, oldCurrModify);
        }
        ShortBlockNode node = this.rootNode;
        this.checkNode(node);
        int index = node.relPos;
        while (node.left != null) {
            node = node.left;
            this.checkNode(node);
            assert (node.relPos < 0);
            index += node.relPos;
        }
        ShortBlock block = node.getShortBlock();
        assert (block.size() == index);
        int lastIndex = index;
        while (lastIndex < this.size()) {
            node = this.rootNode;
            index = node.relPos;
            int searchIndex = lastIndex + 1;
            while (true) {
                this.checkNode(node);
                block = node.getShortBlock();
                assert (block.size() > 0);
                if (searchIndex > index - block.size() && searchIndex <= index) break;
                if (searchIndex < index) {
                    if (node.left == null || node.left.height >= node.height) break;
                    node = node.left;
                } else {
                    if (node.right == null || node.right.height >= node.height) break;
                    node = node.right;
                }
                index += node.relPos;
            }
            block = node.getShortBlock();
            assert (block.size() == index - lastIndex);
            lastIndex = index;
        }
        assert (index == this.size());
        if (oldCurrModify != 0) {
            this.modify(oldCurrNode, -oldCurrModify);
        }
        this.currNode = oldCurrNode;
        this.currModify = oldCurrModify;
    }

    protected static class ImmutableShortBigList
    extends ShortBigList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableShortBigList(ShortBigList that) {
            super(true, that);
        }

        @Override
        protected boolean doAdd(int index, short elem) {
            this.error();
            return false;
        }

        @Override
        protected short doSet(int index, short elem) {
            this.error();
            return 0;
        }

        @Override
        protected short doReSet(int index, short elem) {
            this.error();
            return 0;
        }

        @Override
        protected short doRemove(int index) {
            this.error();
            return 0;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }

    static class ShortBlockNode {
        ShortBlockNode parent;
        ShortBlockNode left;
        boolean leftIsPrevious;
        ShortBlockNode right;
        boolean rightIsNext;
        int height;
        int relPos;
        ShortBlock block;

        private ShortBlockNode(ShortBlockNode parent, int relPos, ShortBlock block, ShortBlockNode rightFollower, ShortBlockNode leftFollower) {
            this.parent = parent;
            this.relPos = relPos;
            this.block = block;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
        }

        private ShortBlock getShortBlock() {
            return this.block;
        }

        private void setShortBlock(ShortBlock block) {
            this.block = block;
        }

        private ShortBlockNode next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return this.right.min();
        }

        private ShortBlockNode previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return this.left.max();
        }

        private ShortBlockNode insert(int index, ShortBlock obj) {
            assert (this.relPos != 0);
            int relIndex = index - this.relPos;
            if (relIndex < 0) {
                return this.insertOnLeft(relIndex, obj);
            }
            return this.insertOnRight(relIndex, obj);
        }

        private ShortBlockNode insertOnLeft(int relIndex, ShortBlock obj) {
            if (this.getLeftSubTree() == null) {
                int pos = this.relPos >= 0 ? -this.relPos : -this.block.size();
                this.setLeft(new ShortBlockNode(this, pos, obj, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(relIndex, obj), null);
            }
            if (this.relPos >= 0) {
                this.relPos += obj.size();
            }
            ShortBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private ShortBlockNode insertOnRight(int relIndex, ShortBlock obj) {
            if (this.getRightSubTree() == null) {
                this.setRight(new ShortBlockNode(this, obj.size(), obj, this.right, this), null);
            } else {
                this.setRight(this.right.insert(relIndex, obj), null);
            }
            if (this.relPos < 0) {
                this.relPos -= obj.size();
            }
            ShortBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private ShortBlockNode getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private ShortBlockNode getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private ShortBlockNode max() {
            return this.getRightSubTree() == null ? this : this.right.max();
        }

        private ShortBlockNode min() {
            return this.getLeftSubTree() == null ? this : this.left.min();
        }

        private ShortBlockNode removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(this.right.removeMax(), this.right.right);
            this.recalcHeight();
            return this.balance();
        }

        private ShortBlockNode removeMin(int size) {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(this.left.removeMin(size), this.left.left);
            if (this.relPos > 0) {
                this.relPos -= size;
            }
            this.recalcHeight();
            return this.balance();
        }

        private ShortBlockNode removeSelf() {
            ShortBlockNode p = this.parent;
            ShortBlockNode n = this.doRemoveSelf();
            if (n != null) {
                assert (p != n);
                n.parent = p;
            }
            return n;
        }

        private ShortBlockNode doRemoveSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                this.left.relPos = this.relPos > 0 ? this.left.relPos + (this.relPos + (this.relPos > 0 ? 0 : 1)) : (this.left.relPos += this.relPos);
                this.left.max().setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                if (this.relPos < 0) {
                    this.right.relPos = this.right.relPos + (this.relPos - (this.relPos < 0 ? 0 : 1));
                }
                this.right.min().setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                ShortBlockNode rightMin = this.right.min();
                this.block = rightMin.block;
                int bs = this.block.size();
                if (this.leftIsPrevious) {
                    this.left = rightMin.left;
                }
                this.right = this.right.removeMin(bs);
                this.relPos += bs;
                this.left.relPos -= bs;
            } else {
                ShortBlockNode leftMax = this.left.max();
                this.block = leftMax.block;
                if (this.rightIsNext) {
                    this.right = leftMax.right;
                }
                ShortBlockNode leftPrevious = this.left.left;
                this.left = this.left.removeMax();
                if (this.left == null) {
                    this.left = leftPrevious;
                    this.leftIsPrevious = true;
                } else if (this.left.relPos == 0) {
                    this.left.relPos = -1;
                }
            }
            this.recalcHeight();
            return this;
        }

        private ShortBlockNode balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (this.left.heightRightMinusLeft() > 0) {
                        this.setLeft(this.left.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (this.right.heightRightMinusLeft() < 0) {
                        this.setRight(this.right.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(ShortBlockNode node) {
            if (node == null) {
                return 0;
            }
            return node.relPos;
        }

        private int setOffset(ShortBlockNode node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int oldOffset = this.getOffset(node);
            node.relPos = newOffest;
            return oldOffset;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(ShortBlockNode node) {
            return node == null ? -1 : node.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private ShortBlockNode rotateLeft() {
            assert (!this.rightIsNext);
            ShortBlockNode newTop = this.right;
            ShortBlockNode movedNode = this.getRightSubTree().getLeftSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            ShortBlockNode p = this.parent;
            this.setRight(movedNode, newTop);
            newTop.setLeft(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private ShortBlockNode rotateRight() {
            assert (!this.leftIsPrevious);
            ShortBlockNode newTop = this.left;
            ShortBlockNode movedNode = this.getLeftSubTree().getRightSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            ShortBlockNode p = this.parent;
            this.setLeft(movedNode, newTop);
            newTop.setRight(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private void setLeft(ShortBlockNode node, ShortBlockNode previous) {
            assert (node != this && previous != this);
            boolean bl = this.leftIsPrevious = node == null;
            if (this.leftIsPrevious) {
                this.left = previous;
            } else {
                this.left = node;
                this.left.parent = this;
            }
            this.recalcHeight();
        }

        private void setRight(ShortBlockNode node, ShortBlockNode next) {
            assert (node != this && next != this);
            boolean bl = this.rightIsNext = node == null;
            if (this.rightIsNext) {
                this.right = next;
            } else {
                this.right = node;
                this.right.parent = this;
            }
            this.recalcHeight();
        }

        public String toString() {
            return "ShortBlockNode(" + this.relPos + ',' + (this.getRightSubTree() != null) + ',' + this.block + ',' + (this.getRightSubTree() != null) + ", height " + this.height + " )";
        }
    }

    static class ShortBlock
    extends ShortGapList {
        private AtomicInteger refCount = new AtomicInteger(1);

        public ShortBlock() {
        }

        public ShortBlock(int capacity) {
            super(capacity);
        }

        public ShortBlock(ShortBlock that) {
            super(that.capacity());
            this.addAll(that);
        }

        public boolean isShared() {
            return this.refCount.get() > 1;
        }

        public ShortBlock ref() {
            this.refCount.incrementAndGet();
            return this;
        }

        public void unref() {
            this.refCount.decrementAndGet();
        }
    }

    protected static abstract class ImmutableShortList
    extends IShortList {
        protected ImmutableShortList() {
        }

        @Override
        public int capacity() {
            return this.size();
        }

        @Override
        public int binarySearch(int index, int len, short key) {
            return ShortBinarySearch.binarySearch(this, key, index, index + len);
        }

        @Override
        public IShortList unmodifiableList() {
            return this;
        }

        @Override
        protected short getDefaultElem() {
            return 0;
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        @Override
        protected void doClone(IShortList that) {
            this.error();
        }

        @Override
        protected short doSet(int index, short elem) {
            this.error();
            return 0;
        }

        @Override
        protected short doReSet(int index, short elem) {
            this.error();
            return 0;
        }

        @Override
        protected boolean doAdd(int index, short elem) {
            this.error();
            return false;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IShortList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IShortList that) {
            this.error();
        }

        @Override
        protected short doRemove(int index) {
            this.error();
            return 0;
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }
    }

    static class ImmutableShortListList
    extends ImmutableShortList {
        List<Short> values;

        public ImmutableShortListList(List<Short> values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        protected short doGet(int index) {
            return this.values.get(index);
        }
    }

    static class ImmutableShortListArrayWrapper
    extends ImmutableShortList {
        Short[] values;

        public ImmutableShortListArrayWrapper(Short[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected short doGet(int index) {
            return this.values[index];
        }
    }

    static class ImmutableShortListArrayPrimitive
    extends ImmutableShortList {
        short[] values;

        public ImmutableShortListArrayPrimitive(short[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected short doGet(int index) {
            return this.values[index];
        }
    }
}

