/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FilterVisitor2;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.NullFilter;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.SpatialOperator;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class FilterVisitorFilterWrapper
implements org.opengis.filter.FilterVisitor {
    FilterVisitor delegate;

    public FilterVisitorFilterWrapper(FilterVisitor delegate) {
        this.delegate = delegate;
    }

    protected void visitLogicFilter(Filter filter) {
        if (filter instanceof LogicFilter) {
            this.delegate.visit((LogicFilter)filter);
        }
    }

    protected void visitCompareFilter(Filter filter) {
        if (filter instanceof BetweenFilter) {
            this.delegate.visit((BetweenFilter)filter);
            return;
        }
        if (filter instanceof NullFilter) {
            this.delegate.visit((NullFilter)filter);
            return;
        }
        if (filter instanceof LikeFilter) {
            this.delegate.visit((LikeFilter)filter);
        }
        if (filter instanceof CompareFilter) {
            this.delegate.visit((CompareFilter)filter);
        }
    }

    protected void visitGeometryFilter(SpatialOperator filter) {
        if (filter instanceof GeometryFilter) {
            this.delegate.visit((GeometryFilter)filter);
        }
    }

    @Override
    public Object visit(And filter, Object extraData) {
        this.visitLogicFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Id filter, Object extraData) {
        if (filter instanceof FidFilter) {
            this.delegate.visit((FidFilter)filter);
        }
        return extraData;
    }

    @Override
    public Object visitNullFilter(Object extraData) {
        return extraData;
    }

    @Override
    public Object visit(IncludeFilter filter, Object extraData) {
        if (this.delegate instanceof FilterVisitor2) {
            ((FilterVisitor2)this.delegate).visit(filter);
        }
        return extraData;
    }

    @Override
    public Object visit(ExcludeFilter filter, Object extraData) {
        if (this.delegate instanceof FilterVisitor2) {
            ((FilterVisitor2)this.delegate).visit(filter);
        }
        return extraData;
    }

    @Override
    public Object visit(Not filter, Object extraData) {
        this.visitLogicFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Or filter, Object extraData) {
        this.visitLogicFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsLike filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsNull filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsNil filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Beyond filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Contains filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Crosses filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Disjoint filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(DWithin filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Equals filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Intersects filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Overlaps filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Touches filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Within filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(After after, Object extraData) {
        return this.visitTemporalFilter(after);
    }

    @Override
    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visitTemporalFilter(anyInteracts);
    }

    @Override
    public Object visit(Before before, Object extraData) {
        return this.visitTemporalFilter(before);
    }

    @Override
    public Object visit(Begins begins, Object extraData) {
        return this.visitTemporalFilter(begins);
    }

    @Override
    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visitTemporalFilter(begunBy);
    }

    @Override
    public Object visit(During during, Object extraData) {
        return this.visitTemporalFilter(during);
    }

    @Override
    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visitTemporalFilter(endedBy);
    }

    @Override
    public Object visit(Ends ends, Object extraData) {
        return this.visitTemporalFilter(ends);
    }

    @Override
    public Object visit(Meets meets, Object extraData) {
        return this.visitTemporalFilter(meets);
    }

    @Override
    public Object visit(MetBy metBy, Object extraData) {
        return this.visitTemporalFilter(metBy);
    }

    @Override
    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visitTemporalFilter(overlappedBy);
    }

    @Override
    public Object visit(TContains contains, Object extraData) {
        return this.visitTemporalFilter(contains);
    }

    @Override
    public Object visit(TEquals equals, Object extraData) {
        return this.visitTemporalFilter(equals);
    }

    @Override
    public Object visit(TOverlaps contains, Object extraData) {
        return this.visitTemporalFilter(contains);
    }

    protected Object visitTemporalFilter(BinaryTemporalOperator filter) {
        throw new UnsupportedOperationException("Temporal filters not supported");
    }
}

