/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.piecewise;

import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.matrix.Matrix1;
import org.geotools.renderer.i18n.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class MathTransform1DAdapter
implements MathTransform1D {
    private static void checkDimension(DirectPosition point) {
        int dim = point.getDimension();
        if (dim != 1) {
            throw new MismatchedDimensionException(Errors.format(13, new Integer(1), new Integer(dim)));
        }
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(8, name));
        }
    }

    @Override
    public double derivative(double value) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "inverse"));
    }

    @Override
    public double transform(double value) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    @Override
    public Matrix derivative(DirectPosition point) throws MismatchedDimensionException, TransformException {
        MathTransform1DAdapter.checkDimension(point);
        return new Matrix1(this.derivative(point.getOrdinate(0)));
    }

    @Override
    public int getSourceDimensions() {
        return 1;
    }

    @Override
    public int getTargetDimensions() {
        return 1;
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        throw new UnsupportedOperationException(Errors.format(15, "inverse"));
    }

    @Override
    public boolean isIdentity() {
        throw new UnsupportedOperationException(Errors.format(15, "isIdentity"));
    }

    @Override
    public String toWKT() {
        throw new UnsupportedOperationException(Errors.format(15, "toWKT"));
    }

    @Override
    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws MismatchedDimensionException, TransformException {
        MathTransform1DAdapter.ensureNonNull("ptSrc", ptSrc);
        MathTransform1DAdapter.checkDimension(ptSrc);
        if (ptDst == null) {
            ptDst = new GeneralDirectPosition(1);
        } else {
            MathTransform1DAdapter.checkDimension(ptDst);
        }
        ptDst.setOrdinate(0, this.transform(ptSrc.getOrdinate(0)));
        return ptDst;
    }

    @Override
    public void transform(double[] arg0, int arg1, double[] arg2, int arg3, int arg4) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    @Override
    public void transform(float[] arg0, int arg1, float[] arg2, int arg3, int arg4) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    @Override
    public void transform(float[] arg0, int arg1, double[] arg2, int arg3, int arg4) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    @Override
    public void transform(double[] arg0, int arg1, float[] arg2, int arg3, int arg4) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }
}

