/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.TransverseMercator;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;

public class TransverseMercatorHandlerFactory
implements ProjectionHandlerFactory {
    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, boolean wrap) {
        MapProjection mapProjection = CRS.getMapProjection(renderingEnvelope.getCoordinateReferenceSystem());
        if (renderingEnvelope != null && mapProjection instanceof TransverseMercator) {
            double centralMeridian = mapProjection.getParameterValues().parameter(MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().getCode()).doubleValue();
            ReferencedEnvelope validArea = new ReferencedEnvelope(centralMeridian - 45.0, centralMeridian + 45.0, -90.0, 90.0, DefaultGeographicCRS.WGS84);
            return new ProjectionHandler(renderingEnvelope, validArea);
        }
        return null;
    }
}

