/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils.shape;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jaitools.imageutils.shape.AbstractLiteIterator;
import org.jaitools.imageutils.shape.GeomCollectionIterator;
import org.jaitools.imageutils.shape.LineIterator;
import org.jaitools.imageutils.shape.PointIterator;
import org.jaitools.imageutils.shape.PolygonIterator;

public class LiteShape
implements Shape,
Cloneable {
    private Geometry geometry;

    public LiteShape(Geometry geom) {
        if (geom != null) {
            this.geometry = (Geometry)geom.clone();
        }
    }

    public void setGeometry(Geometry g) {
        this.geometry = (Geometry)g.clone();
    }

    public boolean contains(Rectangle2D r) {
        Geometry rect = this.rectangleToGeometry(r);
        return this.geometry.contains(rect);
    }

    public boolean contains(Point2D p) {
        Coordinate coord = new Coordinate(p.getX(), p.getY());
        Point point = this.geometry.getFactory().createPoint(coord);
        return this.geometry.contains(point);
    }

    public boolean contains(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        Point point = this.geometry.getFactory().createPoint(coord);
        return this.geometry.contains(point);
    }

    public boolean contains(double x, double y, double w, double h) {
        Geometry rect = this.createRectangle(x, y, w, h);
        return this.geometry.contains(rect);
    }

    public Rectangle getBounds() {
        Envelope env = this.geometry.getEnvelopeInternal();
        int x = (int)Math.floor(env.getMinX());
        int y = (int)Math.floor(env.getMinY());
        int w = (int)Math.ceil(env.getMaxX()) - x;
        int h = (int)Math.ceil(env.getMaxY()) - y;
        return new Rectangle(x, y, w, h);
    }

    public Rectangle2D getBounds2D() {
        Envelope env = this.geometry.getEnvelopeInternal();
        return new Rectangle2D.Double(env.getMinX(), env.getMinY(), env.getWidth(), env.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        AbstractLiteIterator pi = null;
        AffineTransform combined = at;
        if (this.geometry instanceof Point) {
            pi = new PointIterator((Point)this.geometry, combined);
        }
        if (this.geometry instanceof Polygon) {
            pi = new PolygonIterator((Polygon)this.geometry, combined);
        } else if (this.geometry instanceof LinearRing) {
            pi = new LineIterator((LinearRing)this.geometry, combined);
        } else if (this.geometry instanceof LineString) {
            pi = new LineIterator((LineString)this.geometry, combined);
        } else if (this.geometry instanceof GeometryCollection) {
            pi = new GeomCollectionIterator((GeometryCollection)this.geometry, combined);
        }
        return pi;
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public boolean intersects(Rectangle2D r) {
        Geometry rect = this.rectangleToGeometry(r);
        return this.geometry.intersects(rect);
    }

    public boolean intersects(double x, double y, double w, double h) {
        Geometry rect = this.createRectangle(x, y, w, h);
        return this.geometry.intersects(rect);
    }

    private Geometry rectangleToGeometry(Rectangle2D r) {
        return this.createRectangle(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    private Geometry createRectangle(double x, double y, double w, double h) {
        Coordinate[] coords = new Coordinate[]{new Coordinate(x, y), new Coordinate(x, y + h), new Coordinate(x + w, y + h), new Coordinate(x + w, y), new Coordinate(x, y)};
        LinearRing lr = this.geometry.getFactory().createLinearRing(coords);
        return this.geometry.getFactory().createPolygon(lr, null);
    }

    public Geometry getGeometry() {
        return this.geometry;
    }
}

