/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPTableEvent;
import java.util.ArrayList;
import java.util.List;
import org.mapfish.print.PDFCustomBlocks;

public abstract class ChunkDrawer
implements PdfPTableEvent {
    private final List<PDFCustomBlocks.AbsoluteDrawer> others = new ArrayList<PDFCustomBlocks.AbsoluteDrawer>();
    private final PDFCustomBlocks customBlocks;

    public ChunkDrawer(PDFCustomBlocks customBlocks) {
        this.customBlocks = customBlocks;
    }

    @Override
    public void tableLayout(PdfPTable table, float[][] widths, float[] heights, int headerRows, int rowStart, PdfContentByte[] canvases) {
        PdfContentByte dc = canvases[2];
        Rectangle rect = new Rectangle(widths[0][0], heights[1], widths[0][1], heights[0]);
        this.render(rect, dc);
    }

    public final void render(Rectangle rectangle, PdfContentByte dc) {
        this.customBlocks.blockRendered(this);
        this.renderImpl(rectangle, dc);
        for (int i = 0; i < this.others.size(); ++i) {
            PDFCustomBlocks.AbsoluteDrawer absoluteDrawer = this.others.get(i);
            try {
                absoluteDrawer.render(dc);
                continue;
            }
            catch (DocumentException e) {
                this.customBlocks.addError(e);
            }
        }
    }

    public abstract void renderImpl(Rectangle var1, PdfContentByte var2);

    public void addAbsoluteDrawer(PDFCustomBlocks.AbsoluteDrawer chunkDrawer) {
        this.others.add(chunkDrawer);
    }
}

