/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class TimeLogger {
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
    private final Logger logger;
    private final int level;
    private final String task;
    private long start;

    private static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    private TimeLogger(Logger logger, int level, String task) {
        this.logger = logger;
        this.level = level;
        this.task = task;
        this.log("Starting '" + task + "' at " + TimeLogger.now());
        this.start = System.currentTimeMillis();
    }

    private void log(String s) {
        switch (this.level) {
            case 10000: {
                this.logger.debug(s);
                break;
            }
            case 40000: {
                this.logger.error(s);
                break;
            }
            case 20000: {
                this.logger.info(s);
                break;
            }
            case 50000: {
                this.logger.fatal(s);
                break;
            }
            case 30000: {
                this.logger.warn(s);
                break;
            }
            default: {
                this.logger.info(s);
            }
        }
    }

    public void done() {
        long time = System.currentTimeMillis() - this.start;
        this.log("Finished '" + this.task + "' after " + time + " ms");
    }

    public static TimeLogger info(Logger logger, String task) {
        return new TimeLogger(logger, 20000, task);
    }

    public static TimeLogger debug(Logger logger, String task) {
        return new TimeLogger(logger, 10000, task);
    }
}

