/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;

public class TotalPageNum {
    private static final String SAMPLE_VALUE = "999";
    private PdfTemplate totalPageNum;
    private final BaseFont totalPageNumFont;
    private final float totalPageNumFontSize;
    private PdfContentByte dc;

    public TotalPageNum(PdfWriter writer, Font font) {
        this.dc = writer.getDirectContent();
        this.totalPageNumFont = font.getCalculatedBaseFont(false);
        this.totalPageNumFontSize = font.getSize();
    }

    public Chunk createPlaceHolder() throws BadElementException {
        float width = this.totalPageNumFont.getWidthPoint(SAMPLE_VALUE, this.totalPageNumFontSize);
        float height = this.totalPageNumFont.getAscentPoint(SAMPLE_VALUE, this.totalPageNumFontSize) - this.totalPageNumFont.getDescentPoint(SAMPLE_VALUE, this.totalPageNumFontSize);
        if (this.totalPageNum == null) {
            this.totalPageNum = this.dc.createTemplate(width, height);
        }
        Image image = Image.getInstance(this.totalPageNum);
        return new Chunk(image, 0.0f, 0.0f, true);
    }

    public void render(PdfWriter writer) {
        this.totalPageNum.beginText();
        this.totalPageNum.setFontAndSize(this.totalPageNumFont, this.totalPageNumFontSize);
        this.totalPageNum.setTextMatrix(0.0f, 0.0f);
        this.totalPageNum.showText(String.valueOf(writer.getPageNumber() - 1));
        this.totalPageNum.endText();
    }
}

