/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.annotation;

import java.util.Collection;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Configuration
public abstract class AbstractCachingConfiguration
implements ImportAware {
    protected Map<String, Object> enableCaching;
    protected CacheManager cacheManager;
    protected KeyGenerator keyGenerator;
    @Autowired(required=false)
    private Collection<CacheManager> cacheManagerBeans;
    @Autowired(required=false)
    private Collection<CachingConfigurer> cachingConfigurers;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableCaching = importMetadata.getAnnotationAttributes(EnableCaching.class.getName(), false);
        Assert.notNull(this.enableCaching, "@EnableCaching is not present on importing class " + importMetadata.getClassName());
    }

    @PostConstruct
    protected void reconcileCacheManager() {
        if (!CollectionUtils.isEmpty(this.cachingConfigurers)) {
            int nConfigurers = this.cachingConfigurers.size();
            if (nConfigurers > 1) {
                throw new IllegalStateException(String.valueOf(nConfigurers) + " implementations of " + "CachingConfigurer were found when only 1 was expected. " + "Refactor the configuration such that CachingConfigurer is " + "implemented only once or not at all.");
            }
            CachingConfigurer cachingConfigurer = this.cachingConfigurers.iterator().next();
            this.cacheManager = cachingConfigurer.cacheManager();
            this.keyGenerator = cachingConfigurer.keyGenerator();
        } else if (!CollectionUtils.isEmpty(this.cacheManagerBeans)) {
            CacheManager cacheManager;
            int nManagers = this.cacheManagerBeans.size();
            if (nManagers > 1) {
                throw new IllegalStateException(String.valueOf(nManagers) + " beans of type CacheManager " + "were found when only 1 was expected. Remove all but one of the " + "CacheManager bean definitions, or implement CachingConfigurer " + "to make explicit which CacheManager should be used for " + "annotation-driven cache management.");
            }
            this.cacheManager = cacheManager = this.cacheManagerBeans.iterator().next();
        } else {
            throw new IllegalStateException("No bean of type CacheManager could be found. Register a CacheManager bean or remove the @EnableCaching annotation from your configuration.");
        }
    }
}

