/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.filter.spatial.AbstractPreparedGeometryFilter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Within;

public class WithinImpl
extends AbstractPreparedGeometryFilter
implements Within {
    public WithinImpl(FilterFactory factory, Expression e1, Expression e2) {
        super(factory, e1, e2);
        this.filterType = (short)10;
    }

    public WithinImpl(FilterFactory factory, Expression e1, Expression e2, MultiValuedFilter.MatchAction matchAction) {
        super(factory, e1, e2, matchAction);
        this.filterType = (short)10;
    }

    @Override
    public boolean evaluateInternal(Geometry left, Geometry right) {
        switch (this.literals) {
            case BOTH: {
                return this.cacheValue;
            }
            case RIGHT: {
                return this.rightPreppedGeom.contains(left);
            }
            case LEFT: {
                return this.basicEvaluate(this.leftPreppedGeom.getGeometry(), right);
            }
        }
        return this.basicEvaluate(left, right);
    }

    @Override
    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }

    @Override
    protected boolean basicEvaluate(Geometry left, Geometry right) {
        Envelope envLeft = left.getEnvelopeInternal();
        Envelope envRight = right.getEnvelopeInternal();
        if (envRight.contains(envLeft)) {
            return left.within(right);
        }
        return false;
    }
}

