/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import org.geotools.metadata.ModifiableMetadata;
import org.geotools.metadata.UnmodifiableMetadataException;
import org.geotools.resources.Classes;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CheckedCollection;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.annotation.UML;
import org.opengis.util.InternationalString;

final class PropertyAccessor {
    private static final Locale LOCALE = Locale.US;
    private static final String IS = "is";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String[] EXCLUDES = new String[]{"clone", "finalize", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait"};
    private static final Map<Class<?>, Method[]> SHARED_GETTERS = new HashMap();
    final Class<?> type;
    final Class<?> implementation;
    private final Method[] getters;
    private final Method[] setters;
    private final Map<String, Integer> mapping;

    PropertyAccessor(Class<?> implementation, Class<?> type) {
        this.implementation = implementation;
        this.type = type;
        assert (type.isAssignableFrom(implementation)) : implementation;
        this.getters = PropertyAccessor.getGetters(type);
        this.mapping = new HashMap<String, Integer>(this.getters.length + (this.getters.length + 3) / 4);
        Method[] setters = null;
        Class[] arguments = new Class[1];
        for (int i = 0; i < this.getters.length; ++i) {
            Method setter;
            Class<?> returnType2;
            Integer index = i;
            Method getter = this.getters[i];
            String name = getter.getName();
            int base = PropertyAccessor.prefix(name).length();
            this.addMapping(name.substring(base), index);
            UML annotation = getter.getAnnotation(UML.class);
            if (annotation != null) {
                this.addMapping(annotation.identifier(), index);
            }
            arguments[0] = returnType2 = getter.getReturnType();
            if (name.length() > base) {
                char up;
                char lo = name.charAt(base);
                name = lo != (up = Character.toUpperCase(lo)) ? SET + up + name.substring(base + 1) : SET + name.substring(base);
            }
            try {
                setter = implementation.getMethod(name, arguments);
            }
            catch (NoSuchMethodException e) {
                try {
                    getter = implementation.getMethod(getter.getName(), null);
                }
                catch (NoSuchMethodException error) {
                    throw new AssertionError((Object)error);
                }
                Class<?> clazz = returnType2;
                returnType2 = getter.getReturnType();
                if (clazz.equals(returnType2)) continue;
                arguments[0] = returnType2;
                try {
                    setter = implementation.getMethod(name, arguments);
                }
                catch (NoSuchMethodException ignore) {
                    continue;
                }
            }
            if (setters == null) {
                setters = new Method[this.getters.length];
            }
            setters[i] = setter;
        }
        this.setters = setters;
    }

    private void addMapping(String name, Integer index) throws IllegalArgumentException {
        String lower;
        Integer old;
        if ((name = name.trim()).length() != 0 && (old = this.mapping.put(lower = name.toLowerCase(LOCALE), index)) != null && !old.equals(index)) {
            throw new IllegalArgumentException(Errors.format(154, name, index, lower, old));
        }
    }

    static Class<?> getType(Class<?> implementation, String interfacePackage) {
        if (implementation != null && !implementation.isInterface()) {
            Class candidate;
            LinkedHashSet interfaces = new LinkedHashSet();
            do {
                PropertyAccessor.getInterfaces(implementation, interfacePackage, interfaces);
            } while ((implementation = implementation.getSuperclass()) != null);
            Iterator it = interfaces.iterator();
            block1: while (it.hasNext()) {
                candidate = (Class)it.next();
                for (Class clazz : interfaces) {
                    if (candidate == clazz || !candidate.isAssignableFrom(clazz)) continue;
                    it.remove();
                    continue block1;
                }
            }
            it = interfaces.iterator();
            if (it.hasNext()) {
                candidate = (Class)it.next();
                if (!it.hasNext()) {
                    return candidate;
                }
            }
        }
        return null;
    }

    private static void getInterfaces(Class<?> type, String interfacePackage, Collection<Class<?>> interfaces) {
        for (Class<?> candidate : type.getInterfaces()) {
            if (candidate.getName().startsWith(interfacePackage)) {
                interfaces.add(candidate);
            }
            PropertyAccessor.getInterfaces(candidate, interfacePackage, interfaces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method[] getGetters(Class<?> type) {
        Map<Class<?>, Method[]> map = SHARED_GETTERS;
        synchronized (map) {
            Method[] getters = SHARED_GETTERS.get(type);
            if (getters == null) {
                getters = type.getMethods();
                int count = 0;
                for (int i = 0; i < getters.length; ++i) {
                    String name;
                    Method candidate = getters[i];
                    if (candidate.getAnnotation(Deprecated.class) != null || candidate.getReturnType().equals(Void.TYPE) || candidate.getParameterTypes().length != 0 || (name = candidate.getName()).startsWith(SET) || PropertyAccessor.isExcluded(name)) continue;
                    getters[count++] = candidate;
                }
                getters = XArray.resize(getters, count);
                SHARED_GETTERS.put(type, getters);
            }
            return getters;
        }
    }

    private static boolean isExcluded(String name) {
        for (int i = 0; i < EXCLUDES.length; ++i) {
            if (!name.equals(EXCLUDES[i])) continue;
            return true;
        }
        return false;
    }

    private static String prefix(String name) {
        if (name.startsWith(GET)) {
            return GET;
        }
        if (name.startsWith(IS)) {
            return IS;
        }
        if (name.startsWith(SET)) {
            return SET;
        }
        return "";
    }

    final int count() {
        return this.getters.length;
    }

    final int indexOf(String key) {
        Integer index = this.mapping.get(key = key.trim().toLowerCase(LOCALE));
        return index != null ? index : -1;
    }

    final int requiredIndexOf(String key) throws IllegalArgumentException {
        Integer index = this.mapping.get((key = key.trim()).toLowerCase(LOCALE));
        if (index != null) {
            return index;
        }
        throw new IllegalArgumentException(Errors.format(185, key));
    }

    private static boolean isAcronym(String name, int offset) {
        int length = name.length();
        while (offset < length) {
            if (!Character.isLowerCase(name.charAt(offset++))) continue;
            return false;
        }
        return true;
    }

    final String name(int index) {
        if (index >= 0 && index < this.getters.length) {
            String name = this.getters[index].getName();
            int base = PropertyAccessor.prefix(name).length();
            if (name.length() > base) {
                char lo;
                char up;
                name = PropertyAccessor.isAcronym(name, base) ? name.substring(base) : ((up = name.charAt(base)) != (lo = Character.toLowerCase(up)) ? lo + name.substring(base + 1) : name.substring(base));
            }
            return name;
        }
        return null;
    }

    final Class<?> type(int index) {
        if (index >= 0 && index < this.getters.length) {
            return this.getters[index].getReturnType();
        }
        return null;
    }

    final boolean isWritable(int index) {
        return index >= 0 && index < this.getters.length && this.setters != null && this.setters[index] != null;
    }

    final Object get(int index, Object metadata) {
        return index >= 0 && index < this.getters.length ? PropertyAccessor.get(this.getters[index], metadata) : null;
    }

    private static Object get(Method method, Object metadata) {
        assert (!method.getReturnType().equals(Void.TYPE)) : method;
        try {
            return method.invoke(metadata, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    final Object set(int index, Object metadata, Object value) throws IllegalArgumentException, ClassCastException {
        String key;
        if (index >= 0 && index < this.getters.length && this.setters != null) {
            Method getter = this.getters[index];
            Method setter = this.setters[index];
            if (setter != null) {
                Object old = PropertyAccessor.get(getter, metadata);
                PropertyAccessor.set(getter, setter, metadata, new Object[]{value});
                return old;
            }
            key = getter.getName();
            key = key.substring(PropertyAccessor.prefix(key).length());
        } else {
            key = String.valueOf(index);
        }
        throw new IllegalArgumentException(Errors.format(57, key));
    }

    private static void set(Method getter, Method setter, Object metadata, Object[] arguments) throws ClassCastException {
        Class<?>[] paramTypes = setter.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<Object> elementType;
            Collection addTo;
            Class<?> paramType;
            Object argument = arguments[i];
            if (argument == null || Classes.primitiveToWrapper(paramType = paramTypes[i]).isInstance(argument)) continue;
            if (Collection.class.isAssignableFrom(paramType) && !(argument instanceof Collection)) {
                addTo = (Collection)PropertyAccessor.get(getter, metadata);
                if (addTo instanceof CheckedCollection) {
                    elementType = ((CheckedCollection)addTo).getElementType();
                } else {
                    Class<Object> c = Classes.boundOfParameterizedAttribute(setter);
                    if (c == null && (c = Classes.boundOfParameterizedAttribute(getter)) == null) {
                        c = Object.class;
                    }
                    elementType = c;
                }
            } else {
                addTo = null;
                elementType = paramType;
            }
            Object parsed = null;
            Exception failure = null;
            if (elementType.isInstance(argument)) {
                parsed = argument;
            } else if (argument instanceof CharSequence) {
                String text = argument.toString();
                if (InternationalString.class.isAssignableFrom(elementType)) {
                    parsed = new SimpleInternationalString(text);
                } else if (File.class.isAssignableFrom(elementType)) {
                    parsed = new File(text);
                } else if (URL.class.isAssignableFrom(elementType)) {
                    try {
                        parsed = new URL(text);
                    }
                    catch (MalformedURLException e) {
                        failure = e;
                    }
                } else if (URI.class.isAssignableFrom(elementType)) {
                    try {
                        parsed = new URI(text);
                    }
                    catch (URISyntaxException e) {
                        failure = e;
                    }
                } else {
                    try {
                        parsed = Classes.valueOf(elementType, text);
                    }
                    catch (RuntimeException e) {
                        failure = e;
                    }
                }
            }
            if (parsed == null) {
                ClassCastException e = new ClassCastException(Errors.format(61, argument.getClass(), elementType));
                e.initCause(failure);
                throw e;
            }
            if (addTo != null) {
                PropertyAccessor.addUnsafe(addTo, parsed);
                parsed = addTo;
            }
            arguments[i] = parsed;
        }
        try {
            setter.invoke(metadata, arguments);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    private static void addUnsafe(Collection<?> addTo, Object element) {
        addTo.add(element);
    }

    public boolean shallowEquals(Object metadata1, Object metadata2, boolean skipNulls) {
        assert (this.type.isInstance(metadata1)) : metadata1;
        assert (this.type.isInstance(metadata2)) : metadata2;
        for (int i = 0; i < this.getters.length; ++i) {
            Method method = this.getters[i];
            Object value1 = PropertyAccessor.get(method, metadata1);
            Object value2 = PropertyAccessor.get(method, metadata2);
            boolean empty1 = PropertyAccessor.isEmpty(value1);
            boolean empty2 = PropertyAccessor.isEmpty(value2);
            if (empty1 && empty2 || Utilities.equals(value1, value2) || skipNulls && (empty1 || empty2)) continue;
            return false;
        }
        return true;
    }

    public boolean shallowCopy(Object source, Object target, boolean skipNulls) throws UnmodifiableMetadataException {
        boolean success = true;
        assert (this.type.isInstance(source)) : source;
        assert (this.implementation.isInstance(target)) : target;
        Object[] arguments = new Object[1];
        for (int i = 0; i < this.getters.length; ++i) {
            Method getter = this.getters[i];
            arguments[0] = PropertyAccessor.get(getter, source);
            if (skipNulls && PropertyAccessor.isEmpty(arguments[0])) continue;
            if (this.setters == null) {
                return false;
            }
            Method setter = this.setters[i];
            if (setter != null) {
                PropertyAccessor.set(getter, setter, target, arguments);
                continue;
            }
            success = false;
        }
        return success;
    }

    final void freeze(Object metadata) {
        assert (this.implementation.isInstance(metadata)) : metadata;
        if (this.setters != null) {
            Object[] arguments = new Object[1];
            for (int i = 0; i < this.getters.length; ++i) {
                Object target;
                Method getter;
                Object source;
                Method setter = this.setters[i];
                if (setter == null || (source = PropertyAccessor.get(getter = this.getters[i], metadata)) == (target = ModifiableMetadata.unmodifiable(source))) continue;
                arguments[0] = target;
                PropertyAccessor.set(getter, setter, metadata, arguments);
            }
        }
    }

    final boolean isModifiable() {
        if (this.setters != null) {
            return true;
        }
        for (int i = 0; i < this.getters.length; ++i) {
            if (!Cloneable.class.isAssignableFrom(this.getters[i].getReturnType())) continue;
            return true;
        }
        return false;
    }

    public int hashCode(Object metadata) {
        assert (this.type.isInstance(metadata)) : metadata;
        int code = 0;
        for (int i = 0; i < this.getters.length; ++i) {
            Object value = PropertyAccessor.get(this.getters[i], metadata);
            if (PropertyAccessor.isEmpty(value)) continue;
            code += value.hashCode();
        }
        return code;
    }

    public int count(Object metadata, int max) {
        assert (this.type.isInstance(metadata)) : metadata;
        int count = 0;
        for (int i = 0; i < this.getters.length && (PropertyAccessor.isEmpty(PropertyAccessor.get(this.getters[i], metadata)) || ++count < max); ++i) {
        }
        return count;
    }

    static boolean isEmpty(Object value) {
        return value == null || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof CharSequence && value.toString().trim().length() == 0 || value.getClass().isArray() && Array.getLength(value) == 0;
    }
}

