/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.util.logging.Level;
import org.apache.commons.logging.Log;
import org.geotools.util.logging.LoggerAdapter;

final class CommonsLogger
extends LoggerAdapter {
    final Log logger;

    public CommonsLogger(String name, Log logger) {
        super(name);
        this.logger = logger;
    }

    @Override
    public void setLevel(Level level) {
    }

    @Override
    public Level getLevel() {
        if (this.logger.isTraceEnabled()) {
            return Level.FINEST;
        }
        if (this.logger.isDebugEnabled()) {
            return Level.FINE;
        }
        if (this.logger.isInfoEnabled()) {
            return Level.CONFIG;
        }
        if (this.logger.isWarnEnabled()) {
            return Level.WARNING;
        }
        if (this.logger.isErrorEnabled()) {
            return Level.SEVERE;
        }
        if (this.logger.isFatalEnabled()) {
            return Level.SEVERE;
        }
        return Level.OFF;
    }

    @Override
    public boolean isLoggable(Level level) {
        int n = level.intValue();
        switch (n / 100) {
            default: {
                switch (n) {
                    case -2147483648: {
                        return true;
                    }
                    case 0x7FFFFFFF: {
                        return false;
                    }
                }
                return n >= 0 && this.logger.isFatalEnabled();
            }
            case 10: {
                return this.logger.isErrorEnabled();
            }
            case 9: {
                return this.logger.isWarnEnabled();
            }
            case 7: 
            case 8: {
                return this.logger.isInfoEnabled();
            }
            case 5: 
            case 6: {
                return this.logger.isDebugEnabled();
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
        }
        return this.logger.isTraceEnabled();
    }

    @Override
    public void log(Level level, String message, Throwable thrown) {
        int n = level.intValue();
        switch (n / 100) {
            default: {
                if (n == Integer.MAX_VALUE && n < 0) break;
                this.logger.fatal(message, thrown);
                break;
            }
            case 10: {
                this.logger.error(message, thrown);
                break;
            }
            case 9: {
                this.logger.warn(message, thrown);
                break;
            }
            case 7: 
            case 8: {
                this.logger.info(message, thrown);
                break;
            }
            case 5: 
            case 6: {
                this.logger.debug(message, thrown);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.logger.trace(message, thrown);
            }
        }
    }

    @Override
    public void severe(String message) {
        this.logger.error(message);
    }

    @Override
    public void warning(String message) {
        this.logger.warn(message);
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
    }

    @Override
    public void config(String message) {
        this.logger.info(message);
    }

    @Override
    public void fine(String message) {
        this.logger.debug(message);
    }

    @Override
    public void finer(String message) {
        this.logger.debug(message);
    }

    @Override
    public void finest(String message) {
        this.logger.trace(message);
    }
}

