/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.exception.PropertyAccessException;
import org.ho.yaml.wrapper.DefaultBeanWrapper;

public class CustomBeanWrapper
extends DefaultBeanWrapper {
    public static final Logger LOGGER = Logger.getLogger(CustomBeanWrapper.class);

    public CustomBeanWrapper(Class<?> type) {
        super(type);
    }

    @Override
    public void setProperty(String name, Object value) throws PropertyAccessException {
        try {
            PropertyDescriptor prop = ReflectionUtil.getPropertyDescriptor(this.type, name);
            if (prop == null) {
                LOGGER.warn(this.type.getSimpleName() + ": unknown field '" + name + "' with value '" + value + "'");
                ReflectionUtil.getPropertyDescriptor(this.type, name);
                return;
            }
            if (this.config.isPropertyAccessibleForDecoding(prop)) {
                Method wm = prop.getWriteMethod();
                wm.setAccessible(true);
                wm.invoke(this.getObject(), value);
            }
        }
        catch (Exception e) {
            LOGGER.warn(this.type.getSimpleName() + ": Error while writing '" + value + "' to " + name + ": " + e);
        }
    }
}

