/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml.wrapper;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.exception.YamlException;
import org.ho.yaml.wrapper.AbstractWrapper;
import org.ho.yaml.wrapper.CollectionWrapper;

public class ArrayWrapper
extends AbstractWrapper
implements CollectionWrapper {
    ArrayList list = new ArrayList();

    public ArrayWrapper(Class clazz) {
        super(clazz);
        assert (clazz.isArray());
    }

    public Object createPrototype() {
        throw new UnsupportedOperationException("createPrototype not supported.");
    }

    public void add(Object object) {
        this.list.add(object);
    }

    public void add(int n, Object object) {
        this.list.add(n, object);
    }

    public boolean isTyped() {
        return true;
    }

    public Class componentType() {
        return this.type.getComponentType();
    }

    protected Object createObject() {
        String string = ReflectionUtil.arrayComponentName(ReflectionUtil.className(this.getType()));
        Class clazz = ReflectionUtil.classForName(string);
        if (clazz == null) {
            throw new YamlException("class " + string + " cannot be resolved.");
        }
        Object object = Array.newInstance(clazz, this.list.size());
        for (int i = 0; i < Array.getLength(object); ++i) {
            try {
                Array.set(object, i, this.list.get(i));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new YamlException("Fail to set " + this.list.get(i) + " into array of type " + string);
            }
        }
        return object;
    }

    protected void fireCreated() {
        this.list = this.toList(this.object);
        super.fireCreated();
    }

    ArrayList toList(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(Array.getLength(object));
        for (int i = 0; i < Array.getLength(object); ++i) {
            arrayList.add(Array.get(object, i));
        }
        return arrayList;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isOrdered() {
        return true;
    }

    public Iterator iterator() {
        return this.list.iterator();
    }
}

