/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mapfish.print.ChunkDrawer;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.TotalPageNum;
import org.mapfish.print.config.layout.HeaderFooter;
import org.mapfish.print.utils.PJsonObject;

public class PDFCustomBlocks
extends PdfPageEventHelper {
    public static final Logger LOGGER = Logger.getLogger(PDFCustomBlocks.class);
    private ChunkDrawer last = null;
    private final PdfWriter writer;
    private final RenderingContext context;
    private HeaderFooter header;
    private PJsonObject headerParams;
    private HeaderFooter footer;
    private PJsonObject footerParams;
    private String backgroundPdf;
    private final List<Exception> errors = Collections.synchronizedList(new ArrayList());
    private final List<PdfReader> readers;
    private final Map<String, PdfImportedPage> backgroundPdfs = new HashMap<String, PdfImportedPage>();
    private TotalPageNum totalPageNum = null;

    public PDFCustomBlocks(PdfWriter writer, RenderingContext context) {
        this.writer = writer;
        this.context = context;
        writer.setPageEvent(this);
        this.readers = new ArrayList<PdfReader>();
    }

    @Override
    public void onStartPage(PdfWriter writer, Document document) {
        super.onStartPage(writer, document);
        PdfContentByte dc = writer.getDirectContent();
        this.addBackground(writer, document, dc);
    }

    @Override
    public void onEndPage(PdfWriter writer, Document document) {
        PdfContentByte dc = writer.getDirectContent();
        this.addHeader(document, dc);
        this.addFooter(document, dc);
        this.addErrors(writer);
        super.onEndPage(writer, document);
    }

    @Override
    public void onCloseDocument(PdfWriter writer, Document document) {
        if (this.totalPageNum != null) {
            this.totalPageNum.render(writer);
        }
        super.onCloseDocument(writer, document);
    }

    private void addBackground(PdfWriter writer, Document document, PdfContentByte dc) {
        if (this.backgroundPdf != null) {
            try {
                PdfImportedPage page = this.backgroundPdfs.get(this.backgroundPdf);
                if (page == null) {
                    PdfReader reader = new PdfReader(this.backgroundPdf);
                    this.readers.add(reader);
                    page = writer.getImportedPage(reader, 1);
                    this.backgroundPdfs.put(this.backgroundPdf, page);
                }
                Rectangle pageSize = document.getPageSize();
                boolean rotate = page.getWidth() < page.getHeight() ^ pageSize.getWidth() < pageSize.getHeight();
                if (rotate) {
                    dc.addTemplate(page, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, pageSize.getHeight());
                } else {
                    dc.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                }
            }
            catch (IOException e) {
                this.addError(e);
            }
        }
    }

    private void addHeader(Document document, PdfContentByte dc) {
        if (this.header != null) {
            Rectangle rectangle = new Rectangle(document.left(), document.top(), document.right(), document.top() + (float)this.header.getHeight());
            this.header.render(rectangle, dc, this.headerParams, this.context);
        }
    }

    private void addFooter(Document document, PdfContentByte dc) {
        if (this.footer != null) {
            Rectangle rectangle = new Rectangle(document.left(), document.bottom() - (float)this.footer.getHeight(), document.right(), document.bottom());
            this.footer.render(rectangle, dc, this.footerParams, this.context);
        }
    }

    private void addErrors(PdfWriter writer) {
        if (this.errors.size() > 0) {
            StringBuilder errorTxt = new StringBuilder();
            for (int i = 0; i < this.errors.size(); ++i) {
                Exception exception = this.errors.get(i);
                errorTxt.append(exception).append("\n");
            }
            this.errors.clear();
            Rectangle rect = new Rectangle(20.0f, 40.0f, 40.0f, 60.0f);
            PdfAnnotation annotation = PdfAnnotation.createText(writer, rect, "Error", errorTxt.toString(), false, "Note");
            writer.addAnnotation(annotation);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Added an annotation for errors");
            }
        }
    }

    public void addChunkDrawer(ChunkDrawer chunkDrawer) {
        this.last = chunkDrawer;
    }

    public void blockRendered(ChunkDrawer chunkDrawer) {
        if (this.last == chunkDrawer) {
            this.last = null;
        }
    }

    public void addAbsoluteDrawer(AbsoluteDrawer chunkDrawer) throws DocumentException {
        if (this.last != null) {
            this.last.addAbsoluteDrawer(chunkDrawer);
        } else {
            chunkDrawer.render(this.writer.getDirectContent());
        }
    }

    public void setHeader(HeaderFooter header, PJsonObject params) {
        this.header = header;
        this.headerParams = params;
    }

    public void setFooter(HeaderFooter footer, PJsonObject params) {
        this.footer = footer;
        this.footerParams = params;
    }

    public void setBackgroundPdf(String backgroundPdf) {
        this.backgroundPdf = backgroundPdf;
    }

    public void addError(Exception e) {
        this.errors.add(e);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.error("Error while adding a PDF element", e);
        } else {
            LOGGER.error("Error while adding a PDF element" + e.toString());
        }
    }

    public Chunk getOrCreateTotalPagesBlock(Font font) throws BadElementException {
        if (this.totalPageNum == null) {
            this.totalPageNum = new TotalPageNum(this.writer, font);
        }
        return this.totalPageNum.createPlaceHolder();
    }

    public void closeReaders() {
        for (int i = 0; i < this.readers.size(); ++i) {
            try {
                this.readers.get(i).close();
                continue;
            }
            catch (Exception e) {
                this.context.addError(e);
            }
        }
    }

    public static abstract class AbsoluteDrawer {
        public abstract void render(PdfContentByte var1) throws DocumentException;
    }
}

