/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.ho.yaml.CustomYamlConfig;
import org.ho.yaml.YamlConfig;
import org.mapfish.print.ThreadResources;
import org.mapfish.print.config.Config;
import org.mapfish.print.map.readers.MapReaderFactoryFinder;
import org.mapfish.print.output.OutputFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigFactory {
    @Autowired
    private OutputFactory outputFactoryFinder;
    @Autowired
    private MapReaderFactoryFinder mapReaderFactoryFinder;
    @Autowired
    private ThreadResources threadResources;
    @Autowired
    private MetricRegistry metricRegistry;

    public ConfigFactory() {
    }

    public ConfigFactory(ThreadResources threadResources) {
        this.threadResources = threadResources;
    }

    public Config fromYaml(File file) throws FileNotFoundException {
        CustomYamlConfig config = new CustomYamlConfig();
        Config result = ((YamlConfig)config).loadType(file, Config.class);
        result.setOutputFactory(this.outputFactoryFinder);
        result.setMapReaderFactoryFinder(this.mapReaderFactoryFinder);
        result.setThreadResources(this.threadResources);
        result.setMetricRegistry(this.metricRegistry);
        result.validate();
        return result;
    }

    public Config fromInputStream(InputStream instream) {
        CustomYamlConfig config = new CustomYamlConfig();
        Config result = config.loadType(instream, Config.class);
        result.setOutputFactory(this.outputFactoryFinder);
        result.setMapReaderFactoryFinder(this.mapReaderFactoryFinder);
        result.setThreadResources(this.threadResources);
        result.setMetricRegistry(this.metricRegistry);
        result.validate();
        return result;
    }

    public Config fromString(String strConfig) {
        CustomYamlConfig config = new CustomYamlConfig();
        Config result = config.loadType(strConfig, Config.class);
        result.setOutputFactory(this.outputFactoryFinder);
        result.setMapReaderFactoryFinder(this.mapReaderFactoryFinder);
        result.setThreadResources(this.threadResources);
        result.setMetricRegistry(this.metricRegistry);
        result.validate();
        return result;
    }
}

