/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import org.json.JSONException;
import org.json.JSONWriter;
import org.mapfish.print.InvalidJsonValueException;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFCustomBlocks;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.map.MapChunkDrawer;
import org.mapfish.print.utils.DistanceUnit;
import org.mapfish.print.utils.Maps;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class MapBlock
extends Block {
    private String height = null;
    private String width = null;
    private String absoluteX = null;
    private String absoluteY = null;
    private double overviewMap = Double.NaN;
    private String name = null;

    @Override
    public void render(PJsonObject params, Block.PdfElement target, RenderingContext context) throws DocumentException {
        final Transformer transformer = this.createTransformer(context, params);
        final MapChunkDrawer drawer = new MapChunkDrawer(context.getCustomBlocks(), transformer, this.overviewMap, params, context, this.getBackgroundColorVal(context, params), this.name);
        PJsonObject mapParams = Maps.getMapRoot(params, this.name);
        if (this.isAbsolute()) {
            final float absX = this.getAbsoluteX(context, mapParams);
            final float absY = this.getAbsoluteY(context, mapParams);
            context.getCustomBlocks().addAbsoluteDrawer(new PDFCustomBlocks.AbsoluteDrawer(){

                @Override
                public void render(PdfContentByte dc) {
                    Rectangle rectangle = new Rectangle(absX, absY - transformer.getPaperH(), absX + transformer.getPaperW(), absY);
                    drawer.render(rectangle, dc);
                }
            });
        } else {
            target.add(PDFUtils.createPlaceholderTable(transformer.getPaperW(), transformer.getPaperH(), this.spacingAfter, drawer, this.align, context.getCustomBlocks()));
        }
    }

    public Transformer createTransformer(RenderingContext context, PJsonObject params) {
        double centerY;
        double centerX;
        double scale;
        DistanceUnit unitEnum;
        params = Maps.getMapRoot(params, this.name);
        boolean strictEpsg4326 = params.optBool("strictEpsg4326", false);
        Integer dpi = params.optInt("dpi");
        if (dpi == null) {
            dpi = context.getGlobalParams().getInt("dpi");
        }
        if (!context.getConfig().getDpis().contains(dpi)) {
            throw new InvalidJsonValueException(params, "dpi", dpi);
        }
        String units = params.optString("units");
        if (units == null) {
            units = context.getGlobalParams().getString("units");
        }
        if ((unitEnum = DistanceUnit.fromString(units)) == null) {
            throw new RuntimeException("Unknown unit: '" + units + "'");
        }
        float width = this.getWidth(context, params);
        float height = this.getHeight(context, params);
        PJsonArray center = params.optJSONArray("center");
        if (center != null) {
            scale = params.getInt("scale");
            centerX = center.getDouble(0);
            centerY = center.getDouble(1);
        } else {
            PJsonArray bbox = params.getJSONArray("bbox");
            double minX = bbox.getDouble(0);
            double minY = bbox.getDouble(1);
            double maxX = bbox.getDouble(2);
            double maxY = bbox.getDouble(3);
            if (minX >= maxX) {
                throw new InvalidValueException("maxX", maxX);
            }
            if (minY >= maxY) {
                throw new InvalidValueException("maxY", maxY);
            }
            centerX = (minX + maxX) / 2.0;
            centerY = (minY + maxY) / 2.0;
            double rotation = params.optDouble("rotation", 0.0);
            double projWidth = (maxX - minX) * Math.abs(Math.cos(rotation *= Math.PI / 180)) + (maxY - minY) * Math.abs(Math.sin(rotation));
            double projHeight = (maxY - minY) * Math.abs(Math.cos(rotation)) + (maxX - minX) * Math.abs(Math.sin(rotation));
            scale = context.getConfig().getBestScale(Math.max(projWidth / DistanceUnit.PT.convertTo(width, unitEnum), projHeight / DistanceUnit.PT.convertTo(height, unitEnum)));
        }
        if (!context.getConfig().isDisableScaleLocking() && !context.getConfig().isScalePresent(scale)) {
            throw new InvalidJsonValueException(params, "scale", scale);
        }
        String srs = null;
        if (params.optBool("geodetic", false) || context.getGlobalParams().optBool("geodetic", false)) {
            srs = params.optString("srs");
            if (srs == null) {
                srs = context.getGlobalParams().optString("srs");
            }
            if (srs == null) {
                throw new RuntimeException("When geodetic is true the srs is value is required");
            }
        }
        double rotation = params.optDouble("rotation", 0.0) * Math.PI / 180.0;
        return new Transformer(centerX, centerY, width, height, scale, dpi, unitEnum, rotation, srs, context.getConfig().getIntegerSvg(), strictEpsg4326);
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public float getHeight(RenderingContext context, PJsonObject params) {
        return Float.parseFloat(PDFUtils.evalString(context, params, this.height, this.name));
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public float getWidth(RenderingContext context, PJsonObject params) {
        return Float.parseFloat(PDFUtils.evalString(context, params, this.width, this.name));
    }

    @Override
    public boolean isAbsolute() {
        return this.absoluteX != null && this.absoluteY != null;
    }

    public void setAbsoluteX(String absoluteX) {
        this.absoluteX = absoluteX;
    }

    public float getAbsoluteX(RenderingContext context, PJsonObject params) {
        return Float.parseFloat(PDFUtils.evalString(context, params, this.absoluteX, this.name));
    }

    public void setAbsoluteY(String absoluteY) {
        this.absoluteY = absoluteY;
    }

    public float getAbsoluteY(RenderingContext context, PJsonObject params) {
        return Float.parseFloat(PDFUtils.evalString(context, params, this.absoluteY, this.name));
    }

    @Override
    public MapBlock getMap(String name) {
        return (name == null || name.equals(this.name)) && Double.isNaN(this.overviewMap) ? this : null;
    }

    public void printClientConfig(JSONWriter json) throws JSONException {
        double h;
        double w;
        json.object();
        try {
            w = Math.round(Double.parseDouble(this.width));
        }
        catch (NumberFormatException e) {
            w = 0.0;
        }
        json.key("width").value(w);
        try {
            h = Math.round(Double.parseDouble(this.height));
        }
        catch (NumberFormatException e) {
            h = 0.0;
        }
        json.key("height").value(h);
        json.endObject();
    }

    public void setOverviewMap(double overviewMap) {
        this.overviewMap = overviewMap;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.absoluteX != null ^ this.absoluteY != null) {
            if (this.absoluteX == null) {
                throw new InvalidValueException("absoluteX", "null");
            }
            throw new InvalidValueException("absoluteY", "null");
        }
        if (this.width == null) {
            throw new InvalidValueException("width", null);
        }
        if (this.height == null) {
            throw new InvalidValueException("width", null);
        }
    }
}

