/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.config.layout.FontBlock;
import org.mapfish.print.utils.PJsonObject;

public class TextBlock
extends FontBlock {
    private String text = "";

    @Override
    public void render(PJsonObject params, Block.PdfElement target, RenderingContext context) throws DocumentException {
        Paragraph paragraph = new Paragraph();
        Font pdfFont = this.getPdfFont();
        paragraph.setFont(pdfFont);
        Phrase text = PDFUtils.renderString(context, params, this.text, pdfFont, null);
        paragraph.add(text);
        if (this.getAlign() != null) {
            paragraph.setAlignment(this.getAlign().getCode());
        }
        paragraph.setSpacingAfter((float)this.spacingAfter);
        target.add(paragraph);
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.text == null) {
            throw new InvalidValueException("text", "null");
        }
    }
}

