/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.scalebar;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfContentByte;
import java.util.List;
import org.mapfish.print.PDFCustomBlocks;
import org.mapfish.print.config.layout.ScalebarBlock;
import org.mapfish.print.scalebar.Label;
import org.mapfish.print.scalebar.ScalebarDrawer;

public class BarScalebarDrawer
extends ScalebarDrawer {
    public BarScalebarDrawer(PDFCustomBlocks customBlocks, ScalebarBlock block, List<Label> labels, int barSize, int labelDistance, int subIntervals, float intervalWidth, Font pdfFont, float leftLabelMargin, float rightLabelMargin, float maxLabelWidth, float maxLabelHeight) {
        super(customBlocks, block, labels, barSize, labelDistance, subIntervals, intervalWidth, pdfFont, leftLabelMargin, rightLabelMargin, maxLabelWidth, maxLabelHeight);
    }

    @Override
    protected void drawBar(PdfContentByte dc) {
        float subIntervalWidth = this.intervalWidth / (float)this.subIntervals;
        for (int i = 0; i < this.block.getIntervals() * this.subIntervals; ++i) {
            BaseColor color;
            float pos = (float)i * subIntervalWidth;
            BaseColor baseColor = color = i % 2 == 0 ? this.block.getBarBgColorVal() : this.block.getColorVal();
            if (color == null) continue;
            dc.setColorFill(color);
            dc.rectangle(pos, 0.0f, subIntervalWidth, this.barSize);
            dc.fill();
        }
        dc.rectangle(0.0f, 0.0f, this.intervalWidth * (float)this.block.getIntervals(), this.barSize);
        dc.stroke();
    }
}

