/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;
import org.mapfish.print.MapPrinter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class BaseMapServlet
extends HttpServlet {
    private static final long serialVersionUID = -6342262849725708850L;
    public static final Logger LOGGER = Logger.getLogger(BaseMapServlet.class);
    private final Map<String, MapPrinter> printers = Maps.newHashMap();
    private final Map<String, Long> lastModifieds = Maps.newHashMap();
    private volatile ApplicationContext context;

    protected synchronized MapPrinter getMapPrinter(String app) throws ServletException {
        MapPrinter printer;
        String configFileCanonicalPath;
        File configFile;
        String configPath = System.getProperty("mapfish-print-config", this.getInitParameter("config"));
        if (configPath == null) {
            throw new ServletException("Missing configuration in web.xml 'web-app/servlet/init-param[param-name=config]' or 'web-app/context-param[param-name=config]'");
        }
        if (app == null) {
            LOGGER.info("app is null, setting it as default configPath: " + configPath);
            app = configPath;
        }
        if (!app.toLowerCase().endsWith(".yaml")) {
            app = app + ".yaml";
        }
        if (!(configFile = new File(app)).isAbsolute() || !configFile.exists()) {
            LOGGER.info("Attempting to locate app config file: '" + app + " in the webapplication.");
            String realPath = this.getServletContext().getRealPath(app);
            if (realPath != null) {
                configFile = new File(realPath);
            } else {
                LOGGER.info("Unable to find config file in web application using getRealPath.  Adding a / because that is often dropped");
                realPath = this.getServletContext().getRealPath("/" + app);
                configFile = new File(realPath);
            }
        }
        LOGGER.info("Loading app from: " + configFile);
        try {
            configFileCanonicalPath = configFile.getCanonicalPath();
            printer = this.printers.get(configFileCanonicalPath);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        long lastModified = this.lastModifieds.containsKey(app) ? this.lastModifieds.get(app) : 0L;
        boolean forceReload = false;
        if (printer != null && (!printer.isRunning() || printer.getConfig().getReloadConfig())) {
            forceReload = true;
        }
        if (forceReload || printer != null && (configFile.lastModified() != lastModified || !printer.isRunning())) {
            if (!forceReload) {
                LOGGER.info("Configuration file modified. Reloading...");
            }
            try {
                printer.stop();
            }
            catch (NullPointerException npe) {
                LOGGER.info("BaseMapServlet.java: printer was not stopped. This happens when a switch between applications happens.\n" + npe);
            }
            printer = null;
            LOGGER.info("Printer for " + app + " stopped");
            this.printers.put(configFileCanonicalPath, null);
        }
        if (printer == null) {
            try {
                LOGGER.info("Loading configuration file: " + configFile.getAbsolutePath());
                printer = this.getApplicationContext().getBean(MapPrinter.class).setYamlConfigFile(configFile);
                this.printers.put(configFileCanonicalPath, printer);
                this.lastModifieds.put(app, configFile.lastModified());
            }
            catch (FileNotFoundException e) {
                throw new ServletException("Cannot read configuration file: " + configPath, (Throwable)e);
            }
            catch (Throwable e) {
                LOGGER.error("Error occurred while reading configuration file", e);
                throw new ServletException("Error occurred while reading configuration file '" + configFile + "': " + e);
            }
        }
        if (printer != null) {
            printer.start();
        }
        return printer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationContext getApplicationContext() {
        if (this.context == null) {
            BaseMapServlet baseMapServlet = this;
            synchronized (baseMapServlet) {
                if (this.context == null) {
                    this.context = WebApplicationContextUtils.getWebApplicationContext(this.getServletContext());
                    if (this.context == null || this.context.getBean(MapPrinter.class) == null) {
                        String springConfig = System.getProperty("mapfish.print.springConfig");
                        this.context = springConfig != null ? new FileSystemXmlApplicationContext("classpath:/mapfish-spring-application-context.xml", springConfig) : new ClassPathXmlApplicationContext("mapfish-spring-application-context.xml");
                    }
                }
            }
        }
        return this.context;
    }
}

