/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.ho.yaml.wrapper.EnumWrapper;

public enum DistanceUnit {
    M(null, 1.0, 1.0, new String[]{"m", "meter", "meters"}),
    MM(M, 0.001, 0.001, new String[]{"mm", "millimeter", "millimeters"}),
    CM(M, 0.01, 0.01, new String[]{"cm", "centimeter", "centimeters"}),
    KM(M, 1000.0, 1000.0, new String[]{"km", "kilometer", "kilometers"}),
    FT(null, 1.0, 0.30479999999999996, new String[]{"ft", "foot", "feet"}),
    PT(FT, 0.0011574074074074073, 3.5277777777777776E-4, new String[]{"pt", "point"}),
    IN(FT, 0.08333333333333333, 0.0254, new String[]{"in", "inch"}),
    YD(FT, 3.0, 0.9143999999999999, new String[]{"yd", "yard", "yards"}),
    MI(FT, 5280.0, 1609.3439999999998, new String[]{"mi", "mile", "miles"}),
    DEGREES(null, 1.0, 111226.30555555556, new String[]{"\u00b0", "dd", "degree", "degrees"}),
    MINUTE(DEGREES, 0.016666666666666666, 111226.30555555556, new String[]{"min", "minute", "minutes"}),
    SECOND(DEGREES, 2.777777777777778E-4, 111226.30555555556, new String[]{"sec", "second", "seconds"});

    private final DistanceUnit baseUnit;
    private final double baseFactor;
    private final double metersFactor;
    private final String[] texts;
    private DistanceUnit[] allUnits = null;
    private static Map<String, DistanceUnit> translations;

    private DistanceUnit(DistanceUnit baseUnit, double baseFactor, double metersFactor, String[] texts) {
        this.baseUnit = baseUnit;
        this.baseFactor = baseFactor;
        this.texts = texts;
        this.metersFactor = metersFactor;
    }

    public boolean isBase() {
        return this.baseUnit == this;
    }

    public double convertTo(double value, DistanceUnit targetUnit) {
        if (this.isSameBaseUnit(targetUnit)) {
            return value * this.baseFactor / targetUnit.baseFactor;
        }
        return value * this.metersFactor / targetUnit.metersFactor;
    }

    public boolean isSameBaseUnit(DistanceUnit target) {
        return target.baseUnit == this.baseUnit || target == this.baseUnit || target.baseUnit == this;
    }

    public String toString() {
        return this.texts[0];
    }

    public static DistanceUnit fromString(String val) {
        return DistanceUnit.getTranslations().get(val.toLowerCase());
    }

    public synchronized DistanceUnit[] getAllUnits() {
        if (this.allUnits != null) {
            return this.allUnits;
        }
        if (this.baseUnit != null) {
            this.allUnits = this.baseUnit.getAllUnits();
            return this.allUnits;
        }
        DistanceUnit[] values = DistanceUnit.values();
        ArrayList<DistanceUnit> list = new ArrayList<DistanceUnit>(values.length);
        list.add(this);
        for (int i = 0; i < values.length; ++i) {
            DistanceUnit value = values[i];
            if (value.baseUnit != this) continue;
            list.add(value);
        }
        DistanceUnit[] result = new DistanceUnit[list.size()];
        list.toArray(result);
        Arrays.sort(result, new Comparator<DistanceUnit>(){

            @Override
            public int compare(DistanceUnit o1, DistanceUnit o2) {
                return Double.compare(o1.baseFactor, o2.baseFactor);
            }
        });
        this.allUnits = result;
        return result;
    }

    public static DistanceUnit getBestUnit(double value, DistanceUnit unit) {
        DistanceUnit[] units = unit.getAllUnits();
        for (int i = units.length - 1; i >= 0; --i) {
            DistanceUnit cur = units[i];
            double converted = Math.abs(unit.convertTo(1.0, cur) * value);
            if (!(converted >= 1.0)) continue;
            return cur;
        }
        return units[0];
    }

    private static synchronized Map<String, DistanceUnit> getTranslations() {
        if (translations == null) {
            translations = new HashMap<String, DistanceUnit>();
            DistanceUnit[] values = DistanceUnit.values();
            for (int i = 0; i < values.length; ++i) {
                DistanceUnit cur = values[i];
                for (int j = 0; j < cur.texts.length; ++j) {
                    translations.put(cur.texts[j], cur);
                }
            }
        }
        return translations;
    }

    static {
        translations = null;
    }

    public static class Wrapper
    extends EnumWrapper {
        public Wrapper(Class<?> type) {
            super(type);
        }

        @Override
        public void setObject(Object obj) {
            if (obj instanceof String) {
                super.setObject((Object)DistanceUnit.fromString((String)obj));
            } else {
                super.setObject(obj);
            }
        }
    }
}

