/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart;

import com.google.protobuf.AnyOrBuilder;
import hapi.chart.ChartOuterClass;
import hapi.chart.ConfigOuterClass;
import hapi.chart.MetadataOuterClass;
import hapi.chart.TemplateOuterClass;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public abstract class AbstractChartWriter
implements Closeable {
    protected AbstractChartWriter() {
    }

    public final void write(ChartOuterClass.ChartOrBuilder chartBuilder) throws IOException {
        this.write(null, null, Objects.requireNonNull(chartBuilder));
    }

    protected void write(Context context, ChartOuterClass.ChartOrBuilder parent, ChartOuterClass.ChartOrBuilder chartBuilder) throws IOException {
        List<? extends ChartOuterClass.ChartOrBuilder> list;
        List<? extends AnyOrBuilder> files;
        Objects.requireNonNull(chartBuilder);
        if (parent == chartBuilder) {
            throw new IllegalArgumentException("parent == chartBuilder");
        }
        MetadataOuterClass.MetadataOrBuilder metadata = chartBuilder.getMetadataOrBuilder();
        if (metadata == null) {
            throw new IllegalArgumentException("chartBuilder", new IllegalStateException("chartBuilder.getMetadata() == null"));
        }
        if (metadata.getName() == null) {
            throw new IllegalArgumentException("chartBuilder", new IllegalStateException("chartBuilder.getMetadata().getName() == null"));
        }
        if (metadata.getVersion() == null) {
            throw new IllegalArgumentException("chartBuilder", new IllegalStateException("chartBuilder.getMetadata().getVersion() == null"));
        }
        if (context == null) {
            final HashMap map = new HashMap(13);
            context = new Context(){

                @Override
                public final <T> T get(Object key, Class<T> type) {
                    Objects.requireNonNull(key);
                    Objects.requireNonNull(type);
                    return type.cast(map.get(key));
                }

                @Override
                public final void put(Object key, Object value) {
                    Objects.requireNonNull(key);
                    Objects.requireNonNull(value);
                    map.put(key, value);
                }

                @Override
                public final boolean containsKey(Object key) {
                    return map.containsKey(key);
                }

                @Override
                public final void remove(Object key) {
                    map.remove(key);
                }
            };
        }
        this.beginWrite(context, parent, chartBuilder);
        this.writeMetadata(context, metadata);
        this.writeConfig(context, chartBuilder.getValuesOrBuilder());
        List<? extends TemplateOuterClass.TemplateOrBuilder> templates = chartBuilder.getTemplatesOrBuilderList();
        if (templates != null && !templates.isEmpty()) {
            for (TemplateOuterClass.TemplateOrBuilder templateOrBuilder : templates) {
                this.writeTemplate(context, templateOrBuilder);
            }
        }
        if ((files = chartBuilder.getFilesOrBuilderList()) != null && !files.isEmpty()) {
            for (AnyOrBuilder anyOrBuilder : files) {
                this.writeFile(context, anyOrBuilder);
            }
        }
        if ((list = chartBuilder.getDependenciesOrBuilderList()) != null && !list.isEmpty()) {
            for (ChartOuterClass.ChartOrBuilder chartOrBuilder : list) {
                if (chartOrBuilder == null) continue;
                this.writeSubchart(context, chartBuilder, chartOrBuilder);
            }
        }
        this.endWrite(context, parent, chartBuilder);
    }

    protected Yaml createYaml() {
        TerseRepresenter representer = new TerseRepresenter();
        representer.setPropertyUtils(new CustomPropertyUtils());
        DumperOptions options = new DumperOptions();
        options.setAllowReadOnlyProperties(true);
        return new Yaml((BaseConstructor)new Constructor(), (Representer)representer, options);
    }

    protected final String toYAML(Context context, Object data) throws IOException {
        Objects.requireNonNull(context);
        Yaml yaml = context.get(Yaml.class.getName(), Yaml.class);
        if (yaml == null) {
            yaml = this.createYaml();
            if (yaml == null) {
                throw new IllegalStateException("createYaml() == null");
            }
            context.put(Yaml.class.getName(), yaml);
        }
        return yaml.dumpAsMap(data);
    }

    protected void beginWrite(Context context, ChartOuterClass.ChartOrBuilder parent, ChartOuterClass.ChartOrBuilder chartBuilder) throws IOException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(chartBuilder);
        if (parent == chartBuilder) {
            throw new IllegalArgumentException("parent == chartBuilder");
        }
    }

    protected abstract void writeMetadata(Context var1, MetadataOuterClass.MetadataOrBuilder var2) throws IOException;

    protected abstract void writeConfig(Context var1, ConfigOuterClass.ConfigOrBuilder var2) throws IOException;

    protected abstract void writeTemplate(Context var1, TemplateOuterClass.TemplateOrBuilder var2) throws IOException;

    protected abstract void writeFile(Context var1, AnyOrBuilder var2) throws IOException;

    protected void writeSubchart(Context context, ChartOuterClass.ChartOrBuilder parent, ChartOuterClass.ChartOrBuilder subchart) throws IOException {
        this.write(Objects.requireNonNull(context), Objects.requireNonNull(parent), Objects.requireNonNull(subchart));
    }

    protected void endWrite(Context context, ChartOuterClass.ChartOrBuilder parent, ChartOuterClass.ChartOrBuilder chartBuilder) throws IOException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(chartBuilder);
        if (parent == chartBuilder) {
            throw new IllegalArgumentException("parent == chartBuilder");
        }
    }

    private static final class CustomPropertyUtils
    extends PropertyUtils {
        private CustomPropertyUtils() {
        }

        protected final Set<Property> createPropertySet(Class<?> type, BeanAccess beanAccess) {
            TreeSet<Property> returnValue;
            if (MetadataOuterClass.MetadataOrBuilder.class.isAssignableFrom(type)) {
                returnValue = new TreeSet<MethodProperty>();
                try {
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("annotations", type, "getAnnotationsMap", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("apiVersion", type, "getApiVersion", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("appVersion", type, "getAppVersion", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("condition", type, "getCondition", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("deprecated", type, "getDeprecated", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("description", type, "getDescription", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("engine", type, "getEngine", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("home", type, "getHome", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("icon", type, "getIcon", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("keywords", type, "getKeywordsList", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("kubeVersion", type, "getKubeVersion", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("maintainers", type, "getMaintainersOrBuilderList", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("name", type, "getName", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("sources", type, "getSourcesList", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("tags", type, "getTags", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("tillerVersion", type, "getTillerVersion", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("version", type, "getVersion", null)));
                }
                catch (IntrospectionException introspectionException) {
                    throw new IllegalStateException(introspectionException.getMessage(), introspectionException);
                }
            } else if (MetadataOuterClass.MaintainerOrBuilder.class.isAssignableFrom(type)) {
                returnValue = new TreeSet();
                try {
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("email", type, "getEmail", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("name", type, "getName", null)));
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("url", type, "getUrl", null)));
                }
                catch (IntrospectionException introspectionException) {
                    throw new IllegalStateException(introspectionException.getMessage(), introspectionException);
                }
            } else if (ConfigOuterClass.ConfigOrBuilder.class.isAssignableFrom(type)) {
                returnValue = new TreeSet();
                try {
                    returnValue.add((Property)new MethodProperty(new PropertyDescriptor("raw", type, "getRaw", null)));
                }
                catch (IntrospectionException introspectionException) {
                    throw new IllegalStateException(introspectionException.getMessage(), introspectionException);
                }
            } else {
                returnValue = super.createPropertySet(type, beanAccess);
            }
            return returnValue;
        }
    }

    private static final class TerseRepresenter
    extends Representer {
        private TerseRepresenter() {
        }

        protected final MappingNode representJavaBean(Set<Property> properties, Object bean) {
            Class<?> beanClass;
            if (bean != null && this.getTag(beanClass = bean.getClass(), null) == null) {
                this.addClassTag(beanClass, Tag.MAP);
            }
            return super.representJavaBean(properties, bean);
        }

        protected final NodeTuple representJavaBeanProperty(Object bean, Property property, Object value, Tag tag) {
            Object returnValue = value == null || value.equals(Boolean.FALSE) ? null : (value instanceof CharSequence ? (((CharSequence)value).length() <= 0 ? null : super.representJavaBeanProperty(bean, property, value, tag)) : (value instanceof Collection ? (((Collection)value).isEmpty() ? null : super.representJavaBeanProperty(bean, property, value, tag)) : (value instanceof Map ? (((Map)value).isEmpty() ? null : super.representJavaBeanProperty(bean, property, value, tag)) : (value.getClass().isArray() ? (Array.getLength(value) <= 0 ? null : super.representJavaBeanProperty(bean, property, value, tag)) : super.representJavaBeanProperty(bean, property, value, tag)))));
            return returnValue;
        }
    }

    protected static abstract class Context {
        private Context() {
        }

        public abstract <T> T get(Object var1, Class<T> var2);

        public abstract void put(Object var1, Object var2);

        public abstract boolean containsKey(Object var1);

        public abstract void remove(Object var1);
    }
}

