/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class MapTree {
    private static final Pattern keyPattern = Pattern.compile("([^.]+)\\.?");
    private final Map<String, Object> map;

    MapTree(Map<String, Object> map) {
        this.map = map;
    }

    static final Map<String, Object> newMapChain(String path, Map<String, Object> data) {
        Objects.requireNonNull(path);
        Map<String, Object> returnValue = null;
        if (path.equals(".")) {
            returnValue = data;
        } else if (!path.isEmpty()) {
            Matcher matcher = keyPattern.matcher(path);
            assert (matcher != null);
            HashMap<String, Object> priorMap = null;
            while (matcher.find()) {
                String key = matcher.group(1);
                assert (key != null);
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                if (matcher.hitEnd()) {
                    newMap.put(key, data);
                } else {
                    newMap.put(key, null);
                }
                if (priorMap == null) {
                    assert (returnValue == null);
                    returnValue = newMap;
                } else {
                    assert (returnValue != null);
                    assert (priorMap.size() == 1);
                    priorMap.entrySet().iterator().next().setValue(newMap);
                }
                priorMap = newMap;
            }
        }
        return returnValue;
    }

    final Map<String, Object> getMap(String path) {
        Map map = this.get(path, Map.class);
        if (map == null) {
            return null;
        }
        Map returnValue = map;
        return returnValue;
    }

    final <V> V get(String path, Class<V> type) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(type);
        Object returnValue = null;
        Map map = this.map;
        if (map != null && !map.isEmpty() && !path.isEmpty()) {
            Matcher matcher = keyPattern.matcher(path);
            assert (matcher != null);
            while (map != null && matcher.find()) {
                String key = matcher.group(1);
                assert (key != null);
                returnValue = map.get(key);
                if (returnValue instanceof Map) {
                    Map temp;
                    map = temp = (Map)returnValue;
                    continue;
                }
                if (!matcher.hitEnd()) {
                    returnValue = null;
                }
                map = null;
            }
        }
        if (returnValue == null || !type.isInstance(returnValue)) {
            return null;
        }
        return type.cast(returnValue);
    }

    final Object put(String path, Object value) {
        HashMap<String, Object> map = this.map;
        Object returnValue = null;
        if (path == null || path.isEmpty()) {
            if (map != null) {
                returnValue = map.put(path, value);
            }
        } else {
            Matcher matcher = keyPattern.matcher(path);
            assert (matcher != null);
            while (map != null && matcher.find()) {
                String key = matcher.group(1);
                assert (key != null);
                assert (!key.isEmpty());
                Object object = map.get(key);
                if (object instanceof Map) {
                    HashMap<String, Object> temp;
                    map = temp = (HashMap<String, Object>)object;
                    continue;
                }
                if (matcher.hitEnd()) {
                    returnValue = map.put(key, value);
                    continue;
                }
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                map.put(key, newMap);
                map = newMap;
            }
        }
        return returnValue;
    }
}

