/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.kamranzafar.jtar.TarEntry;
import org.kamranzafar.jtar.TarHeader;
import org.kamranzafar.jtar.TarOutputStream;
import org.microbean.helm.chart.AbstractArchiveChartWriter;
import org.microbean.helm.chart.AbstractChartWriter;

public class TapeArchiveChartWriter
extends AbstractArchiveChartWriter {
    private final TarOutputStream outputStream;

    public TapeArchiveChartWriter(OutputStream outputStream) {
        Objects.requireNonNull(outputStream);
        this.outputStream = new TarOutputStream(outputStream);
    }

    @Override
    protected void writeEntry(AbstractChartWriter.Context context, String path, String contents) throws IOException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(path);
        Objects.requireNonNull(contents);
        if (path.isEmpty()) {
            throw new IllegalArgumentException("path", new IllegalStateException("path.isEmpty()"));
        }
        byte[] contentsBytes = contents.getBytes(StandardCharsets.UTF_8);
        long size = contentsBytes.length;
        TarHeader tarHeader = TarHeader.createHeader((String)(context.get("path", String.class) + path), (long)size, (long)System.currentTimeMillis(), (boolean)false, (int)493);
        TarEntry tarEntry = new TarEntry(tarHeader);
        this.outputStream.putNextEntry(tarEntry);
        this.outputStream.write(contentsBytes);
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

