/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart.repository;

import hapi.chart.ChartOuterClass;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.microbean.development.annotation.Experimental;
import org.microbean.helm.chart.repository.ChartRepository;
import org.microbean.helm.chart.repository.HelmHome;
import org.microbean.helm.chart.resolver.AbstractChartResolver;
import org.microbean.helm.chart.resolver.ChartResolverException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

@Experimental
public class ChartRepositoryRepository
extends AbstractChartResolver {
    private static final Pattern slashPattern = Pattern.compile("/");
    private static final HelmHome helmHome = new HelmHome();
    private final Set<ChartRepository> chartRepositories;

    public ChartRepositoryRepository(Set<? extends ChartRepository> chartRepositories) {
        this.chartRepositories = chartRepositories == null || chartRepositories.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<ChartRepository>(chartRepositories));
    }

    public final Set<ChartRepository> getChartRepositories() {
        return this.chartRepositories;
    }

    public ChartRepository getChartRepository(String name) {
        Objects.requireNonNull(name);
        ChartRepository returnValue = null;
        Set<ChartRepository> repos = this.getChartRepositories();
        if (repos != null && !repos.isEmpty()) {
            for (ChartRepository repo : repos) {
                if (repo == null || !name.equals(repo.getName())) continue;
                returnValue = repo;
            }
        }
        return returnValue;
    }

    @Override
    public ChartOuterClass.Chart.Builder resolve(String chartName, String chartVersion) throws ChartResolverException {
        Objects.requireNonNull(chartName);
        ChartOuterClass.Chart.Builder returnValue = null;
        String[] parts = slashPattern.split(chartName, 2);
        if (parts != null && parts.length == 2) {
            returnValue = this.resolve(parts[0], parts[1], chartVersion);
        }
        return returnValue;
    }

    public ChartOuterClass.Chart.Builder resolve(String repositoryName, String chartName, String chartVersion) throws ChartResolverException {
        ChartOuterClass.Chart.Builder candidate;
        Objects.requireNonNull(repositoryName);
        Objects.requireNonNull(chartName);
        ChartOuterClass.Chart.Builder returnValue = null;
        ChartRepository repo = this.getChartRepository(repositoryName);
        if (repo != null && (candidate = repo.resolve(chartName, chartVersion)) != null) {
            returnValue = candidate;
        }
        return returnValue;
    }

    public static final ChartRepositoryRepository fromHelmRepositoriesYaml() throws IOException, URISyntaxException {
        return ChartRepositoryRepository.fromHelmRepositoriesYaml(false);
    }

    public static final ChartRepositoryRepository fromHelmRepositoriesYaml(boolean reifyHelmHomeIfNecessary) throws IOException, URISyntaxException {
        if (reifyHelmHomeIfNecessary) {
            helmHome.reify();
        }
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(helmHome.toPath().resolve("repository/repositories.yaml"), new OpenOption[0]));){
            ChartRepositoryRepository chartRepositoryRepository = ChartRepositoryRepository.fromYaml(stream, null, null, false, null);
            return chartRepositoryRepository;
        }
    }

    public static final ChartRepositoryRepository fromYaml(InputStream stream) throws IOException, URISyntaxException {
        return ChartRepositoryRepository.fromYaml(stream, null, null, false, null);
    }

    public static final ChartRepositoryRepository fromYaml(InputStream stream, boolean reifyHelmHomeIfNecessary) throws IOException, URISyntaxException {
        return ChartRepositoryRepository.fromYaml(stream, null, null, reifyHelmHomeIfNecessary, null);
    }

    public static final ChartRepositoryRepository fromYaml(InputStream stream, Path archiveCacheDirectory, Path indexCacheDirectory) throws IOException, URISyntaxException {
        return ChartRepositoryRepository.fromYaml(stream, archiveCacheDirectory, indexCacheDirectory, false, null);
    }

    public static final ChartRepositoryRepository fromYaml(InputStream stream, Path archiveCacheDirectory, Path indexCacheDirectory, boolean reifyHelmHomeIfNecessary) throws IOException, URISyntaxException {
        return ChartRepositoryRepository.fromYaml(stream, archiveCacheDirectory, indexCacheDirectory, reifyHelmHomeIfNecessary, null);
    }

    public static final ChartRepositoryRepository fromYaml(InputStream stream, Path archiveCacheDirectory, Path indexCacheDirectory, ChartRepositoryFactory factory) throws IOException, URISyntaxException {
        return ChartRepositoryRepository.fromYaml(stream, archiveCacheDirectory, indexCacheDirectory, false, factory);
    }

    public static final ChartRepositoryRepository fromYaml(InputStream stream, Path archiveCacheDirectory, Path indexCacheDirectory, boolean reifyHelmHomeIfNecessary, ChartRepositoryFactory factory) throws IOException, URISyntaxException {
        Set chartRepositories;
        Objects.requireNonNull(stream);
        if (factory == null) {
            factory = ChartRepository::new;
        }
        boolean reified = false;
        Path helmHomePath = null;
        if (archiveCacheDirectory == null) {
            helmHomePath = helmHome.toPath();
            assert (helmHomePath != null);
            archiveCacheDirectory = helmHomePath.resolve("cache/archive");
            assert (archiveCacheDirectory != null);
            if (reifyHelmHomeIfNecessary) {
                helmHome.reify();
                reified = true;
            }
        }
        if (!Files.isDirectory(archiveCacheDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("!Files.isDirectory(archiveCacheDirectory): " + archiveCacheDirectory);
        }
        if (indexCacheDirectory == null) {
            if (helmHomePath == null) {
                helmHomePath = helmHome.toPath();
                assert (helmHomePath != null);
            }
            indexCacheDirectory = helmHomePath.resolve("repository/cache");
            assert (indexCacheDirectory != null);
            if (!reified && reifyHelmHomeIfNecessary) {
                helmHome.reify();
                reified = true;
            }
        }
        if (!Files.isDirectory(indexCacheDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("!Files.isDirectory(indexCacheDirectory): " + indexCacheDirectory);
        }
        Map map = (Map)new Yaml((BaseConstructor)new SafeConstructor()).load(stream);
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("No data readable from stream: " + stream);
        }
        Collection repositories = (Collection)map.get("repositories");
        if (repositories == null || repositories.isEmpty()) {
            chartRepositories = Collections.emptySet();
        } else {
            chartRepositories = new LinkedHashSet();
            for (Map repositoryMap : repositories) {
                ChartRepository chartRepository;
                if (repositoryMap == null || repositoryMap.isEmpty()) continue;
                String name = Objects.requireNonNull((String)repositoryMap.get("name"));
                URI uri = new URI((String)repositoryMap.get("url"));
                Path cachedIndexPath = Objects.requireNonNull(Paths.get((String)repositoryMap.get("cache"), new String[0]));
                if (!cachedIndexPath.isAbsolute()) {
                    cachedIndexPath = indexCacheDirectory.resolve(cachedIndexPath);
                    assert (cachedIndexPath.isAbsolute());
                }
                if ((chartRepository = factory.createChartRepository(name, uri, archiveCacheDirectory, indexCacheDirectory, cachedIndexPath)) == null) {
                    throw new IllegalStateException("factory.createChartRepository() == null");
                }
                chartRepositories.add(chartRepository);
            }
        }
        return new ChartRepositoryRepository(chartRepositories);
    }

    @FunctionalInterface
    public static interface ChartRepositoryFactory {
        public ChartRepository createChartRepository(String var1, URI var2, Path var3, Path var4, Path var5);
    }
}

