/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jose.jwk;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.mitre.jose.jwk.ECKeyMaker;
import org.mitre.jose.jwk.OctetSequenceKeyMaker;
import org.mitre.jose.jwk.RSAKeyMaker;

public class Launcher {
    private static Options options;

    public static void main(String[] args) {
        options = new Options();
        options.addOption("t", true, "Key Type, one of: " + KeyType.RSA + ", " + KeyType.OCT + ", " + KeyType.EC);
        options.addOption("s", true, "Key Size in bits, required for RSA and OCT key types. Must be an integer divisible by 8");
        options.addOption("u", true, "Usage, one of: enc, sig (optional)");
        options.addOption("a", true, "Algorithm (optional)");
        options.addOption("i", true, "Key ID (optional)");
        options.addOption("p", false, "Display public key separately");
        options.addOption("c", true, "Key Curve, required for EC key type. Must be one of " + ECKey.Curve.P_256 + ", " + ECKey.Curve.P_384 + ", " + ECKey.Curve.P_521);
        options.addOption("S", false, "Wrap the generated key in a KeySet");
        PosixParser parser = new PosixParser();
        try {
            JsonElement json;
            Integer keySize;
            CommandLine cmd = parser.parse(options, args);
            String kty = cmd.getOptionValue("t");
            String size = cmd.getOptionValue("s");
            String use = cmd.getOptionValue("u");
            String alg = cmd.getOptionValue("a");
            String kid = cmd.getOptionValue("i");
            String crv = cmd.getOptionValue("c");
            boolean keySet = cmd.hasOption("S");
            boolean pubKey = cmd.hasOption("p");
            if (kty == null) {
                Launcher.printUsageAndExit("Key type must be supplied.");
            }
            KeyType keyType = KeyType.parse((String)kty);
            if (Strings.isNullOrEmpty((String)kid)) {
                kid = null;
            }
            KeyUse keyUse = null;
            if (use != null) {
                if (use.equals("sig")) {
                    keyUse = KeyUse.SIGNATURE;
                } else if (use.equals("enc")) {
                    keyUse = KeyUse.ENCRYPTION;
                } else {
                    Launcher.printUsageAndExit("Invalid key usage, must be 'sig' or 'enc', got " + use);
                }
            }
            JWSAlgorithm keyAlg = null;
            if (!Strings.isNullOrEmpty((String)alg)) {
                keyAlg = JWSAlgorithm.parse((String)alg);
            }
            RSAKey jwk = null;
            if (keyType.equals((Object)KeyType.RSA)) {
                if (Strings.isNullOrEmpty((String)size)) {
                    Launcher.printUsageAndExit("Key size (in bits) is required for key type " + keyType);
                }
                if ((keySize = Integer.decode(size)) % 8 != 0) {
                    Launcher.printUsageAndExit("Key size (in bits) must be divisible by 8, got " + keySize);
                }
                jwk = RSAKeyMaker.make(keySize, keyUse, (Algorithm)keyAlg, kid);
            } else if (keyType.equals((Object)KeyType.OCT)) {
                if (Strings.isNullOrEmpty((String)size)) {
                    Launcher.printUsageAndExit("Key size (in bits) is required for key type " + keyType);
                }
                if ((keySize = Integer.decode(size)) % 8 != 0) {
                    Launcher.printUsageAndExit("Key size (in bits) must be divisible by 8, got " + keySize);
                }
                jwk = OctetSequenceKeyMaker.make(keySize, keyUse, (Algorithm)keyAlg, kid);
            } else if (keyType.equals((Object)KeyType.EC)) {
                if (Strings.isNullOrEmpty((String)crv)) {
                    Launcher.printUsageAndExit("Curve is required for key type " + keyType);
                }
                ECKey.Curve keyCurve = ECKey.Curve.parse((String)crv);
                jwk = ECKeyMaker.make(keyCurve, keyUse, (Algorithm)keyAlg, kid);
            } else {
                Launcher.printUsageAndExit("Unknown key type: " + keyType);
            }
            System.out.println("Full key:");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (keySet) {
                JWKSet jwkSet = new JWKSet((JWK)jwk);
                json = new JsonParser().parse(jwkSet.toJSONObject(false).toJSONString());
                System.out.println(gson.toJson(json));
            } else {
                JsonElement json2 = new JsonParser().parse(jwk.toJSONString());
                System.out.println(gson.toJson(json2));
            }
            if (pubKey) {
                System.out.println();
                JWK pub = jwk.toPublicJWK();
                if (pub != null) {
                    System.out.println("Public key:");
                    if (keySet) {
                        JWKSet jwkSet = new JWKSet(pub);
                        JsonElement json3 = new JsonParser().parse(jwkSet.toJSONObject(false).toJSONString());
                        System.out.println(gson.toJson(json3));
                    } else {
                        json = new JsonParser().parse(pub.toJSONString());
                        System.out.println(gson.toJson(json));
                    }
                } else {
                    System.out.println("No public key.");
                }
            }
        }
        catch (NumberFormatException e) {
            Launcher.printUsageAndExit("Invalid key size: " + e.getMessage());
        }
        catch (ParseException e) {
            Launcher.printUsageAndExit("Failed to parse arguments: " + e.getMessage());
        }
    }

    private static void printUsageAndExit(String message) {
        if (message != null) {
            System.err.println(message);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar json-web-key-generator.jar -t <keyType> [options]", options);
        System.exit(1);
    }
}

