/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jwt.signer.service.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.nimbusds.jose.jwk.JWKSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.mitre.jose.keystore.JWKSetKeyStore;
import org.mitre.jwt.encryption.service.JwtEncryptionAndDecryptionService;
import org.mitre.jwt.encryption.service.impl.DefaultJwtEncryptionAndDecryptionService;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.DefaultJwtSigningAndValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class JWKSetCacheService {
    private static Logger logger = LoggerFactory.getLogger(JWKSetCacheService.class);
    private LoadingCache<String, JwtSigningAndValidationService> validators = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(100L).build((CacheLoader)new JWKSetVerifierFetcher());
    private LoadingCache<String, JwtEncryptionAndDecryptionService> encrypters = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(100L).build((CacheLoader)new JWKSetEncryptorFetcher());

    public JwtSigningAndValidationService getValidator(String jwksUri) {
        try {
            return (JwtSigningAndValidationService)this.validators.get((Object)jwksUri);
        }
        catch (UncheckedExecutionException ue) {
            logger.warn("Couldn't load JWK Set from " + jwksUri, (Throwable)ue);
            return null;
        }
        catch (ExecutionException e) {
            logger.warn("Couldn't load JWK Set from " + jwksUri, (Throwable)e);
            return null;
        }
    }

    public JwtEncryptionAndDecryptionService getEncrypter(String jwksUri) {
        try {
            return (JwtEncryptionAndDecryptionService)this.encrypters.get((Object)jwksUri);
        }
        catch (UncheckedExecutionException ue) {
            logger.warn("Couldn't load JWK Set from " + jwksUri, (Throwable)ue);
            return null;
        }
        catch (ExecutionException e) {
            logger.warn("Couldn't load JWK Set from " + jwksUri, (Throwable)e);
            return null;
        }
    }

    private class JWKSetEncryptorFetcher
    extends CacheLoader<String, JwtEncryptionAndDecryptionService> {
        private HttpClient httpClient = new SystemDefaultHttpClient();
        private HttpComponentsClientHttpRequestFactory httpFactory = new HttpComponentsClientHttpRequestFactory(this.httpClient);
        private RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)this.httpFactory);

        private JWKSetEncryptorFetcher() {
        }

        public JwtEncryptionAndDecryptionService load(String key) throws Exception {
            String jsonString = (String)this.restTemplate.getForObject(key, String.class, new Object[0]);
            JWKSet jwkSet = JWKSet.parse((String)jsonString);
            JWKSetKeyStore keyStore = new JWKSetKeyStore(jwkSet);
            DefaultJwtEncryptionAndDecryptionService service = new DefaultJwtEncryptionAndDecryptionService(keyStore);
            return service;
        }
    }

    private class JWKSetVerifierFetcher
    extends CacheLoader<String, JwtSigningAndValidationService> {
        private HttpClient httpClient = new SystemDefaultHttpClient();
        private HttpComponentsClientHttpRequestFactory httpFactory = new HttpComponentsClientHttpRequestFactory(this.httpClient);
        private RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)this.httpFactory);

        private JWKSetVerifierFetcher() {
        }

        public JwtSigningAndValidationService load(String key) throws Exception {
            String jsonString = (String)this.restTemplate.getForObject(key, String.class, new Object[0]);
            JWKSet jwkSet = JWKSet.parse((String)jsonString);
            JWKSetKeyStore keyStore = new JWKSetKeyStore(jwkSet);
            DefaultJwtSigningAndValidationService service = new DefaultJwtSigningAndValidationService(keyStore);
            return service;
        }
    }
}

