/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.model;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.mitre.jose.JWEAlgorithmEmbed;
import org.mitre.jose.JWEEncryptionMethodEmbed;
import org.mitre.jose.JWSAlgorithmEmbed;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.provider.ClientDetails;

@Entity
@Table(name="client_details")
@NamedQueries(value={@NamedQuery(name="ClientDetailsEntity.findAll", query="SELECT c FROM ClientDetailsEntity c"), @NamedQuery(name="ClientDetailsEntity.getByClientId", query="select c from ClientDetailsEntity c where c.clientId = :clientId")})
public class ClientDetailsEntity
implements ClientDetails {
    private static final int DEFAULT_ID_TOKEN_VALIDITY_SECONDS = 600;
    private static final long serialVersionUID = -1617727085733786296L;
    private Long id;
    private String clientId = null;
    private String clientSecret = null;
    private Set<String> redirectUris = new HashSet<String>();
    private String clientName;
    private String clientUri;
    private String logoUri;
    private Set<String> contacts;
    private String tosUri;
    private AuthMethod tokenEndpointAuthMethod = AuthMethod.SECRET_BASIC;
    private Set<String> scope = new HashSet<String>();
    private Set<String> grantTypes = new HashSet<String>();
    private Set<String> responseTypes = new HashSet<String>();
    private String policyUri;
    private String jwksUri;
    private AppType applicationType;
    private String sectorIdentifierUri;
    private SubjectType subjectType;
    private JWSAlgorithmEmbed requestObjectSigningAlg = null;
    private JWSAlgorithmEmbed userInfoSignedResponseAlg = null;
    private JWEAlgorithmEmbed userInfoEncryptedResponseAlg = null;
    private JWEEncryptionMethodEmbed userInfoEncryptedResponseEnc = null;
    private JWSAlgorithmEmbed idTokenSignedResponseAlg = null;
    private JWEAlgorithmEmbed idTokenEncryptedResponseAlg = null;
    private JWEEncryptionMethodEmbed idTokenEncryptedResponseEnc = null;
    private JWSAlgorithmEmbed tokenEndpointAuthSigningAlg = null;
    private Integer defaultMaxAge;
    private Boolean requireAuthTime;
    private Set<String> defaultACRvalues;
    private String initiateLoginUri;
    private String postLogoutRedirectUri;
    private Set<String> requestUris;
    private Set<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
    private Integer accessTokenValiditySeconds = 0;
    private Integer refreshTokenValiditySeconds = 0;
    private Set<String> resourceIds = new HashSet<String>();
    private Map<String, Object> additionalInformation = new HashMap<String, Object>();
    private String clientDescription = "";
    private boolean reuseRefreshToken = true;
    private boolean dynamicallyRegistered = false;
    private boolean allowIntrospection = false;
    private Integer idTokenValiditySeconds;
    private Date createdAt;

    @PrePersist
    @PreUpdate
    private void prePersist() {
        if (this.getIdTokenValiditySeconds() == null) {
            this.setIdTokenValiditySeconds(600);
        }
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Basic
    @Column(name="client_description")
    public String getClientDescription() {
        return this.clientDescription;
    }

    public void setClientDescription(String clientDescription) {
        this.clientDescription = clientDescription;
    }

    @Transient
    public boolean isAllowRefresh() {
        if (this.grantTypes != null) {
            return this.getAuthorizedGrantTypes().contains("refresh_token");
        }
        return false;
    }

    @Basic
    @Column(name="reuse_refresh_tokens")
    public boolean isReuseRefreshToken() {
        return this.reuseRefreshToken;
    }

    public void setReuseRefreshToken(boolean reuseRefreshToken) {
        this.reuseRefreshToken = reuseRefreshToken;
    }

    @Basic
    @Column(name="id_token_validity_seconds")
    public Integer getIdTokenValiditySeconds() {
        return this.idTokenValiditySeconds;
    }

    public void setIdTokenValiditySeconds(Integer idTokenValiditySeconds) {
        this.idTokenValiditySeconds = idTokenValiditySeconds;
    }

    @Basic
    @Column(name="dynamically_registered")
    public boolean isDynamicallyRegistered() {
        return this.dynamicallyRegistered;
    }

    public void setDynamicallyRegistered(boolean dynamicallyRegistered) {
        this.dynamicallyRegistered = dynamicallyRegistered;
    }

    @Basic
    @Column(name="allow_introspection")
    public boolean isAllowIntrospection() {
        return this.allowIntrospection;
    }

    public void setAllowIntrospection(boolean allowIntrospection) {
        this.allowIntrospection = allowIntrospection;
    }

    @Transient
    public boolean isSecretRequired() {
        return this.getTokenEndpointAuthMethod() != null && (this.getTokenEndpointAuthMethod().equals((Object)AuthMethod.SECRET_BASIC) || this.getTokenEndpointAuthMethod().equals((Object)AuthMethod.SECRET_POST) || this.getTokenEndpointAuthMethod().equals((Object)AuthMethod.SECRET_JWT));
    }

    @Transient
    public boolean isScoped() {
        return this.getScope() != null && !this.getScope().isEmpty();
    }

    @Basic
    @Column(name="client_id")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Basic
    @Column(name="client_secret")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="client_scope", joinColumns={@JoinColumn(name="owner_id")})
    @Column(name="scope")
    public Set<String> getScope() {
        return this.scope;
    }

    public void setScope(Set<String> scope) {
        this.scope = scope;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="client_grant_type", joinColumns={@JoinColumn(name="owner_id")})
    @Column(name="grant_type")
    public Set<String> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(Set<String> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public Set<String> getAuthorizedGrantTypes() {
        return this.getGrantTypes();
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="client_authority", joinColumns={@JoinColumn(name="owner_id")})
    @Column(name="authority")
    public Set<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(Set<GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    @Basic
    @Column(name="access_token_validity_seconds")
    public Integer getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(Integer accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    @Basic
    @Column(name="refresh_token_validity_seconds")
    public Integer getRefreshTokenValiditySeconds() {
        return this.refreshTokenValiditySeconds;
    }

    public void setRefreshTokenValiditySeconds(Integer refreshTokenValiditySeconds) {
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="client_redirect_uri", joinColumns={@JoinColumn(name="owner_id")})
    @Column(name="redirect_uri")
    public Set<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    @Transient
    public Set<String> getRegisteredRedirectUri() {
        return this.getRedirectUris();
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="client_resource", joinColumns={@JoinColumn(name="owner_id")})
    @Column(name="resource_id")
    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Set<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    @Transient
    public Map<String, Object> getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="application_type")
    public AppType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(AppType applicationType) {
        this.applicationType = applicationType;
    }

    @Basic
    @Column(name="client_name")
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="token_endpoint_auth_method")
    public AuthMethod getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(AuthMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="subject_type")
    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="client_contact", joinColumns={@JoinColumn(name="owner_id")})
    @Column(name="contact")
    public Set<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(Set<String> contacts) {
        this.contacts = contacts;
    }

    @Basic
    @Column(name="logo_uri")
    public String getLogoUri() {
        return this.logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    @Basic
    @Column(name="policy_uri")
    public String getPolicyUri() {
        return this.policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    @Basic
    @Column(name="client_uri")
    public String getClientUri() {
        return this.clientUri;
    }

    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    @Basic
    @Column(name="tos_uri")
    public String getTosUri() {
        return this.tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    @Basic
    @Column(name="jwks_uri")
    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    @Basic
    @Column(name="sector_identifier_uri")
    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="algorithmName", column=@Column(name="request_object_signing_alg"))})
    public JWSAlgorithmEmbed getRequestObjectSigningAlgEmbed() {
        return this.requestObjectSigningAlg;
    }

    public void setRequestObjectSigningAlgEmbed(JWSAlgorithmEmbed requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="algorithmName", column=@Column(name="user_info_signed_response_alg"))})
    public JWSAlgorithmEmbed getUserInfoSignedResponseAlgEmbed() {
        return this.userInfoSignedResponseAlg;
    }

    public void setUserInfoSignedResponseAlgEmbed(JWSAlgorithmEmbed userInfoSignedResponseAlg) {
        this.userInfoSignedResponseAlg = userInfoSignedResponseAlg;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="algorithmName", column=@Column(name="user_info_encrypted_response_alg"))})
    public JWEAlgorithmEmbed getUserInfoEncryptedResponseAlgEmbed() {
        return this.userInfoEncryptedResponseAlg;
    }

    public void setUserInfoEncryptedResponseAlgEmbed(JWEAlgorithmEmbed userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="algorithmName", column=@Column(name="user_info_encrypted_response_enc"))})
    public JWEEncryptionMethodEmbed getUserInfoEncryptedResponseEncEmbed() {
        return this.userInfoEncryptedResponseEnc;
    }

    public void setUserInfoEncryptedResponseEncEmbed(JWEEncryptionMethodEmbed userInfoEncryptedResponseEnc) {
        this.userInfoEncryptedResponseEnc = userInfoEncryptedResponseEnc;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="algorithmName", column=@Column(name="id_token_signed_response_alg"))})
    public JWSAlgorithmEmbed getIdTokenSignedResponseAlgEmbed() {
        return this.idTokenSignedResponseAlg;
    }

    public void setIdTokenSignedResponseAlgEmbed(JWSAlgorithmEmbed idTokenSignedResponseAlg) {
        this.idTokenSignedResponseAlg = idTokenSignedResponseAlg;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="algorithmName", column=@Column(name="id_token_encrypted_response_alg"))})
    public JWEAlgorithmEmbed getIdTokenEncryptedResponseAlgEmbed() {
        return this.idTokenEncryptedResponseAlg;
    }

    public void setIdTokenEncryptedResponseAlgEmbed(JWEAlgorithmEmbed idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = idTokenEncryptedResponseAlg;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="algorithmName", column=@Column(name="id_token_encrypted_response_enc"))})
    public JWEEncryptionMethodEmbed getIdTokenEncryptedResponseEncEmbed() {
        return this.idTokenEncryptedResponseEnc;
    }

    public void setIdTokenEncryptedResponseEncEmbed(JWEEncryptionMethodEmbed idTokenEncryptedResponseEnc) {
        this.idTokenEncryptedResponseEnc = idTokenEncryptedResponseEnc;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="algorithmName", column=@Column(name="token_endpoint_auth_signing_alg"))})
    public JWSAlgorithmEmbed getTokenEndpointAuthSigningAlgEmbed() {
        return this.tokenEndpointAuthSigningAlg;
    }

    public void setTokenEndpointAuthSigningAlgEmbed(JWSAlgorithmEmbed tokenEndpointAuthSigningAlgEmbed) {
        this.tokenEndpointAuthSigningAlg = tokenEndpointAuthSigningAlgEmbed;
    }

    @Transient
    public JWSAlgorithm getRequestObjectSigningAlg() {
        if (this.requestObjectSigningAlg != null) {
            return this.requestObjectSigningAlg.getAlgorithm();
        }
        return null;
    }

    public void setRequestObjectSigningAlg(JWSAlgorithm requestObjectSigningAlg) {
        this.requestObjectSigningAlg = new JWSAlgorithmEmbed(requestObjectSigningAlg);
    }

    @Transient
    public JWSAlgorithm getUserInfoSignedResponseAlg() {
        if (this.userInfoSignedResponseAlg != null) {
            return this.userInfoSignedResponseAlg.getAlgorithm();
        }
        return null;
    }

    public void setUserInfoSignedResponseAlg(JWSAlgorithm userInfoSignedResponseAlg) {
        this.userInfoSignedResponseAlg = new JWSAlgorithmEmbed(userInfoSignedResponseAlg);
    }

    @Transient
    public JWEAlgorithm getUserInfoEncryptedResponseAlg() {
        if (this.userInfoEncryptedResponseAlg != null) {
            return this.userInfoEncryptedResponseAlg.getAlgorithm();
        }
        return null;
    }

    public void setUserInfoEncryptedResponseAlg(JWEAlgorithm userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = new JWEAlgorithmEmbed(userInfoEncryptedResponseAlg);
    }

    @Transient
    public EncryptionMethod getUserInfoEncryptedResponseEnc() {
        if (this.userInfoEncryptedResponseEnc != null) {
            return this.userInfoEncryptedResponseEnc.getAlgorithm();
        }
        return null;
    }

    public void setUserInfoEncryptedResponseEnc(EncryptionMethod userInfoEncryptedResponseEnc) {
        this.userInfoEncryptedResponseEnc = new JWEEncryptionMethodEmbed(userInfoEncryptedResponseEnc);
    }

    @Transient
    public JWSAlgorithm getIdTokenSignedResponseAlg() {
        if (this.idTokenSignedResponseAlg != null) {
            return this.idTokenSignedResponseAlg.getAlgorithm();
        }
        return null;
    }

    public void setIdTokenSignedResponseAlg(JWSAlgorithm idTokenSignedResponseAlg) {
        this.idTokenSignedResponseAlg = new JWSAlgorithmEmbed(idTokenSignedResponseAlg);
    }

    @Transient
    public JWEAlgorithm getIdTokenEncryptedResponseAlg() {
        if (this.idTokenEncryptedResponseAlg != null) {
            return this.idTokenEncryptedResponseAlg.getAlgorithm();
        }
        return null;
    }

    public void setIdTokenEncryptedResponseAlg(JWEAlgorithm idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = new JWEAlgorithmEmbed(idTokenEncryptedResponseAlg);
    }

    @Transient
    public EncryptionMethod getIdTokenEncryptedResponseEnc() {
        if (this.idTokenEncryptedResponseEnc != null) {
            return this.idTokenEncryptedResponseEnc.getAlgorithm();
        }
        return null;
    }

    public void setIdTokenEncryptedResponseEnc(EncryptionMethod idTokenEncryptedResponseEnc) {
        this.idTokenEncryptedResponseEnc = new JWEEncryptionMethodEmbed(idTokenEncryptedResponseEnc);
    }

    @Transient
    public JWSAlgorithm getTokenEndpointAuthSigningAlg() {
        if (this.tokenEndpointAuthSigningAlg != null) {
            return this.tokenEndpointAuthSigningAlg.getAlgorithm();
        }
        return null;
    }

    public void setTokenEndpointAuthSigningAlg(JWSAlgorithm tokenEndpointAuthSigningAlg) {
        this.tokenEndpointAuthSigningAlg = new JWSAlgorithmEmbed(tokenEndpointAuthSigningAlg);
    }

    @Basic
    @Column(name="default_max_age")
    public Integer getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(Integer defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    @Basic
    @Column(name="require_auth_time")
    public Boolean getRequireAuthTime() {
        return this.requireAuthTime;
    }

    public void setRequireAuthTime(Boolean requireAuthTime) {
        this.requireAuthTime = requireAuthTime;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="client_response_type", joinColumns={@JoinColumn(name="owner_id")})
    @Column(name="response_type")
    public Set<String> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(Set<String> responseTypes) {
        this.responseTypes = responseTypes;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="client_default_acr_value", joinColumns={@JoinColumn(name="owner_id")})
    @Column(name="default_acr_value")
    public Set<String> getDefaultACRvalues() {
        return this.defaultACRvalues;
    }

    public void setDefaultACRvalues(Set<String> defaultACRvalues) {
        this.defaultACRvalues = defaultACRvalues;
    }

    @Basic
    @Column(name="initiate_login_uri")
    public String getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    @Basic
    @Column(name="post_logout_redirect_uri")
    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="client_request_uri", joinColumns={@JoinColumn(name="owner_id")})
    @Column(name="request_uri")
    public Set<String> getRequestUris() {
        return this.requestUris;
    }

    public void setRequestUris(Set<String> requestUris) {
        this.requestUris = requestUris;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_at")
    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public boolean isAutoApprove(String scope) {
        return false;
    }

    public static enum SubjectType {
        PAIRWISE("pairwise"),
        PUBLIC("public");

        private final String value;
        private static final Map<String, SubjectType> lookup;

        private SubjectType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SubjectType getByValue(String value) {
            return lookup.get(value);
        }

        static {
            lookup = new HashMap<String, SubjectType>();
            for (SubjectType u : SubjectType.values()) {
                lookup.put(u.getValue(), u);
            }
        }
    }

    public static enum AppType {
        WEB("web"),
        NATIVE("native");

        private final String value;
        private static final Map<String, AppType> lookup;

        private AppType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static AppType getByValue(String value) {
            return lookup.get(value);
        }

        static {
            lookup = new HashMap<String, AppType>();
            for (AppType a : AppType.values()) {
                lookup.put(a.getValue(), a);
            }
        }
    }

    public static enum AuthMethod {
        SECRET_POST("client_secret_post"),
        SECRET_BASIC("client_secret_basic"),
        SECRET_JWT("client_secret_jwt"),
        PRIVATE_KEY("private_key_jwt"),
        NONE("none");

        private final String value;
        private static final Map<String, AuthMethod> lookup;

        private AuthMethod(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static AuthMethod getByValue(String value) {
            return lookup.get(value);
        }

        static {
            lookup = new HashMap<String, AuthMethod>();
            for (AuthMethod a : AuthMethod.values()) {
                lookup.put(a.getValue(), a);
            }
        }
    }
}

